/*
 * Decompiled with CFR 0.152.
 */
package com.github.barteksc.pdfviewer;

import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.RectF;
import android.util.SparseBooleanArray;
import com.github.barteksc.pdfviewer.exception.PageRenderingException;
import com.github.barteksc.pdfviewer.util.FitPolicy;
import com.github.barteksc.pdfviewer.util.PageSizeCalculator;
import com.shockwave.pdfium.PdfDocument;
import com.shockwave.pdfium.PdfiumCore;
import com.shockwave.pdfium.util.Size;
import com.shockwave.pdfium.util.SizeF;
import java.util.ArrayList;
import java.util.List;

class PdfFile {
    private static final Object lock = new Object();
    private PdfDocument pdfDocument;
    private PdfiumCore pdfiumCore;
    private int pagesCount = 0;
    private List<Size> originalPageSizes = new ArrayList<Size>();
    private List<SizeF> pageSizes = new ArrayList<SizeF>();
    private SparseBooleanArray openedPages = new SparseBooleanArray();
    private Size originalMaxWidthPageSize = new Size(0, 0);
    private Size originalMaxHeightPageSize = new Size(0, 0);
    private SizeF maxHeightPageSize = new SizeF(0.0f, 0.0f);
    private SizeF maxWidthPageSize = new SizeF(0.0f, 0.0f);
    private boolean isVertical = true;
    private int spacingPx = 0;
    private boolean autoSpacing;
    private List<Float> pageOffsets = new ArrayList<Float>();
    private List<Float> pageSpacing = new ArrayList<Float>();
    private float documentLength = 0.0f;
    private final FitPolicy pageFitPolicy;
    private int[] originalUserPages;

    PdfFile(PdfiumCore pdfiumCore, PdfDocument pdfDocument, FitPolicy pageFitPolicy, Size viewSize, int[] originalUserPages, boolean isVertical, int spacing, boolean autoSpacing) {
        this.pdfiumCore = pdfiumCore;
        this.pdfDocument = pdfDocument;
        this.pageFitPolicy = pageFitPolicy;
        this.originalUserPages = originalUserPages;
        this.isVertical = isVertical;
        this.spacingPx = spacing;
        this.autoSpacing = autoSpacing;
        this.setup(viewSize);
    }

    private void setup(Size viewSize) {
        this.pagesCount = this.originalUserPages != null ? this.originalUserPages.length : this.pdfiumCore.getPageCount(this.pdfDocument);
        for (int i = 0; i < this.pagesCount; ++i) {
            Size pageSize = this.pdfiumCore.getPageSize(this.pdfDocument, this.documentPage(i));
            if (pageSize.getWidth() > this.originalMaxWidthPageSize.getWidth()) {
                this.originalMaxWidthPageSize = pageSize;
            }
            if (pageSize.getHeight() > this.originalMaxHeightPageSize.getHeight()) {
                this.originalMaxHeightPageSize = pageSize;
            }
            this.originalPageSizes.add(pageSize);
        }
        this.recalculatePageSizes(viewSize);
    }

    public void recalculatePageSizes(Size viewSize) {
        this.pageSizes.clear();
        PageSizeCalculator calculator = new PageSizeCalculator(this.pageFitPolicy, this.originalMaxWidthPageSize, this.originalMaxHeightPageSize, viewSize);
        this.maxWidthPageSize = calculator.getOptimalMaxWidthPageSize();
        this.maxHeightPageSize = calculator.getOptimalMaxHeightPageSize();
        for (Size size : this.originalPageSizes) {
            this.pageSizes.add(calculator.calculate(size));
        }
        if (this.autoSpacing) {
            this.prepareAutoSpacing(viewSize);
        }
        this.prepareDocLen();
        this.preparePagesOffset();
    }

    public int getPagesCount() {
        return this.pagesCount;
    }

    public SizeF getPageSize(int pageIndex) {
        int docPage = this.documentPage(pageIndex);
        if (docPage < 0) {
            return new SizeF(0.0f, 0.0f);
        }
        return this.pageSizes.get(pageIndex);
    }

    public SizeF getScaledPageSize(int pageIndex, float zoom) {
        SizeF size = this.getPageSize(pageIndex);
        return new SizeF(size.getWidth() * zoom, size.getHeight() * zoom);
    }

    public SizeF getMaxPageSize() {
        return this.isVertical ? this.maxWidthPageSize : this.maxHeightPageSize;
    }

    public float getMaxPageWidth() {
        return this.getMaxPageSize().getWidth();
    }

    public float getMaxPageHeight() {
        return this.getMaxPageSize().getHeight();
    }

    private void prepareAutoSpacing(Size viewSize) {
        this.pageSpacing.clear();
        for (int i = 0; i < this.getPagesCount(); ++i) {
            SizeF pageSize = this.pageSizes.get(i);
            float spacing = Math.max(0.0f, this.isVertical ? (float)viewSize.getHeight() - pageSize.getHeight() : (float)viewSize.getWidth() - pageSize.getWidth());
            if (i < this.getPagesCount() - 1) {
                spacing += (float)this.spacingPx;
            }
            this.pageSpacing.add(Float.valueOf(spacing));
        }
    }

    private void prepareDocLen() {
        float length = 0.0f;
        for (int i = 0; i < this.getPagesCount(); ++i) {
            SizeF pageSize = this.pageSizes.get(i);
            length += this.isVertical ? pageSize.getHeight() : pageSize.getWidth();
            if (this.autoSpacing) {
                length += this.pageSpacing.get(i).floatValue();
                continue;
            }
            if (i >= this.getPagesCount() - 1) continue;
            length += (float)this.spacingPx;
        }
        this.documentLength = length;
    }

    private void preparePagesOffset() {
        this.pageOffsets.clear();
        float offset = 0.0f;
        for (int i = 0; i < this.getPagesCount(); ++i) {
            float size;
            SizeF pageSize = this.pageSizes.get(i);
            float f = size = this.isVertical ? pageSize.getHeight() : pageSize.getWidth();
            if (this.autoSpacing) {
                offset += this.pageSpacing.get(i).floatValue() / 2.0f;
                if (i == 0) {
                    offset -= (float)this.spacingPx / 2.0f;
                } else if (i == this.getPagesCount() - 1) {
                    offset += (float)this.spacingPx / 2.0f;
                }
                this.pageOffsets.add(Float.valueOf(offset));
                offset += size + this.pageSpacing.get(i).floatValue() / 2.0f;
                continue;
            }
            this.pageOffsets.add(Float.valueOf(offset));
            offset += size + (float)this.spacingPx;
        }
    }

    public float getDocLen(float zoom) {
        return this.documentLength * zoom;
    }

    public float getPageLength(int pageIndex, float zoom) {
        SizeF size = this.getPageSize(pageIndex);
        return (this.isVertical ? size.getHeight() : size.getWidth()) * zoom;
    }

    public float getPageSpacing(int pageIndex, float zoom) {
        float spacing = this.autoSpacing ? this.pageSpacing.get(pageIndex).floatValue() : (float)this.spacingPx;
        return spacing * zoom;
    }

    public float getPageOffset(int pageIndex, float zoom) {
        int docPage = this.documentPage(pageIndex);
        if (docPage < 0) {
            return 0.0f;
        }
        return this.pageOffsets.get(pageIndex).floatValue() * zoom;
    }

    public float getSecondaryPageOffset(int pageIndex, float zoom) {
        SizeF pageSize = this.getPageSize(pageIndex);
        if (this.isVertical) {
            float maxWidth = this.getMaxPageWidth();
            return zoom * (maxWidth - pageSize.getWidth()) / 2.0f;
        }
        float maxHeight = this.getMaxPageHeight();
        return zoom * (maxHeight - pageSize.getHeight()) / 2.0f;
    }

    public int getPageAtOffset(float offset, float zoom) {
        float off;
        int currentPage = 0;
        for (int i = 0; i < this.getPagesCount() && !((off = this.pageOffsets.get(i).floatValue() * zoom - this.getPageSpacing(i, zoom) / 2.0f) >= offset); ++i) {
            ++currentPage;
        }
        return --currentPage >= 0 ? currentPage : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean openPage(int pageIndex) throws PageRenderingException {
        int docPage = this.documentPage(pageIndex);
        if (docPage < 0) {
            return false;
        }
        Object object = lock;
        synchronized (object) {
            if (this.openedPages.indexOfKey(docPage) < 0) {
                try {
                    this.pdfiumCore.openPage(this.pdfDocument, docPage);
                    this.openedPages.put(docPage, true);
                    return true;
                }
                catch (Exception e) {
                    this.openedPages.put(docPage, false);
                    throw new PageRenderingException(pageIndex, (Throwable)e);
                }
            }
            return false;
        }
    }

    public boolean pageHasError(int pageIndex) {
        int docPage = this.documentPage(pageIndex);
        return !this.openedPages.get(docPage, false);
    }

    public void renderPageBitmap(Bitmap bitmap, int pageIndex, Rect bounds, boolean annotationRendering) {
        int docPage = this.documentPage(pageIndex);
        this.pdfiumCore.renderPageBitmap(this.pdfDocument, bitmap, docPage, bounds.left, bounds.top, bounds.width(), bounds.height(), annotationRendering);
    }

    public PdfDocument.Meta getMetaData() {
        if (this.pdfDocument == null) {
            return null;
        }
        return this.pdfiumCore.getDocumentMeta(this.pdfDocument);
    }

    public List<PdfDocument.Bookmark> getBookmarks() {
        if (this.pdfDocument == null) {
            return new ArrayList<PdfDocument.Bookmark>();
        }
        return this.pdfiumCore.getTableOfContents(this.pdfDocument);
    }

    public List<PdfDocument.Link> getPageLinks(int pageIndex) {
        int docPage = this.documentPage(pageIndex);
        return this.pdfiumCore.getPageLinks(this.pdfDocument, docPage);
    }

    public RectF mapRectToDevice(int pageIndex, int startX, int startY, int sizeX, int sizeY, RectF rect) {
        int docPage = this.documentPage(pageIndex);
        return this.pdfiumCore.mapRectToDevice(this.pdfDocument, docPage, startX, startY, sizeX, sizeY, 0, rect);
    }

    public void dispose() {
        if (this.pdfiumCore != null && this.pdfDocument != null) {
            this.pdfiumCore.closeDocument(this.pdfDocument);
        }
        this.pdfDocument = null;
        this.originalUserPages = null;
    }

    public int determineValidPageNumberFrom(int userPage) {
        if (userPage <= 0) {
            return 0;
        }
        if (this.originalUserPages != null) {
            if (userPage >= this.originalUserPages.length) {
                return this.originalUserPages.length - 1;
            }
        } else if (userPage >= this.getPagesCount()) {
            return this.getPagesCount() - 1;
        }
        return userPage;
    }

    public int documentPage(int userPage) {
        int documentPage = userPage;
        if (this.originalUserPages != null) {
            if (userPage < 0 || userPage >= this.originalUserPages.length) {
                return -1;
            }
            documentPage = this.originalUserPages[userPage];
        }
        if (documentPage < 0 || userPage >= this.getPagesCount()) {
            return -1;
        }
        return documentPage;
    }
}

