/*
 * Decompiled with CFR 0.152.
 */
package com.github.barteksc.pdfviewer;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.AsyncTask;
import android.util.AttributeSet;
import android.util.Log;
import android.widget.RelativeLayout;
import com.github.barteksc.pdfviewer.AnimationManager;
import com.github.barteksc.pdfviewer.CacheManager;
import com.github.barteksc.pdfviewer.DecodingAsyncTask;
import com.github.barteksc.pdfviewer.DragPinchManager;
import com.github.barteksc.pdfviewer.PagesLoader;
import com.github.barteksc.pdfviewer.RenderingAsyncTask;
import com.github.barteksc.pdfviewer.exception.FileNotFoundException;
import com.github.barteksc.pdfviewer.listener.OnDrawListener;
import com.github.barteksc.pdfviewer.listener.OnErrorListener;
import com.github.barteksc.pdfviewer.listener.OnLoadCompleteListener;
import com.github.barteksc.pdfviewer.listener.OnPageChangeListener;
import com.github.barteksc.pdfviewer.listener.OnPageScrollListener;
import com.github.barteksc.pdfviewer.model.PagePart;
import com.github.barteksc.pdfviewer.scroll.ScrollHandle;
import com.github.barteksc.pdfviewer.util.ArrayUtils;
import com.github.barteksc.pdfviewer.util.MathUtils;
import com.shockwave.pdfium.PdfDocument;
import com.shockwave.pdfium.PdfiumCore;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class PDFView
extends RelativeLayout {
    private static final String TAG = PDFView.class.getSimpleName();
    public static final float DEFAULT_MAX_SCALE = 3.0f;
    public static final float DEFAULT_MID_SCALE = 1.75f;
    public static final float DEFAULT_MIN_SCALE = 1.0f;
    private float minZoom = 1.0f;
    private float midZoom = 1.75f;
    private float maxZoom = 3.0f;
    private ScrollDir scrollDir = ScrollDir.NONE;
    CacheManager cacheManager;
    private AnimationManager animationManager;
    private DragPinchManager dragPinchManager;
    private int[] originalUserPages;
    private int[] filteredUserPages;
    private int[] filteredUserPageIndexes;
    private int documentPageCount;
    private int currentPage;
    private int currentFilteredPage;
    private int pageWidth;
    private int pageHeight;
    private float optimalPageWidth;
    private float optimalPageHeight;
    private float currentXOffset = 0.0f;
    private float currentYOffset = 0.0f;
    private float zoom = 1.0f;
    private boolean recycled = true;
    private State state = State.DEFAULT;
    private DecodingAsyncTask decodingAsyncTask;
    RenderingAsyncTask renderingAsyncTask;
    private PagesLoader pagesLoader;
    private OnLoadCompleteListener onLoadCompleteListener;
    private OnErrorListener onErrorListener;
    private OnPageChangeListener onPageChangeListener;
    private OnPageScrollListener onPageScrollListener;
    private OnDrawListener onDrawListener;
    private Paint paint;
    private Paint debugPaint;
    private int defaultPage = 0;
    private boolean swipeVertical = true;
    private PdfiumCore pdfiumCore;
    private PdfDocument pdfDocument;
    private ScrollHandle scrollHandle;
    private boolean isScrollHandleInit = false;
    private boolean bestQuality = false;
    private boolean annotationRendering = false;

    ScrollHandle getScrollHandle() {
        return this.scrollHandle;
    }

    public PDFView(Context context, AttributeSet set) {
        super(context, set);
        if (this.isInEditMode()) {
            return;
        }
        this.cacheManager = new CacheManager();
        this.animationManager = new AnimationManager(this);
        this.dragPinchManager = new DragPinchManager(this, this.animationManager);
        this.paint = new Paint();
        this.debugPaint = new Paint();
        this.debugPaint.setStyle(Paint.Style.STROKE);
        this.pdfiumCore = new PdfiumCore(context);
        this.setWillNotDraw(false);
    }

    private void load(String path, boolean isAsset, String password, OnLoadCompleteListener listener, OnErrorListener onErrorListener) {
        this.load(path, isAsset, password, listener, onErrorListener, null);
    }

    private void load(String path, boolean isAsset, String password, OnLoadCompleteListener onLoadCompleteListener, OnErrorListener onErrorListener, int[] userPages) {
        if (!this.recycled) {
            throw new IllegalStateException("Don't call load on a PDF View without recycling it first.");
        }
        if (userPages != null) {
            this.originalUserPages = userPages;
            this.filteredUserPages = ArrayUtils.deleteDuplicatedPages(this.originalUserPages);
            this.filteredUserPageIndexes = ArrayUtils.calculateIndexesInDuplicateArray(this.originalUserPages);
        }
        this.onLoadCompleteListener = onLoadCompleteListener;
        this.onErrorListener = onErrorListener;
        this.recycled = false;
        this.decodingAsyncTask = new DecodingAsyncTask(path, isAsset, password, this, this.pdfiumCore);
        this.decodingAsyncTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
    }

    public void jumpTo(int page, boolean withAnimation) {
        if (this.swipeVertical) {
            float toY = (float)(-page) * this.toCurrentScale(this.optimalPageHeight);
            if (withAnimation) {
                this.animationManager.startYAnimation(this.currentYOffset, toY);
            } else {
                this.moveTo(this.currentXOffset, toY);
            }
        } else {
            float toX = (float)(-page) * this.toCurrentScale(this.optimalPageWidth);
            if (withAnimation) {
                this.animationManager.startXAnimation(this.currentXOffset, toX);
            } else {
                this.moveTo(toX, this.currentYOffset);
            }
        }
        this.showPage(page);
    }

    public void jumpTo(int page) {
        this.jumpTo(page, false);
    }

    void showPage(int pageNb) {
        if (this.recycled) {
            return;
        }
        this.state = State.SHOWN;
        this.currentPage = pageNb = this.determineValidPageNumberFrom(pageNb);
        this.currentFilteredPage = pageNb;
        if (this.filteredUserPageIndexes != null && pageNb >= 0 && pageNb < this.filteredUserPageIndexes.length) {
            this.currentFilteredPage = pageNb = this.filteredUserPageIndexes[pageNb];
        }
        this.loadPages();
        if (this.scrollHandle != null && !this.documentFitsView()) {
            this.scrollHandle.setPageNum(this.currentPage + 1);
        }
        if (this.onPageChangeListener != null) {
            this.onPageChangeListener.onPageChanged(this.currentPage, this.getPageCount());
        }
    }

    public float getPositionOffset() {
        float offset = this.swipeVertical ? -this.currentYOffset / ((float)this.getPageCount() * this.toCurrentScale(this.optimalPageHeight) - (float)this.getHeight()) : -this.currentXOffset / ((float)this.getPageCount() * this.toCurrentScale(this.optimalPageWidth) - (float)this.getWidth());
        return MathUtils.limit(offset, 0.0f, 1.0f);
    }

    public void setPositionOffset(float progress, boolean moveHandle) {
        if (this.swipeVertical) {
            this.moveTo(this.currentXOffset, ((float)(-this.getPageCount()) * this.toCurrentScale(this.optimalPageHeight) + (float)this.getHeight()) * progress, moveHandle);
        } else {
            this.moveTo(((float)(-this.getPageCount()) * this.toCurrentScale(this.optimalPageWidth) + (float)this.getWidth()) * progress, this.currentYOffset, moveHandle);
        }
        this.loadPageByOffset();
    }

    public void setPositionOffset(float progress) {
        this.setPositionOffset(progress, true);
    }

    public void stopFling() {
        this.animationManager.stopFling();
    }

    public int getPageCount() {
        if (this.originalUserPages != null) {
            return this.originalUserPages.length;
        }
        return this.documentPageCount;
    }

    public void enableSwipe(boolean enableSwipe) {
        this.dragPinchManager.setSwipeEnabled(enableSwipe);
    }

    public void enableDoubletap(boolean enableDoubletap) {
        this.dragPinchManager.enableDoubletap(enableDoubletap);
    }

    private void setOnPageChangeListener(OnPageChangeListener onPageChangeListener) {
        this.onPageChangeListener = onPageChangeListener;
    }

    OnPageChangeListener getOnPageChangeListener() {
        return this.onPageChangeListener;
    }

    private void setOnPageScrollListener(OnPageScrollListener onPageScrollListener) {
        this.onPageScrollListener = onPageScrollListener;
    }

    OnPageScrollListener getOnPageScrollListener() {
        return this.onPageScrollListener;
    }

    private void setOnDrawListener(OnDrawListener onDrawListener) {
        this.onDrawListener = onDrawListener;
    }

    public void recycle() {
        this.animationManager.stopAll();
        if (this.renderingAsyncTask != null) {
            this.renderingAsyncTask.cancel(true);
        }
        if (this.decodingAsyncTask != null) {
            this.decodingAsyncTask.cancel(true);
        }
        this.cacheManager.recycle();
        if (this.scrollHandle != null && this.isScrollHandleInit) {
            this.scrollHandle.destroyLayout();
        }
        if (this.pdfiumCore != null && this.pdfDocument != null) {
            this.pdfiumCore.closeDocument(this.pdfDocument);
        }
        this.originalUserPages = null;
        this.filteredUserPages = null;
        this.filteredUserPageIndexes = null;
        this.pdfDocument = null;
        this.scrollHandle = null;
        this.isScrollHandleInit = false;
        this.currentYOffset = 0.0f;
        this.currentXOffset = 0.0f;
        this.zoom = 1.0f;
        this.recycled = true;
        this.state = State.DEFAULT;
    }

    public boolean isRecycled() {
        return this.recycled;
    }

    protected void onDetachedFromWindow() {
        this.recycle();
        super.onDetachedFromWindow();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        if (this.isInEditMode()) {
            return;
        }
        this.animationManager.stopAll();
        this.calculateOptimalWidthAndHeight();
        this.loadPages();
        if (this.swipeVertical) {
            this.moveTo(this.currentXOffset, this.calculateCenterOffsetForPage(this.currentFilteredPage));
        } else {
            this.moveTo(this.calculateCenterOffsetForPage(this.currentFilteredPage), this.currentYOffset);
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.isInEditMode()) {
            return;
        }
        Drawable bg = this.getBackground();
        if (bg == null) {
            canvas.drawColor(-1);
        } else {
            bg.draw(canvas);
        }
        if (this.recycled) {
            return;
        }
        if (this.state != State.SHOWN) {
            return;
        }
        float currentXOffset = this.currentXOffset;
        float currentYOffset = this.currentYOffset;
        canvas.translate(currentXOffset, currentYOffset);
        for (PagePart part : this.cacheManager.getThumbnails()) {
            this.drawPart(canvas, part);
        }
        for (PagePart part : this.cacheManager.getPageParts()) {
            this.drawPart(canvas, part);
        }
        if (this.onDrawListener != null) {
            canvas.translate(this.toCurrentScale((float)this.currentFilteredPage * this.optimalPageWidth), 0.0f);
            this.onDrawListener.onLayerDrawn(canvas, this.toCurrentScale(this.optimalPageWidth), this.toCurrentScale(this.optimalPageHeight), this.currentPage);
            canvas.translate(-this.toCurrentScale((float)this.currentFilteredPage * this.optimalPageWidth), 0.0f);
        }
        canvas.translate(-currentXOffset, -currentYOffset);
    }

    private void drawPart(Canvas canvas, PagePart part) {
        RectF pageRelativeBounds = part.getPageRelativeBounds();
        Bitmap renderedBitmap = part.getRenderedBitmap();
        if (renderedBitmap.isRecycled()) {
            return;
        }
        float localTranslationX = 0.0f;
        float localTranslationY = 0.0f;
        if (this.swipeVertical) {
            localTranslationY = this.toCurrentScale((float)part.getUserPage() * this.optimalPageHeight);
        } else {
            localTranslationX = this.toCurrentScale((float)part.getUserPage() * this.optimalPageWidth);
        }
        canvas.translate(localTranslationX, localTranslationY);
        Rect srcRect = new Rect(0, 0, renderedBitmap.getWidth(), renderedBitmap.getHeight());
        float offsetX = this.toCurrentScale(pageRelativeBounds.left * this.optimalPageWidth);
        float offsetY = this.toCurrentScale(pageRelativeBounds.top * this.optimalPageHeight);
        float width = this.toCurrentScale(pageRelativeBounds.width() * this.optimalPageWidth);
        float height = this.toCurrentScale(pageRelativeBounds.height() * this.optimalPageHeight);
        RectF dstRect = new RectF((float)((int)offsetX), (float)((int)offsetY), (float)((int)(offsetX + width)), (float)((int)(offsetY + height)));
        float translationX = this.currentXOffset + localTranslationX;
        float translationY = this.currentYOffset + localTranslationY;
        if (translationX + dstRect.left >= (float)this.getWidth() || translationX + dstRect.right <= 0.0f || translationY + dstRect.top >= (float)this.getHeight() || translationY + dstRect.bottom <= 0.0f) {
            canvas.translate(-localTranslationX, -localTranslationY);
            return;
        }
        canvas.drawBitmap(renderedBitmap, srcRect, dstRect, this.paint);
        canvas.translate(-localTranslationX, -localTranslationY);
    }

    public void loadPages() {
        if (this.optimalPageWidth == 0.0f || this.optimalPageHeight == 0.0f) {
            return;
        }
        this.renderingAsyncTask.removeAllTasks();
        this.cacheManager.makeANewSet();
        this.pagesLoader.loadPages();
        this.redraw();
    }

    public void loadComplete(PdfDocument pdfDocument) {
        this.state = State.LOADED;
        this.documentPageCount = this.pdfiumCore.getPageCount(pdfDocument);
        int firstPageIdx = 0;
        if (this.originalUserPages != null) {
            firstPageIdx = this.originalUserPages[0];
        }
        this.pdfDocument = pdfDocument;
        this.pdfiumCore.openPage(pdfDocument, firstPageIdx);
        this.pageWidth = this.pdfiumCore.getPageWidth(pdfDocument, firstPageIdx);
        this.pageHeight = this.pdfiumCore.getPageHeight(pdfDocument, firstPageIdx);
        this.calculateOptimalWidthAndHeight();
        this.pagesLoader = new PagesLoader(this);
        this.renderingAsyncTask = new RenderingAsyncTask(this, this.pdfiumCore, pdfDocument);
        this.renderingAsyncTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
        if (this.scrollHandle != null) {
            this.scrollHandle.setupLayout(this);
            this.isScrollHandleInit = true;
        }
        this.jumpTo(this.defaultPage, false);
        if (this.onLoadCompleteListener != null) {
            this.onLoadCompleteListener.loadComplete(this.documentPageCount);
        }
    }

    public void loadError(Throwable t) {
        this.state = State.ERROR;
        this.recycle();
        this.invalidate();
        if (this.onErrorListener != null) {
            this.onErrorListener.onError(t);
        } else {
            Log.e((String)"PDFView", (String)"load pdf error", (Throwable)t);
        }
    }

    void redraw() {
        this.invalidate();
    }

    public void onBitmapRendered(PagePart part) {
        if (part.isThumbnail()) {
            this.cacheManager.cacheThumbnail(part);
        } else {
            this.cacheManager.cachePart(part);
        }
        this.redraw();
    }

    private int determineValidPageNumberFrom(int userPage) {
        if (userPage <= 0) {
            return 0;
        }
        if (this.originalUserPages != null) {
            if (userPage >= this.originalUserPages.length) {
                return this.originalUserPages.length - 1;
            }
        } else if (userPage >= this.documentPageCount) {
            return this.documentPageCount - 1;
        }
        return userPage;
    }

    private float calculateCenterOffsetForPage(int pageNb) {
        if (this.swipeVertical) {
            float imageY = -((float)pageNb * this.optimalPageHeight);
            return imageY += (float)(this.getHeight() / 2) - this.optimalPageHeight / 2.0f;
        }
        float imageX = -((float)pageNb * this.optimalPageWidth);
        return imageX += (float)(this.getWidth() / 2) - this.optimalPageWidth / 2.0f;
    }

    private void calculateOptimalWidthAndHeight() {
        if (this.state == State.DEFAULT || this.getWidth() == 0) {
            return;
        }
        float maxWidth = this.getWidth();
        float maxHeight = this.getHeight();
        float w = this.pageWidth;
        float h = this.pageHeight;
        float ratio = w / h;
        w = maxWidth;
        h = (float)Math.floor(maxWidth / ratio);
        if (h > maxHeight) {
            h = maxHeight;
            w = (float)Math.floor(maxHeight * ratio);
        }
        this.optimalPageWidth = w;
        this.optimalPageHeight = h;
    }

    public void moveTo(float offsetX, float offsetY) {
        this.moveTo(offsetX, offsetY, true);
    }

    public void moveTo(float offsetX, float offsetY, boolean moveHandle) {
        if (this.swipeVertical) {
            if (this.toCurrentScale(this.optimalPageWidth) < (float)this.getWidth()) {
                offsetX = (float)(this.getWidth() / 2) - this.toCurrentScale(this.optimalPageWidth) / 2.0f;
            } else if (offsetX > 0.0f) {
                offsetX = 0.0f;
            } else if (offsetX + this.toCurrentScale(this.optimalPageWidth) < (float)this.getWidth()) {
                offsetX = (float)this.getWidth() - this.toCurrentScale(this.optimalPageWidth);
            }
            if ((float)this.getPageCount() * this.toCurrentScale(this.optimalPageHeight) < (float)this.getHeight()) {
                offsetY = ((float)this.getHeight() - (float)this.getPageCount() * this.toCurrentScale(this.optimalPageHeight)) / 2.0f;
            } else if (offsetY > 0.0f) {
                offsetY = 0.0f;
            } else if (offsetY + this.toCurrentScale((float)this.getPageCount() * this.optimalPageHeight) < (float)this.getHeight()) {
                offsetY = -this.toCurrentScale((float)this.getPageCount() * this.optimalPageHeight) + (float)this.getHeight();
            }
            this.scrollDir = offsetY < this.currentYOffset ? ScrollDir.END : (offsetY > this.currentYOffset ? ScrollDir.START : ScrollDir.NONE);
        } else {
            if (this.toCurrentScale(this.optimalPageHeight) < (float)this.getHeight()) {
                offsetY = (float)(this.getHeight() / 2) - this.toCurrentScale(this.optimalPageHeight) / 2.0f;
            } else if (offsetY > 0.0f) {
                offsetY = 0.0f;
            } else if (offsetY + this.toCurrentScale(this.optimalPageHeight) < (float)this.getHeight()) {
                offsetY = (float)this.getHeight() - this.toCurrentScale(this.optimalPageHeight);
            }
            if ((float)this.getPageCount() * this.toCurrentScale(this.optimalPageWidth) < (float)this.getWidth()) {
                offsetX = ((float)this.getWidth() - (float)this.getPageCount() * this.toCurrentScale(this.optimalPageWidth)) / 2.0f;
            } else if (offsetX > 0.0f) {
                offsetX = 0.0f;
            } else if (offsetX + this.toCurrentScale((float)this.getPageCount() * this.optimalPageWidth) < (float)this.getWidth()) {
                offsetX = -this.toCurrentScale((float)this.getPageCount() * this.optimalPageWidth) + (float)this.getWidth();
            }
            this.scrollDir = offsetX < this.currentXOffset ? ScrollDir.END : (offsetX > this.currentXOffset ? ScrollDir.START : ScrollDir.NONE);
        }
        this.currentXOffset = offsetX;
        this.currentYOffset = offsetY;
        float positionOffset = this.getPositionOffset();
        if (moveHandle && this.scrollHandle != null && !this.documentFitsView()) {
            this.scrollHandle.setScroll(positionOffset);
        }
        if (this.onPageScrollListener != null) {
            this.onPageScrollListener.onPageScrolled(this.getCurrentPage(), positionOffset);
        }
        this.redraw();
    }

    ScrollDir getScrollDir() {
        return this.scrollDir;
    }

    void loadPageByOffset() {
        float optimal;
        float offset;
        if (this.swipeVertical) {
            offset = this.currentYOffset;
            optimal = this.optimalPageHeight;
        } else {
            offset = this.currentXOffset;
            optimal = this.optimalPageWidth;
        }
        int page = (int)Math.floor((Math.abs(offset) + (float)(this.getHeight() / 5)) / this.toCurrentScale(optimal));
        if (page >= 0 && page <= this.getPageCount() - 1 && page != this.getCurrentPage()) {
            this.showPage(page);
        } else {
            this.loadPages();
        }
    }

    int[] getFilteredUserPages() {
        return this.filteredUserPages;
    }

    int getDocumentPageCount() {
        return this.documentPageCount;
    }

    public void moveRelativeTo(float dx, float dy) {
        this.moveTo(this.currentXOffset + dx, this.currentYOffset + dy);
    }

    public void zoomTo(float zoom) {
        this.zoom = zoom;
    }

    public void zoomCenteredTo(float zoom, PointF pivot) {
        float dzoom = zoom / this.zoom;
        this.zoomTo(zoom);
        float baseX = this.currentXOffset * dzoom;
        float baseY = this.currentYOffset * dzoom;
        this.moveTo(baseX += pivot.x - pivot.x * dzoom, baseY += pivot.y - pivot.y * dzoom);
    }

    public void zoomCenteredRelativeTo(float dzoom, PointF pivot) {
        this.zoomCenteredTo(this.zoom * dzoom, pivot);
    }

    public boolean documentFitsView() {
        if (this.swipeVertical) {
            return (float)this.getPageCount() * this.optimalPageHeight < (float)this.getHeight();
        }
        return (float)this.getPageCount() * this.optimalPageWidth < (float)this.getWidth();
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public float getCurrentXOffset() {
        return this.currentXOffset;
    }

    public float getCurrentYOffset() {
        return this.currentYOffset;
    }

    public float toRealScale(float size) {
        return size / this.zoom;
    }

    public float toCurrentScale(float size) {
        return size * this.zoom;
    }

    public float getZoom() {
        return this.zoom;
    }

    public boolean isZooming() {
        return this.zoom != this.minZoom;
    }

    public float getOptimalPageWidth() {
        return this.optimalPageWidth;
    }

    public float getOptimalPageHeight() {
        return this.optimalPageHeight;
    }

    private void setDefaultPage(int defaultPage) {
        this.defaultPage = defaultPage;
    }

    public void resetZoom() {
        this.zoomTo(this.minZoom);
    }

    public void resetZoomWithAnimation() {
        this.zoomWithAnimation(this.minZoom);
    }

    public void zoomWithAnimation(float centerX, float centerY, float scale) {
        this.animationManager.startZoomAnimation(centerX, centerY, this.zoom, scale);
    }

    public void zoomWithAnimation(float scale) {
        this.animationManager.startZoomAnimation(this.getWidth() / 2, this.getHeight() / 2, this.zoom, scale);
    }

    private void setScrollHandle(ScrollHandle scrollHandle) {
        this.scrollHandle = scrollHandle;
    }

    public int getPageAtPositionOffset(float positionOffset) {
        float viewDimension;
        float optimalSize;
        int direction;
        int n = direction = this.scrollDir == ScrollDir.END ? 1 : -1;
        if (this.swipeVertical) {
            optimalSize = this.toCurrentScale(this.optimalPageHeight);
            viewDimension = this.getHeight() * direction;
        } else {
            optimalSize = this.toCurrentScale(this.optimalPageWidth);
            viewDimension = this.getWidth() * direction;
        }
        return (int)Math.floor((float)this.getPageCount() * positionOffset + viewDimension / 5.0f / optimalSize);
    }

    public float getMinZoom() {
        return this.minZoom;
    }

    public void setMinZoom(float minZoom) {
        this.minZoom = minZoom;
    }

    public float getMidZoom() {
        return this.midZoom;
    }

    public void setMidZoom(float midZoom) {
        this.midZoom = midZoom;
    }

    public float getMaxZoom() {
        return this.maxZoom;
    }

    public void setMaxZoom(float maxZoom) {
        this.maxZoom = maxZoom;
    }

    public void useBestQuality(boolean bestQuality) {
        this.bestQuality = bestQuality;
    }

    public boolean isBestQuality() {
        return this.bestQuality;
    }

    public boolean isSwipeVertical() {
        return this.swipeVertical;
    }

    public void setSwipeVertical(boolean swipeVertical) {
        this.swipeVertical = swipeVertical;
    }

    public void enableAnnotationRendering(boolean annotationRendering) {
        this.annotationRendering = annotationRendering;
    }

    public boolean isAnnotationRendering() {
        return this.annotationRendering;
    }

    public PdfDocument.Meta getDocumentMeta() {
        if (this.pdfDocument == null) {
            return null;
        }
        return this.pdfiumCore.getDocumentMeta(this.pdfDocument);
    }

    public List<PdfDocument.Bookmark> getTableOfContents() {
        if (this.pdfDocument == null) {
            return new ArrayList<PdfDocument.Bookmark>();
        }
        return this.pdfiumCore.getTableOfContents(this.pdfDocument);
    }

    public Configurator fromAsset(String assetName) {
        InputStream stream = null;
        try {
            stream = this.getContext().getAssets().open(assetName);
            Configurator configurator = new Configurator(assetName, true);
            return configurator;
        }
        catch (IOException e) {
            throw new FileNotFoundException(assetName + " does not exist.", e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public Configurator fromFile(File file) {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath() + " does not exist.");
        }
        return new Configurator(file.getAbsolutePath(), false);
    }

    public Configurator fromUri(Uri uri) {
        return new Configurator(uri.toString(), false);
    }

    public class Configurator {
        private final String path;
        private final boolean isAsset;
        private int[] pageNumbers = null;
        private boolean enableSwipe = true;
        private boolean enableDoubletap = true;
        private OnDrawListener onDrawListener;
        private OnLoadCompleteListener onLoadCompleteListener;
        private OnErrorListener onErrorListener;
        private OnPageChangeListener onPageChangeListener;
        private OnPageScrollListener onPageScrollListener;
        private int defaultPage = 0;
        private boolean swipeHorizontal = false;
        private boolean annotationRendering = false;
        private String password = null;
        private ScrollHandle scrollHandle = null;

        private Configurator(String path, boolean isAsset) {
            this.path = path;
            this.isAsset = isAsset;
        }

        public Configurator pages(int ... pageNumbers) {
            this.pageNumbers = pageNumbers;
            return this;
        }

        public Configurator enableSwipe(boolean enableSwipe) {
            this.enableSwipe = enableSwipe;
            return this;
        }

        public Configurator enableDoubletap(boolean enableDoubletap) {
            this.enableDoubletap = enableDoubletap;
            return this;
        }

        public Configurator enableAnnotationRendering(boolean annotationRendering) {
            this.annotationRendering = annotationRendering;
            return this;
        }

        public Configurator onDraw(OnDrawListener onDrawListener) {
            this.onDrawListener = onDrawListener;
            return this;
        }

        public Configurator onLoad(OnLoadCompleteListener onLoadCompleteListener) {
            this.onLoadCompleteListener = onLoadCompleteListener;
            return this;
        }

        public Configurator onPageScroll(OnPageScrollListener onPageScrollListener) {
            this.onPageScrollListener = onPageScrollListener;
            return this;
        }

        public Configurator onError(OnErrorListener onErrorListener) {
            this.onErrorListener = onErrorListener;
            return this;
        }

        public Configurator onPageChange(OnPageChangeListener onPageChangeListener) {
            this.onPageChangeListener = onPageChangeListener;
            return this;
        }

        public Configurator defaultPage(int defaultPage) {
            this.defaultPage = defaultPage;
            return this;
        }

        public Configurator swipeHorizontal(boolean swipeHorizontal) {
            this.swipeHorizontal = swipeHorizontal;
            return this;
        }

        public Configurator password(String password) {
            this.password = password;
            return this;
        }

        public Configurator scrollHandle(ScrollHandle scrollHandle) {
            this.scrollHandle = scrollHandle;
            return this;
        }

        public void load() {
            PDFView.this.recycle();
            PDFView.this.setOnDrawListener(this.onDrawListener);
            PDFView.this.setOnPageChangeListener(this.onPageChangeListener);
            PDFView.this.setOnPageScrollListener(this.onPageScrollListener);
            PDFView.this.enableSwipe(this.enableSwipe);
            PDFView.this.enableDoubletap(this.enableDoubletap);
            PDFView.this.setDefaultPage(this.defaultPage);
            PDFView.this.setSwipeVertical(!this.swipeHorizontal);
            PDFView.this.enableAnnotationRendering(this.annotationRendering);
            PDFView.this.setScrollHandle(this.scrollHandle);
            PDFView.this.dragPinchManager.setSwipeVertical(PDFView.this.swipeVertical);
            if (this.pageNumbers != null) {
                PDFView.this.load(this.path, this.isAsset, this.password, this.onLoadCompleteListener, this.onErrorListener, this.pageNumbers);
            } else {
                PDFView.this.load(this.path, this.isAsset, this.password, this.onLoadCompleteListener, this.onErrorListener);
            }
        }
    }

    private static enum State {
        DEFAULT,
        LOADED,
        SHOWN,
        ERROR;

    }

    static enum ScrollDir {
        NONE,
        START,
        END;

    }
}

