/*
 * Decompiled with CFR 0.152.
 */
package com.github.barteksc.pdfviewer;

import android.graphics.RectF;
import android.support.annotation.Nullable;
import com.github.barteksc.pdfviewer.model.PagePart;
import com.github.barteksc.pdfviewer.util.Constants;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;

class CacheManager {
    private final PriorityQueue<PagePart> passiveCache;
    private final PriorityQueue<PagePart> activeCache;
    private final List<PagePart> thumbnails;
    private final Object passiveActiveLock = new Object();
    private final PagePartComparator comparator = new PagePartComparator();

    public CacheManager() {
        this.activeCache = new PriorityQueue<PagePart>(Constants.Cache.CACHE_SIZE, this.comparator);
        this.passiveCache = new PriorityQueue<PagePart>(Constants.Cache.CACHE_SIZE, this.comparator);
        this.thumbnails = new ArrayList<PagePart>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cachePart(PagePart part) {
        Object object = this.passiveActiveLock;
        synchronized (object) {
            this.makeAFreeSpace();
            this.activeCache.offer(part);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeANewSet() {
        Object object = this.passiveActiveLock;
        synchronized (object) {
            this.passiveCache.addAll(this.activeCache);
            this.activeCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeAFreeSpace() {
        Object object = this.passiveActiveLock;
        synchronized (object) {
            while (this.activeCache.size() + this.passiveCache.size() >= Constants.Cache.CACHE_SIZE && !this.passiveCache.isEmpty()) {
                PagePart part = this.passiveCache.poll();
                part.getRenderedBitmap().recycle();
            }
            while (this.activeCache.size() + this.passiveCache.size() >= Constants.Cache.CACHE_SIZE && !this.activeCache.isEmpty()) {
                this.activeCache.poll().getRenderedBitmap().recycle();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheThumbnail(PagePart part) {
        List<PagePart> list = this.thumbnails;
        synchronized (list) {
            if (this.thumbnails.size() >= 6) {
                this.thumbnails.remove(0).getRenderedBitmap().recycle();
            }
            this.thumbnails.add(part);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean upPartIfContained(int userPage, int page, float width, float height, RectF pageRelativeBounds, int toOrder) {
        PagePart fakePart = new PagePart(userPage, page, null, width, height, pageRelativeBounds, false, 0);
        Object object = this.passiveActiveLock;
        synchronized (object) {
            PagePart found = CacheManager.find(this.passiveCache, fakePart);
            if (found != null) {
                this.passiveCache.remove(found);
                found.setCacheOrder(toOrder);
                this.activeCache.offer(found);
                return true;
            }
            return CacheManager.find(this.activeCache, fakePart) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsThumbnail(int userPage, int page, float width, float height, RectF pageRelativeBounds) {
        PagePart fakePart = new PagePart(userPage, page, null, width, height, pageRelativeBounds, true, 0);
        List<PagePart> list = this.thumbnails;
        synchronized (list) {
            for (PagePart part : this.thumbnails) {
                if (!part.equals(fakePart)) continue;
                return true;
            }
            return false;
        }
    }

    @Nullable
    private static PagePart find(PriorityQueue<PagePart> vector, PagePart fakePart) {
        for (PagePart part : vector) {
            if (!part.equals(fakePart)) continue;
            return part;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PagePart> getPageParts() {
        Object object = this.passiveActiveLock;
        synchronized (object) {
            ArrayList<PagePart> parts = new ArrayList<PagePart>(this.passiveCache);
            parts.addAll(this.activeCache);
            return parts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PagePart> getThumbnails() {
        List<PagePart> list = this.thumbnails;
        synchronized (list) {
            return this.thumbnails;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle() {
        List<PagePart> list = this.passiveActiveLock;
        synchronized (list) {
            for (PagePart part : this.passiveCache) {
                part.getRenderedBitmap().recycle();
            }
            this.passiveCache.clear();
            for (PagePart part : this.activeCache) {
                part.getRenderedBitmap().recycle();
            }
            this.activeCache.clear();
        }
        list = this.thumbnails;
        synchronized (list) {
            for (PagePart part : this.thumbnails) {
                part.getRenderedBitmap().recycle();
            }
            this.thumbnails.clear();
        }
    }

    class PagePartComparator
    implements Comparator<PagePart> {
        PagePartComparator() {
        }

        @Override
        public int compare(PagePart part1, PagePart part2) {
            if (part1.getCacheOrder() == part2.getCacheOrder()) {
                return 0;
            }
            return part1.getCacheOrder() > part2.getCacheOrder() ? 1 : -1;
        }
    }
}

