/*
 * Decompiled with CFR 0.152.
 */
package com.github.barteksc.pdfviewer;

import android.content.Context;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.ParcelFileDescriptor;
import com.github.barteksc.pdfviewer.PDFView;
import com.github.barteksc.pdfviewer.util.FileUtils;
import com.shockwave.pdfium.PdfDocument;
import com.shockwave.pdfium.PdfiumCore;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.URI;

class DecodingAsyncTask
extends AsyncTask<Void, Void, Throwable> {
    private boolean cancelled = false;
    private String path;
    private boolean isAsset;
    private PDFView pdfView;
    private Context context;
    private PdfiumCore pdfiumCore;
    private PdfDocument pdfDocument;

    public DecodingAsyncTask(String path, boolean isAsset, PDFView pdfView, PdfiumCore pdfiumCore) {
        this.pdfView = pdfView;
        this.isAsset = isAsset;
        this.pdfiumCore = pdfiumCore;
        this.path = path;
        this.context = pdfView.getContext();
    }

    protected Throwable doInBackground(Void ... params) {
        try {
            if (this.isAsset) {
                this.path = FileUtils.fileFromAsset(this.context, this.path).getAbsolutePath();
            }
            this.pdfDocument = this.pdfiumCore.newDocument(this.getSeekableFileDescriptor(this.path));
            return null;
        }
        catch (Throwable t) {
            return t;
        }
    }

    protected FileDescriptor getSeekableFileDescriptor(String path) throws IOException {
        File pdfCopy = new File(path);
        if (pdfCopy.exists()) {
            ParcelFileDescriptor pfd = ParcelFileDescriptor.open((File)pdfCopy, (int)0x10000000);
            return pfd.getFileDescriptor();
        }
        URI uri = URI.create(String.format("file://%s", path));
        ParcelFileDescriptor pfd = this.context.getContentResolver().openFileDescriptor(Uri.parse((String)uri.toString()), "rw");
        if (pfd == null) {
            throw new IOException("Cannot get FileDescriptor for " + path);
        }
        return pfd.getFileDescriptor();
    }

    protected void onPostExecute(Throwable t) {
        if (t != null) {
            this.pdfView.loadError(t);
            return;
        }
        if (!this.cancelled) {
            this.pdfView.loadComplete(this.pdfDocument);
        }
    }

    protected void onCancelled() {
        this.cancelled = true;
    }
}

