/*
 * Decompiled with CFR 0.152.
 */
package com.naman14.androidlame;

import android.media.MediaPlayer;
import android.os.Looper;
import android.text.TextUtils;
import com.naman14.androidlame.Mp3Player;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\nJ\u0006\u0010\f\u001a\u00020\u0004J\b\u0010\r\u001a\u00020\u000eH\u0002J\u0006\u0010\u000f\u001a\u00020\u000eJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0011J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0014\u001a\u00020\u0015J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0017\u001a\u00020\u0015H\u0002J\u0006\u0010\u0018\u001a\u00020\u0011R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0019"}, d2={"Lcom/naman14/androidlame/Mp3Player;", "", "()V", "mediaPlayer", "Landroid/media/MediaPlayer;", "getMediaPlayer", "()Landroid/media/MediaPlayer;", "mediaPlayer$delegate", "Lkotlin/Lazy;", "getCurPosition", "", "getDuration", "getPlayer", "isMainThread", "", "isPlaying", "pause", "", "resume", "start", "_filePath", "", "startPlayByThread", "filePath", "stop", "android-lame_release"})
public final class Mp3Player {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final Lazy mediaPlayer$delegate = LazyKt.lazy((Function0)mediaPlayer.2.INSTANCE);

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Mp3Player.class), "mediaPlayer", "getMediaPlayer()Landroid/media/MediaPlayer;"))};
    }

    private final MediaPlayer getMediaPlayer() {
        Lazy lazy = this.mediaPlayer$delegate;
        Mp3Player mp3Player = this;
        KProperty kProperty = $$delegatedProperties[0];
        boolean bl = false;
        return (MediaPlayer)lazy.getValue();
    }

    @Nullable
    public final MediaPlayer start(@NotNull String _filePath) {
        Intrinsics.checkParameterIsNotNull((Object)_filePath, (String)"_filePath");
        if (TextUtils.isEmpty((CharSequence)_filePath)) {
            return null;
        }
        return this.startPlayByThread(_filePath);
    }

    private final MediaPlayer startPlayByThread(String filePath) throws Exception {
        if (this.isMainThread()) {
            return null;
        }
        this.getMediaPlayer().stop();
        this.getMediaPlayer().reset();
        this.getMediaPlayer().setDataSource(filePath);
        this.getMediaPlayer().prepare();
        this.getMediaPlayer().start();
        return this.getMediaPlayer();
    }

    public final void stop() {
        this.getMediaPlayer().stop();
        this.getMediaPlayer().release();
    }

    public final void pause() {
        this.getMediaPlayer().pause();
    }

    public final void resume() {
        this.getMediaPlayer().start();
    }

    public final int getCurPosition() {
        if (this.getMediaPlayer() == null) {
            return -1;
        }
        MediaPlayer mediaPlayer2 = this.getMediaPlayer();
        if (mediaPlayer2 == null) {
            Intrinsics.throwNpe();
        }
        return mediaPlayer2.getCurrentPosition();
    }

    public final int getDuration() {
        if (this.getMediaPlayer() == null) {
            return -1;
        }
        MediaPlayer mediaPlayer2 = this.getMediaPlayer();
        if (mediaPlayer2 == null) {
            Intrinsics.throwNpe();
        }
        return mediaPlayer2.getDuration();
    }

    public final boolean isPlaying() {
        if (this.getMediaPlayer() == null) {
            return false;
        }
        MediaPlayer mediaPlayer2 = this.getMediaPlayer();
        if (mediaPlayer2 == null) {
            Intrinsics.throwNpe();
        }
        return mediaPlayer2.isPlaying();
    }

    @NotNull
    public final MediaPlayer getPlayer() {
        return this.getMediaPlayer();
    }

    private final boolean isMainThread() {
        Looper looper = Looper.getMainLooper();
        Intrinsics.checkExpressionValueIsNotNull((Object)looper, (String)"Looper.getMainLooper()");
        return looper.getThread() == Thread.currentThread();
    }
}

