/*
 * Decompiled with CFR 0.152.
 */
package com.naman14.androidlame;

import com.naman14.androidlame.InvalidWaveException;
import com.naman14.androidlame.LameUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0017\n\u0002\b\u0005\u0018\u0000 %2\u00020\u0001:\u0001%B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u001dJ\u0016\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\nJ\u001e\u0010\u001f\u001a\u00020\n2\u0006\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020!2\u0006\u0010\"\u001a\u00020\nR\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\rR\u0011\u0010\u0012\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\rR\u000e\u0010\u0014\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0018\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\rR\u001e\u0010\u001a\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\r\u00a8\u0006&"}, d2={"Lcom/naman14/androidlame/WaveReader;", "", "path", "", "name", "(Ljava/lang/String;Ljava/lang/String;)V", "file", "Ljava/io/File;", "(Ljava/io/File;)V", "<set-?>", "", "channels", "getChannels", "()I", "dataSize", "getDataSize", "fileSize", "getFileSize", "length", "getLength", "mFileSize", "mInFile", "mInStream", "Ljava/io/BufferedInputStream;", "pcmFormat", "getPcmFormat", "sampleRate", "getSampleRate", "closeWaveFile", "", "openWave", "read", "dst", "", "numSamples", "left", "right", "Companion", "android-lame_release"})
public final class WaveReader {
    private File mInFile;
    private BufferedInputStream mInStream;
    private int sampleRate;
    private int channels;
    private int pcmFormat;
    private int mFileSize;
    private int dataSize;
    private static final int WAV_HEADER_CHUNK_ID = 1380533830;
    private static final int WAV_FORMAT = 1463899717;
    private static final int WAV_FORMAT_CHUNK_ID = 1718449184;
    private static final int WAV_DATA_CHUNK_ID = 1684108385;
    private static final int STREAM_BUFFER_SIZE = 4096;
    public static final Companion Companion = new Companion(null);

    public final int getSampleRate() {
        return this.sampleRate;
    }

    public final int getChannels() {
        return this.channels;
    }

    public final int getPcmFormat() {
        return this.pcmFormat;
    }

    public final int getDataSize() {
        return this.dataSize;
    }

    public final int getFileSize() {
        return this.mFileSize + 8;
    }

    public final int getLength() {
        return this.sampleRate == 0 || this.channels == 0 || (this.pcmFormat + 7) / 8 == 0 ? 0 : this.dataSize / (this.sampleRate * this.channels * ((this.pcmFormat + 7) / 8));
    }

    public final void openWave() throws FileNotFoundException, InvalidWaveException, IOException {
        int dataId;
        short audioFormat;
        int formatSize;
        int formatId;
        int format;
        int headerId;
        File file = this.mInFile;
        if (file == null) {
            Intrinsics.throwNpe();
        }
        FileInputStream fileStream = new FileInputStream(file);
        BufferedInputStream bufferedInputStream = this.mInStream = new BufferedInputStream(fileStream, STREAM_BUFFER_SIZE);
        if (bufferedInputStream == null) {
            Intrinsics.throwNpe();
        }
        if ((headerId = LameUtils.readUnsignedInt(bufferedInputStream)) != WAV_HEADER_CHUNK_ID) {
            String string;
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string2 = "Invalid WAVE header chunk ID: %d";
            Object[] objectArray = new Object[]{headerId};
            boolean bl = false;
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
            String string4 = string = string3;
            throw (Throwable)new InvalidWaveException(string4);
        }
        BufferedInputStream bufferedInputStream2 = this.mInStream;
        if (bufferedInputStream2 == null) {
            Intrinsics.throwNpe();
        }
        this.mFileSize = LameUtils.readUnsignedIntLE(bufferedInputStream2);
        BufferedInputStream bufferedInputStream3 = this.mInStream;
        if (bufferedInputStream3 == null) {
            Intrinsics.throwNpe();
        }
        if ((format = LameUtils.readUnsignedInt(bufferedInputStream3)) != WAV_FORMAT) {
            throw (Throwable)new InvalidWaveException("Invalid WAVE format");
        }
        BufferedInputStream bufferedInputStream4 = this.mInStream;
        if (bufferedInputStream4 == null) {
            Intrinsics.throwNpe();
        }
        if ((formatId = LameUtils.readUnsignedInt(bufferedInputStream4)) != WAV_FORMAT_CHUNK_ID) {
            throw (Throwable)new InvalidWaveException("Invalid WAVE format chunk ID");
        }
        BufferedInputStream bufferedInputStream5 = this.mInStream;
        if (bufferedInputStream5 == null) {
            Intrinsics.throwNpe();
        }
        if ((formatSize = LameUtils.readUnsignedIntLE(bufferedInputStream5)) != 16) {
            // empty if block
        }
        BufferedInputStream bufferedInputStream6 = this.mInStream;
        if (bufferedInputStream6 == null) {
            Intrinsics.throwNpe();
        }
        if ((audioFormat = LameUtils.readUnsignedShortLE(bufferedInputStream6)) != 1) {
            throw (Throwable)new InvalidWaveException("Not PCM WAVE format");
        }
        BufferedInputStream bufferedInputStream7 = this.mInStream;
        if (bufferedInputStream7 == null) {
            Intrinsics.throwNpe();
        }
        this.channels = LameUtils.readUnsignedShortLE(bufferedInputStream7);
        BufferedInputStream bufferedInputStream8 = this.mInStream;
        if (bufferedInputStream8 == null) {
            Intrinsics.throwNpe();
        }
        this.sampleRate = LameUtils.readUnsignedIntLE(bufferedInputStream8);
        BufferedInputStream bufferedInputStream9 = this.mInStream;
        if (bufferedInputStream9 == null) {
            Intrinsics.throwNpe();
        }
        int byteRate = LameUtils.readUnsignedIntLE(bufferedInputStream9);
        BufferedInputStream bufferedInputStream10 = this.mInStream;
        if (bufferedInputStream10 == null) {
            Intrinsics.throwNpe();
        }
        short blockAlign = LameUtils.readUnsignedShortLE(bufferedInputStream10);
        BufferedInputStream bufferedInputStream11 = this.mInStream;
        if (bufferedInputStream11 == null) {
            Intrinsics.throwNpe();
        }
        this.pcmFormat = LameUtils.readUnsignedShortLE(bufferedInputStream11);
        BufferedInputStream bufferedInputStream12 = this.mInStream;
        if (bufferedInputStream12 == null) {
            Intrinsics.throwNpe();
        }
        if ((dataId = LameUtils.readUnsignedInt(bufferedInputStream12)) != WAV_DATA_CHUNK_ID) {
            throw (Throwable)new InvalidWaveException("Invalid WAVE data chunk ID");
        }
        BufferedInputStream bufferedInputStream13 = this.mInStream;
        if (bufferedInputStream13 == null) {
            Intrinsics.throwNpe();
        }
        this.dataSize = LameUtils.readUnsignedIntLE(bufferedInputStream13);
    }

    public final int read(@NotNull short[] dst, int numSamples) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)dst, (String)"dst");
        if (this.channels != 1) {
            return -1;
        }
        byte[] buf = new byte[numSamples * 2];
        int index = 0;
        BufferedInputStream bufferedInputStream = this.mInStream;
        if (bufferedInputStream == null) {
            Intrinsics.throwNpe();
        }
        int bytesRead = bufferedInputStream.read(buf, 0, numSamples * 2);
        for (int i = 0; i < bytesRead; i += 2) {
            dst[index] = LameUtils.byteToShortLE(buf[i], buf[i + 1]);
            ++index;
        }
        return index;
    }

    public final int read(@NotNull short[] left, @NotNull short[] right, int numSamples) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)left, (String)"left");
        Intrinsics.checkParameterIsNotNull((Object)right, (String)"right");
        if (this.channels != 2) {
            return -1;
        }
        byte[] buf = new byte[numSamples * 4];
        int index = 0;
        BufferedInputStream bufferedInputStream = this.mInStream;
        if (bufferedInputStream == null) {
            Intrinsics.throwNpe();
        }
        int bytesRead = bufferedInputStream.read(buf, 0, numSamples * 4);
        for (int i = 0; i < bytesRead; i += 2) {
            short val = LameUtils.byteToShortLE(buf[0], buf[i + 1]);
            if (i % 4 == 0) {
                left[index] = val;
                continue;
            }
            right[index] = val;
            ++index;
        }
        return index;
    }

    public final void closeWaveFile() throws IOException {
        if (this.mInStream != null) {
            BufferedInputStream bufferedInputStream = this.mInStream;
            if (bufferedInputStream == null) {
                Intrinsics.throwNpe();
            }
            bufferedInputStream.close();
        }
    }

    public WaveReader(@NotNull String path, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.mInFile = new File(path + File.separator + name);
    }

    public WaveReader(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.mInFile = file;
    }

    static {
        WAV_HEADER_CHUNK_ID = 1380533830;
        WAV_FORMAT = 1463899717;
        WAV_FORMAT_CHUNK_ID = 1718449184;
        WAV_DATA_CHUNK_ID = 1684108385;
        STREAM_BUFFER_SIZE = 4096;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/naman14/androidlame/WaveReader$Companion;", "", "()V", "STREAM_BUFFER_SIZE", "", "WAV_DATA_CHUNK_ID", "WAV_FORMAT", "WAV_FORMAT_CHUNK_ID", "WAV_HEADER_CHUNK_ID", "android-lame_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

