/*
 * Decompiled with CFR 0.152.
 */
package com.naman14.androidlame;

import android.media.AudioRecord;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import com.naman14.androidlame.AndroidLame;
import com.naman14.androidlame.LameBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0013\u001a\u00020\u0010H\u0002J\u001a\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00042\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\u0012\u0010\u0019\u001a\u00020\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J\u0006\u0010\u001a\u001a\u00020\u0015R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001c"}, d2={"Lcom/naman14/androidlame/Mp3AudioRecorder;", "", "()V", "filePath", "", "getFilePath", "()Ljava/lang/String;", "setFilePath", "(Ljava/lang/String;)V", "inSamplerate", "", "getInSamplerate", "()I", "setInSamplerate", "(I)V", "<set-?>", "", "isRecording", "()Z", "isMainThread", "start", "", "_filePath", "iAudioRecordListener", "Lcom/naman14/androidlame/Mp3AudioRecorder$IAudioRecordListener;", "startRecordingByThread", "stop", "IAudioRecordListener", "android-lame_release"})
public final class Mp3AudioRecorder {
    private int inSamplerate = 8000;
    private boolean isRecording;
    @Nullable
    private String filePath;

    public final int getInSamplerate() {
        return this.inSamplerate;
    }

    public final void setInSamplerate(int n) {
        this.inSamplerate = n;
    }

    public final boolean isRecording() {
        return this.isRecording;
    }

    @Nullable
    public final String getFilePath() {
        return this.filePath;
    }

    public final void setFilePath(@Nullable String string) {
        this.filePath = string;
    }

    public final void start(@NotNull String _filePath, @Nullable IAudioRecordListener iAudioRecordListener) {
        Intrinsics.checkParameterIsNotNull((Object)_filePath, (String)"_filePath");
        if (TextUtils.isEmpty((CharSequence)_filePath)) {
            return;
        }
        if (this.isRecording) {
            return;
        }
        this.filePath = _filePath;
        this.isRecording = true;
        new Thread(new Runnable(this, iAudioRecordListener){
            final /* synthetic */ Mp3AudioRecorder this$0;
            final /* synthetic */ IAudioRecordListener $iAudioRecordListener;

            public final void run() {
                Mp3AudioRecorder.access$startRecordingByThread(this.this$0, this.$iAudioRecordListener);
            }
            {
                this.this$0 = mp3AudioRecorder;
                this.$iAudioRecordListener = iAudioRecordListener;
            }
        }).start();
    }

    public static /* synthetic */ void start$default(Mp3AudioRecorder mp3AudioRecorder, String string, IAudioRecordListener iAudioRecordListener, int n, Object object) {
        if ((n & 2) != 0) {
            iAudioRecordListener = null;
        }
        mp3AudioRecorder.start(string, iAudioRecordListener);
    }

    public final void stop() {
        this.isRecording = false;
    }

    /*
     * WARNING - void declaration
     */
    private final void startRecordingByThread(IAudioRecordListener iAudioRecordListener) {
        block16: {
            if (this.isMainThread()) {
                return;
            }
            IAudioRecordListener iAudioRecordListener2 = iAudioRecordListener;
            if (iAudioRecordListener2 != null) {
                iAudioRecordListener2.onStart();
            }
            int minBuffer = AudioRecord.getMinBufferSize((int)this.inSamplerate, (int)16, (int)2);
            Log.i((String)"Mp3AudioRecorder", (String)"Initialising audio recorder..");
            AudioRecord audioRecord = new AudioRecord(1, this.inSamplerate, 16, 2, minBuffer * 2);
            Log.i((String)"Mp3AudioRecorder", (String)"creating short buffer array");
            short[] buffer = new short[this.inSamplerate * 2 * 5];
            Log.i((String)"Mp3AudioRecorder", (String)"creating mp3 buffer");
            byte[] mp3buffer = new byte[(int)((double)7200 + (double)buffer.length * 2.0 * 1.25)];
            FileOutputStream outputStream = null;
            try {
                outputStream = new FileOutputStream(new File(this.filePath));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            Log.i((String)"Mp3AudioRecorder", (String)"Initialising Andorid Lame");
            AndroidLame androidLame = new LameBuilder().setInSampleRate(this.inSamplerate).setOutChannels(1).setOutBitrate(32).setOutSampleRate(this.inSamplerate).build();
            Log.i((String)"Mp3AudioRecorder", (String)"started audio recording");
            audioRecord.startRecording();
            int bytesRead = 0;
            long countVolumeTime = 0L;
            while (this.isRecording) {
                Log.i((String)"Mp3AudioRecorder", (String)("reading to short array buffer, buffer sze- " + minBuffer));
                bytesRead = audioRecord.read(buffer, 0, minBuffer);
                Log.i((String)"Mp3AudioRecorder", (String)("bytes read=" + bytesRead));
                if (bytesRead <= 0) continue;
                if (iAudioRecordListener != null) {
                    IAudioRecordListener iAudioRecordListener3;
                    boolean bl = false;
                    boolean bl2 = false;
                    IAudioRecordListener it = iAudioRecordListener3;
                    boolean bl3 = false;
                    if (System.currentTimeMillis() - countVolumeTime >= (long)500) {
                        countVolumeTime = System.currentTimeMillis();
                        int vTotal = 0;
                        int n = 0;
                        int n2 = buffer.length;
                        while (n < n2) {
                            void i;
                            vTotal += buffer[i] * buffer[i];
                            ++i;
                        }
                        double mean = (double)vTotal / (double)bytesRead;
                        double d = 10;
                        boolean bl4 = false;
                        double d2 = Math.log10(mean);
                        double volume = d * d2 - (double)50;
                        if (volume > 0.0) {
                            it.onAudioVolume(volume);
                        }
                    }
                }
                Log.i((String)"Mp3AudioRecorder", (String)"encoding bytes to mp3 buffer..");
                int bytesEncoded = androidLame.encode(buffer, buffer, bytesRead, mp3buffer);
                Log.i((String)"Mp3AudioRecorder", (String)("bytes encoded=" + bytesEncoded));
                if (bytesEncoded <= 0) continue;
                try {
                    Log.i((String)"Mp3AudioRecorder", (String)("writing mp3 buffer to outputstream with " + bytesEncoded + " bytes"));
                    FileOutputStream fileOutputStream = outputStream;
                    if (fileOutputStream == null) continue;
                    fileOutputStream.write(mp3buffer, 0, bytesEncoded);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            Log.i((String)"Mp3AudioRecorder", (String)"stopped recording");
            Log.i((String)"Mp3AudioRecorder", (String)"flushing final mp3buffer");
            int outputMp3buf = androidLame.flush(mp3buffer);
            Log.i((String)"Mp3AudioRecorder", (String)("flushed " + outputMp3buf + " bytes"));
            if (outputMp3buf > 0) {
                try {
                    Log.i((String)"Mp3AudioRecorder", (String)"writing final mp3buffer to outputstream");
                    FileOutputStream fileOutputStream = outputStream;
                    if (fileOutputStream != null) {
                        fileOutputStream.write(mp3buffer, 0, outputMp3buf);
                    }
                    Log.i((String)"Mp3AudioRecorder", (String)"closing output stream");
                    FileOutputStream fileOutputStream2 = outputStream;
                    if (fileOutputStream2 != null) {
                        fileOutputStream2.close();
                    }
                    Log.i((String)"Mp3AudioRecorder", (String)("Output recording saved in " + this.filePath));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            Log.i((String)"Mp3AudioRecorder", (String)"releasing audio recorder");
            audioRecord.stop();
            audioRecord.release();
            Log.i((String)"Mp3AudioRecorder", (String)"closing android lame");
            androidLame.close();
            this.isRecording = false;
            IAudioRecordListener iAudioRecordListener4 = iAudioRecordListener;
            if (iAudioRecordListener4 == null) break block16;
            iAudioRecordListener4.onStop();
        }
    }

    private final boolean isMainThread() {
        Looper looper = Looper.getMainLooper();
        Intrinsics.checkExpressionValueIsNotNull((Object)looper, (String)"Looper.getMainLooper()");
        return looper.getThread() == Thread.currentThread();
    }

    public static final /* synthetic */ void access$startRecordingByThread(Mp3AudioRecorder $this, IAudioRecordListener iAudioRecordListener) {
        $this.startRecordingByThread(iAudioRecordListener);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\b\u0010\u0006\u001a\u00020\u0003H&J\b\u0010\u0007\u001a\u00020\u0003H&\u00a8\u0006\b"}, d2={"Lcom/naman14/androidlame/Mp3AudioRecorder$IAudioRecordListener;", "", "onAudioVolume", "", "volume", "", "onStart", "onStop", "android-lame_release"})
    public static interface IAudioRecordListener {
        public void onStart();

        public void onStop();

        public void onAudioVolume(double var1);
    }
}

