/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.lsp4intellij.editor;

import com.google.common.base.Strings;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageDocumentation;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.Hint;
import java.awt.Cursor;
import java.awt.Point;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Timer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.Icon;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionContext;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.FormattingOptions;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.ParameterInformation;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ReferenceContext;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.SignatureHelp;
import org.eclipse.lsp4j.SignatureInformation;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.TextDocumentSaveReason;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WillSaveTextDocumentParams;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.JsonRpcException;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.jetbrains.annotations.NotNull;
import org.wso2.lsp4intellij.actions.LSPReferencesAction;
import org.wso2.lsp4intellij.client.languageserver.ServerOptions;
import org.wso2.lsp4intellij.client.languageserver.requestmanager.RequestManager;
import org.wso2.lsp4intellij.client.languageserver.wrapper.LanguageServerWrapper;
import org.wso2.lsp4intellij.contributors.icon.LSPIconProvider;
import org.wso2.lsp4intellij.contributors.psi.LSPPsiElement;
import org.wso2.lsp4intellij.contributors.rename.LSPRenameProcessor;
import org.wso2.lsp4intellij.editor.CtrlRangeMarker;
import org.wso2.lsp4intellij.editor.EditorEventManagerBase;
import org.wso2.lsp4intellij.requests.HoverHandler;
import org.wso2.lsp4intellij.requests.Timeout;
import org.wso2.lsp4intellij.requests.Timeouts;
import org.wso2.lsp4intellij.requests.WorkspaceEditHandler;
import org.wso2.lsp4intellij.utils.ApplicationUtils;
import org.wso2.lsp4intellij.utils.DocumentUtils;
import org.wso2.lsp4intellij.utils.FileUtils;
import org.wso2.lsp4intellij.utils.GUIUtils;

public class EditorEventManager {
    protected Logger LOG = Logger.getInstance(EditorEventManager.class);
    public Editor editor;
    public LanguageServerWrapper wrapper;
    private Project project;
    private RequestManager requestManager;
    private TextDocumentIdentifier identifier;
    private ServerOptions serverOptions;
    private DocumentListener documentListener;
    private EditorMouseListener mouseListener;
    private EditorMouseMotionListener mouseMotionListener;
    public List<String> completionTriggers;
    public List<String> signatureTriggers;
    private DidChangeTextDocumentParams changesParams;
    private TextDocumentSyncKind syncKind;
    private volatile boolean needSave = false;
    private Timer hoverThread = new Timer("Hover", true);
    private int version = -1;
    private long predTime = -1L;
    private long ctrlTime = -1L;
    private boolean isOpen = false;
    private boolean mouseInEditor = true;
    private Hint currentHint;
    protected final List<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
    private volatile boolean diagnosticsLock = true;

    public EditorEventManager(Editor editor, DocumentListener documentListener, EditorMouseListener mouseListener, EditorMouseMotionListener mouseMotionListener, RequestManager requestManager, ServerOptions serverOptions, LanguageServerWrapper wrapper) {
        this.editor = editor;
        this.documentListener = documentListener;
        this.mouseListener = mouseListener;
        this.mouseMotionListener = mouseMotionListener;
        this.requestManager = requestManager;
        this.serverOptions = serverOptions;
        this.wrapper = wrapper;
        this.identifier = new TextDocumentIdentifier(FileUtils.editorToURIString(editor));
        this.changesParams = new DidChangeTextDocumentParams(new VersionedTextDocumentIdentifier(), Collections.singletonList(new TextDocumentContentChangeEvent()));
        this.syncKind = serverOptions.syncKind;
        this.completionTriggers = serverOptions.completionOptions != null && serverOptions.completionOptions.getTriggerCharacters() != null ? serverOptions.completionOptions.getTriggerCharacters() : new ArrayList<String>();
        this.signatureTriggers = serverOptions.signatureHelpOptions != null && serverOptions.signatureHelpOptions.getTriggerCharacters() != null ? serverOptions.signatureHelpOptions.getTriggerCharacters() : new ArrayList<String>();
        this.project = editor.getProject();
        EditorEventManagerBase.uriToManager.put(FileUtils.editorToURIString(editor), this);
        EditorEventManagerBase.editorToManager.put(editor, this);
        this.changesParams.getTextDocument().setUri(this.identifier.getUri());
        this.currentHint = null;
    }

    public Project getProject() {
        return this.project;
    }

    public RequestManager getRequestManager() {
        return this.requestManager;
    }

    public TextDocumentIdentifier getIdentifier() {
        return this.identifier;
    }

    public DidChangeTextDocumentParams getChangesParams() {
        return this.changesParams;
    }

    public void characterTyped(char c) {
        if (this.signatureTriggers.contains(Character.toString(c))) {
            this.signatureHelp();
        }
    }

    public void mouseEntered() {
        this.mouseInEditor = true;
    }

    public void mouseExited() {
        this.mouseInEditor = false;
    }

    public void mouseMoved(EditorMouseEvent e) {
        if (e.getEditor() != this.editor) {
            this.LOG.error("Wrong editor for EditorEventManager");
            return;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.project).getPsiFile(this.editor.getDocument());
        if (psiFile == null) {
            return;
        }
        Language language = psiFile.getLanguage();
        if (!LanguageDocumentation.INSTANCE.allForLanguage(language).isEmpty() && !language.equals(PlainTextLanguage.INSTANCE) || !EditorEventManagerBase.getIsCtrlDown() && !EditorSettingsExternalizable.getInstance().isShowQuickDocOnMouseOverElement()) {
            return;
        }
        long curTime = System.nanoTime();
        if (this.predTime == -1L || this.ctrlTime == -1L) {
            this.predTime = curTime;
            this.ctrlTime = curTime;
        } else {
            LogicalPosition lPos = this.getPos(e);
            if (lPos == null || EditorEventManagerBase.getIsKeyPressed() && !EditorEventManagerBase.getIsCtrlDown()) {
                return;
            }
            int offset = this.editor.logicalPositionToOffset(lPos);
            if (EditorEventManagerBase.getIsCtrlDown() && curTime - this.ctrlTime > EditorEventManagerBase.CTRL_THRES) {
                if (EditorEventManagerBase.getCtrlRange() == null || !EditorEventManagerBase.getCtrlRange().highlightContainsOffset(offset)) {
                    if (this.currentHint != null) {
                        this.currentHint.hide();
                    }
                    this.currentHint = null;
                    if (EditorEventManagerBase.getCtrlRange() != null) {
                        EditorEventManagerBase.getCtrlRange().dispose();
                    }
                    EditorEventManagerBase.setCtrlRange(null);
                    ApplicationUtils.pool(() -> this.requestAndShowDoc(curTime, lPos, e.getMouseEvent().getPoint()));
                } else if (EditorEventManagerBase.getCtrlRange().definitionContainsOffset(offset)) {
                    GUIUtils.createAndShowEditorHint(this.editor, "Click to show usages", this.editor.offsetToXY(offset));
                } else {
                    this.editor.getContentComponent().setCursor(Cursor.getPredefinedCursor(12));
                }
                this.ctrlTime = curTime;
            }
            this.predTime = curTime;
        }
    }

    public void mouseClicked(EditorMouseEvent e) {
        if (!EditorEventManagerBase.getIsCtrlDown()) {
            return;
        }
        this.createCtrlRange(DocumentUtils.logicalToLSPPos(this.editor.xyToLogicalPosition(e.getMouseEvent().getPoint()), this.editor), null);
        CtrlRangeMarker ctrlRange = EditorEventManagerBase.getCtrlRange();
        if (ctrlRange == null) {
            int offset = this.editor.logicalPositionToOffset(this.editor.xyToLogicalPosition(e.getMouseEvent().getPoint()));
            LSPReferencesAction referencesAction = (LSPReferencesAction)ActionManager.getInstance().getAction("LSPFindUsages");
            if (referencesAction != null) {
                referencesAction.forManagerAndOffset(this, offset);
            }
            return;
        }
        Location loc = ctrlRange.location;
        ApplicationUtils.invokeLater(() -> {
            if (this.editor.isDisposed()) {
                return;
            }
            int offset = this.editor.logicalPositionToOffset(this.editor.xyToLogicalPosition(e.getMouseEvent().getPoint()));
            String locUri = FileUtils.sanitizeURI(loc.getUri());
            if (this.identifier.getUri().equals(locUri) && offset >= DocumentUtils.LSPPosToOffset(this.editor, loc.getRange().getStart()) && offset <= DocumentUtils.LSPPosToOffset(this.editor, loc.getRange().getEnd())) {
                LSPReferencesAction referencesAction = (LSPReferencesAction)ActionManager.getInstance().getAction("LSPFindUsages");
                if (referencesAction != null) {
                    referencesAction.forManagerAndOffset(this, offset);
                }
            } else {
                VirtualFile file = null;
                try {
                    file = LocalFileSystem.getInstance().findFileByIoFile(new File(new URI(locUri)));
                }
                catch (URISyntaxException e1) {
                    this.LOG.warn("Syntax Exception occurred for uri: " + locUri);
                }
                if (file != null) {
                    Position start = loc.getRange().getStart();
                    OpenFileDescriptor descriptor = new OpenFileDescriptor(this.project, file, start.getLine(), start.getCharacter());
                    ApplicationUtils.writeAction(() -> FileEditorManager.getInstance((Project)this.project).openTextEditor(descriptor, true));
                } else {
                    this.LOG.warn("Empty file for " + locUri);
                }
            }
            ctrlRange.dispose();
            EditorEventManagerBase.setCtrlRange(null);
        });
    }

    private void createCtrlRange(Position logicalPos, Range range) {
        Location location = this.requestDefinition(logicalPos);
        if (location == null || this.editor.isDisposed()) {
            return;
        }
        Range corRange = range == null ? new Range(logicalPos, logicalPos) : range;
        int startOffset = DocumentUtils.LSPPosToOffset(this.editor, corRange.getStart());
        int endOffset = DocumentUtils.LSPPosToOffset(this.editor, corRange.getEnd());
        boolean isDefinition = DocumentUtils.LSPPosToOffset(this.editor, location.getRange().getStart()) == startOffset;
        CtrlRangeMarker ctrlRange = EditorEventManagerBase.getCtrlRange();
        if (!this.editor.isDisposed()) {
            if (ctrlRange != null) {
                ctrlRange.dispose();
            }
            EditorEventManagerBase.setCtrlRange(new CtrlRangeMarker(location, this.editor, !isDefinition ? this.editor.getMarkupModel().addRangeHighlighter(startOffset, endOffset, 5900, this.editor.getColorsScheme().getAttributes(EditorColors.REFERENCE_HYPERLINK_COLOR), HighlighterTargetArea.EXACT_RANGE) : null));
        }
    }

    private Location requestDefinition(Position position) {
        TextDocumentPositionParams params = new TextDocumentPositionParams(this.identifier, position);
        CompletableFuture<List<? extends Location>> request = this.requestManager.definition(params);
        if (request == null) {
            return null;
        }
        try {
            List<? extends Location> definition = request.get(Timeout.getTimeout(Timeouts.DEFINITION), TimeUnit.MILLISECONDS);
            this.wrapper.notifySuccess(Timeouts.DEFINITION);
            if (definition != null && !definition.isEmpty()) {
                return definition.get(0);
            }
        }
        catch (TimeoutException e) {
            this.LOG.warn((Throwable)e);
            this.wrapper.notifyFailure(Timeouts.DEFINITION);
            return null;
        }
        catch (InterruptedException | ExecutionException | JsonRpcException e) {
            this.LOG.warn(e);
            this.wrapper.crashed((Exception)e);
            return null;
        }
        return null;
    }

    public Pair<List<PsiElement>, List<VirtualFile>> references(int offset) {
        return this.references(offset, false, false);
    }

    public Pair<List<PsiElement>, List<VirtualFile>> references(int offset, boolean getOriginalElement, boolean close) {
        Position lspPos = DocumentUtils.offsetToLSPPos(this.editor, offset);
        ReferenceParams params = new ReferenceParams(new ReferenceContext(getOriginalElement));
        params.setPosition(lspPos);
        params.setTextDocument(this.identifier);
        CompletableFuture<List<? extends Location>> request = this.requestManager.references(params);
        if (request != null) {
            try {
                List<? extends Location> res = request.get(Timeout.getTimeout(Timeouts.REFERENCES), TimeUnit.MILLISECONDS);
                this.wrapper.notifySuccess(Timeouts.REFERENCES);
                if (res != null && res.size() > 0) {
                    ArrayList openedEditors = new ArrayList();
                    ArrayList elements = new ArrayList();
                    res.forEach(l -> {
                        Position start = l.getRange().getStart();
                        Position end = l.getRange().getEnd();
                        String uri = FileUtils.sanitizeURI(l.getUri());
                        VirtualFile file = FileUtils.virtualFileFromURI(uri);
                        Editor curEditor = FileUtils.editorFromUri(uri, this.project);
                        if (curEditor == null && file != null) {
                            OpenFileDescriptor descriptor = new OpenFileDescriptor(this.project, file, start.getLine(), start.getCharacter());
                            curEditor = (Editor)ApplicationUtils.computableWriteAction(() -> FileEditorManager.getInstance((Project)this.project).openTextEditor(descriptor, false));
                            openedEditors.add(file);
                        }
                        int logicalStart = DocumentUtils.LSPPosToOffset(curEditor, start);
                        int logicalEnd = DocumentUtils.LSPPosToOffset(curEditor, end);
                        String name = curEditor.getDocument().getText(new TextRange(logicalStart, logicalEnd));
                        elements.add(new LSPPsiElement(name, this.project, logicalStart, logicalEnd, PsiDocumentManager.getInstance((Project)this.project).getPsiFile(curEditor.getDocument())));
                    });
                    if (close) {
                        ApplicationUtils.writeAction(() -> openedEditors.forEach(f -> FileEditorManager.getInstance((Project)this.project).closeFile(f)));
                        openedEditors.clear();
                    }
                    return new Pair(elements, openedEditors);
                }
                return new Pair(null, null);
            }
            catch (TimeoutException e) {
                this.LOG.warn((Throwable)e);
                this.wrapper.notifyFailure(Timeouts.REFERENCES);
                return new Pair(null, null);
            }
            catch (InterruptedException | ExecutionException | JsonRpcException e) {
                this.LOG.warn(e);
                this.wrapper.crashed((Exception)e);
                return new Pair(null, null);
            }
        }
        return new Pair(null, null);
    }

    public synchronized List<Diagnostic> getDiagnostics() {
        this.diagnosticsLock = true;
        return this.diagnostics;
    }

    public synchronized boolean isDiagnosticsLocked() {
        return this.diagnosticsLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void diagnostics(List<Diagnostic> diagnostics) {
        if (this.editor.isDisposed() || this.diagnostics.isEmpty() && diagnostics.isEmpty()) {
            return;
        }
        List<Diagnostic> list = this.diagnostics;
        synchronized (list) {
            this.diagnostics.clear();
            this.diagnostics.addAll(diagnostics);
            ApplicationUtils.computableReadAction(() -> {
                PsiFile file = PsiDocumentManager.getInstance((Project)this.project).getCachedPsiFile(this.editor.getDocument());
                if (file == null) {
                    return null;
                }
                this.LOG.debug("Triggering force full DaemonCodeAnalyzer execution.");
                this.diagnosticsLock = false;
                DaemonCodeAnalyzer.getInstance((Project)this.project).restart(file);
                return null;
            });
        }
    }

    public List<Either<Command, CodeAction>> codeAction(LSPPsiElement element) {
        CodeActionParams params = new CodeActionParams();
        params.setTextDocument(this.identifier);
        Range range = new Range(DocumentUtils.offsetToLSPPos(this.editor, element.start), DocumentUtils.offsetToLSPPos(this.editor, element.end));
        params.setRange(range);
        CodeActionContext context = new CodeActionContext(this.diagnostics);
        params.setContext(context);
        CompletableFuture<List<Either<Command, CodeAction>>> future = this.requestManager.codeAction(params);
        if (future != null) {
            try {
                List<Either<Command, CodeAction>> res = future.get(Timeout.getTimeout(Timeouts.CODEACTION), TimeUnit.MILLISECONDS);
                this.wrapper.notifySuccess(Timeouts.CODEACTION);
                return res;
            }
            catch (TimeoutException e) {
                this.LOG.warn((Throwable)e);
                this.wrapper.notifyFailure(Timeouts.CODEACTION);
                return null;
            }
            catch (InterruptedException | ExecutionException | JsonRpcException e) {
                this.LOG.warn(e);
                this.wrapper.crashed((Exception)e);
                return null;
            }
        }
        return null;
    }

    public void signatureHelp() {
        if (this.editor.isDisposed()) {
            return;
        }
        LogicalPosition lPos = this.editor.getCaretModel().getCurrentCaret().getLogicalPosition();
        Point point = this.editor.logicalPositionToXY(lPos);
        TextDocumentPositionParams params = new TextDocumentPositionParams(this.identifier, DocumentUtils.logicalToLSPPos(lPos, this.editor));
        ApplicationUtils.pool(() -> {
            CompletableFuture<SignatureHelp> future = this.requestManager.signatureHelp(params);
            if (future == null) {
                return;
            }
            try {
                SignatureHelp signatureResp = future.get(Timeout.getTimeout(Timeouts.SIGNATURE), TimeUnit.MILLISECONDS);
                this.wrapper.notifySuccess(Timeouts.SIGNATURE);
                if (signatureResp == null) {
                    return;
                }
                List signatures = signatureResp.getSignatures();
                if (signatures == null || signatures.isEmpty()) {
                    return;
                }
                int activeSignatureIndex = signatureResp.getActiveSignature();
                int activeParameterIndex = signatureResp.getActiveParameter();
                String activeParameter = ((SignatureInformation)signatures.get(activeSignatureIndex)).getParameters().size() > activeParameterIndex ? ((ParameterInformation)((SignatureInformation)signatures.get(activeSignatureIndex)).getParameters().get(activeParameterIndex)).getLabel() : "";
                Either signatureDescription = ((SignatureInformation)signatures.get(activeSignatureIndex)).getDocumentation();
                StringBuilder builder = new StringBuilder();
                builder.append("<html>");
                if (signatureDescription == null) {
                    builder.append("<b>").append(((SignatureInformation)signatures.get(activeSignatureIndex)).getLabel().replace(" " + activeParameter, String.format("<font color=\"orange\"> %s</font>", activeParameter))).append("</b>");
                } else if (signatureDescription.isLeft()) {
                    String descriptionLeft = ((String)signatureDescription.getLeft()).replace(System.lineSeparator(), "<br />");
                    builder.append("<b>").append(((SignatureInformation)signatures.get(activeSignatureIndex)).getLabel().replace(" " + activeParameter, String.format("<font color=\"orange\"> %s</font>", activeParameter))).append("</b>");
                    builder.append("<div>").append(descriptionLeft).append("</div>");
                } else if (signatureDescription.isRight()) {
                    builder.append("<b>").append(((SignatureInformation)signatures.get(activeSignatureIndex)).getLabel()).append("</b>");
                }
                builder.append("</html>");
                ApplicationUtils.invokeLater(() -> {
                    this.currentHint = GUIUtils.createAndShowEditorHint(this.editor, builder.toString(), point, (short)2, 16);
                });
            }
            catch (TimeoutException e) {
                this.LOG.warn((Throwable)e);
                this.wrapper.notifyFailure(Timeouts.SIGNATURE);
            }
            catch (InterruptedException | ExecutionException | JsonRpcException e) {
                this.LOG.warn(e);
                this.wrapper.crashed((Exception)e);
            }
            catch (Exception e) {
                this.LOG.warn("Internal error occurred when processing signature help");
            }
        });
    }

    public void reformat() {
        ApplicationUtils.pool(() -> {
            if (this.editor.isDisposed()) {
                return;
            }
            DocumentFormattingParams params = new DocumentFormattingParams();
            params.setTextDocument(this.identifier);
            FormattingOptions options = new FormattingOptions();
            params.setOptions(options);
            CompletableFuture<List<? extends TextEdit>> request = this.requestManager.formatting(params);
            if (request == null) {
                return;
            }
            request.thenAccept(formatting -> {
                if (formatting != null) {
                    ApplicationUtils.invokeLater(() -> this.applyEdit((List<TextEdit>)formatting, "Reformat document", false));
                }
            });
        });
    }

    public void reformatSelection() {
        ApplicationUtils.pool(() -> {
            if (this.editor.isDisposed()) {
                return;
            }
            DocumentRangeFormattingParams params = new DocumentRangeFormattingParams();
            params.setTextDocument(this.identifier);
            SelectionModel selectionModel = this.editor.getSelectionModel();
            int start = (Integer)ApplicationUtils.computableReadAction(() -> ((SelectionModel)selectionModel).getSelectionStart());
            int end = (Integer)ApplicationUtils.computableReadAction(() -> ((SelectionModel)selectionModel).getSelectionEnd());
            Position startingPos = DocumentUtils.offsetToLSPPos(this.editor, start);
            Position endPos = DocumentUtils.offsetToLSPPos(this.editor, end);
            params.setRange(new Range(startingPos, endPos));
            FormattingOptions options = new FormattingOptions();
            params.setOptions(options);
            CompletableFuture<List<? extends TextEdit>> request = this.requestManager.rangeFormatting(params);
            if (request == null) {
                return;
            }
            request.thenAccept(formatting -> {
                if (formatting == null) {
                    return;
                }
                ApplicationUtils.invokeLater(() -> {
                    if (!this.editor.isDisposed()) {
                        this.applyEdit((List<TextEdit>)formatting, "Reformat selection", false);
                    }
                });
            });
        });
    }

    public void rename(String renameTo) {
        this.rename(renameTo, this.editor.getCaretModel().getCurrentCaret().getOffset());
    }

    public void rename(String renameTo, int offset) {
        ApplicationUtils.pool(() -> {
            if (this.editor.isDisposed()) {
                return;
            }
            Position servPos = DocumentUtils.offsetToLSPPos(this.editor, offset);
            RenameParams params = new RenameParams(this.identifier, servPos, renameTo);
            CompletableFuture<WorkspaceEdit> request = this.requestManager.rename(params);
            if (request != null) {
                request.thenAccept(res -> {
                    WorkspaceEditHandler.applyEdit(res, "Rename to " + renameTo, new ArrayList<VirtualFile>(LSPRenameProcessor.getEditors()));
                    LSPRenameProcessor.clearEditors();
                });
            }
        });
    }

    public void quickDoc(Editor editor) {
        if (editor == this.editor) {
            LogicalPosition caretPos = editor.getCaretModel().getLogicalPosition();
            Point pointPos = editor.logicalPositionToXY(caretPos);
            long currentTime = System.nanoTime();
            ApplicationUtils.pool(() -> this.requestAndShowDoc(currentTime, caretPos, pointPos));
            this.predTime = currentTime;
        } else {
            this.LOG.warn("Not same editor!");
        }
    }

    private void requestAndShowDoc(long curTime, LogicalPosition editorPos, Point point) {
        Position serverPos = (Position)ApplicationUtils.computableReadAction(() -> DocumentUtils.logicalToLSPPos(editorPos, this.editor));
        CompletableFuture<Hover> request = this.requestManager.hover(new TextDocumentPositionParams(this.identifier, serverPos));
        if (request == null) {
            return;
        }
        try {
            Hover hover = request.get(Timeout.getTimeout(Timeouts.HOVER), TimeUnit.MILLISECONDS);
            this.wrapper.notifySuccess(Timeouts.HOVER);
            if (hover == null) {
                this.LOG.warn(String.format("Hover is null for file %s and pos (%d;%d)", this.identifier.getUri(), serverPos.getLine(), serverPos.getCharacter()));
                return;
            }
            String string = HoverHandler.getHoverString(hover);
            if (Strings.isNullOrEmpty((String)string)) {
                this.LOG.warn(String.format("Hover string returned is null for file %s and pos (%d;%d)", this.identifier.getUri(), serverPos.getLine(), serverPos.getCharacter()));
                return;
            }
            if (EditorEventManagerBase.getIsCtrlDown()) {
                ApplicationUtils.invokeLater(() -> {
                    if (!this.editor.isDisposed()) {
                        this.currentHint = GUIUtils.createAndShowEditorHint(this.editor, string, point, 16);
                    }
                });
            } else {
                ApplicationUtils.invokeLater(() -> {
                    if (!this.editor.isDisposed()) {
                        this.currentHint = GUIUtils.createAndShowEditorHint(this.editor, string, point);
                    }
                });
            }
        }
        catch (TimeoutException e) {
            this.LOG.warn((Throwable)e);
            this.wrapper.notifyFailure(Timeouts.HOVER);
        }
        catch (InterruptedException | ExecutionException | JsonRpcException e) {
            this.LOG.warn(e);
            this.wrapper.crashed((Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<? extends LookupElement> completion(Position pos) {
        ArrayList<LookupElement> lookupItems = new ArrayList<LookupElement>();
        CompletableFuture<Either<List<CompletionItem>, CompletionList>> request = this.requestManager.completion(new CompletionParams(this.identifier, pos));
        if (request == null) {
            return lookupItems;
        }
        try {
            Either<List<CompletionItem>, CompletionList> res = request.get(Timeout.getTimeout(Timeouts.COMPLETION), TimeUnit.MILLISECONDS);
            this.wrapper.notifySuccess(Timeouts.COMPLETION);
            if (res == null) {
                ArrayList<LookupElement> arrayList = lookupItems;
                return arrayList;
            }
            if (res.getLeft() != null) {
                for (CompletionItem item : (List)res.getLeft()) {
                    LookupElement lookupElement = this.createLookupItem(item);
                    if (lookupElement == null) continue;
                    lookupItems.add(lookupElement);
                }
            } else if (res.getRight() != null) {
                for (CompletionItem item : ((CompletionList)res.getRight()).getItems()) {
                    LookupElement lookupElement = this.createLookupItem(item);
                    if (lookupElement == null) continue;
                    lookupItems.add(lookupElement);
                }
            }
        }
        catch (InterruptedException | TimeoutException e) {
            this.LOG.warn((Throwable)e);
            this.wrapper.notifyFailure(Timeouts.COMPLETION);
        }
        catch (ExecutionException | JsonRpcException e) {
            this.LOG.warn(e);
            this.wrapper.crashed((Exception)e);
        }
        finally {
            return lookupItems;
        }
    }

    public LookupElement createLookupItem(CompletionItem item) {
        Command command = item.getCommand();
        String detail = item.getDetail();
        String insertText = item.getInsertText();
        CompletionItemKind kind = item.getKind();
        String label = item.getLabel();
        TextEdit textEdit = item.getTextEdit();
        List addTextEdits = item.getAdditionalTextEdits();
        String presentableText = !Strings.isNullOrEmpty((String)label) ? label : (insertText != null ? insertText : "");
        String tailText = detail != null ? detail : "";
        LSPIconProvider iconProvider = GUIUtils.getIconProviderFor(this.wrapper.getServerDefinition());
        Icon icon = LSPIconProvider.getCompletionIcon(kind);
        String lookupString = null;
        if (textEdit != null) {
            lookupString = textEdit.getNewText();
        } else if (!Strings.isNullOrEmpty((String)insertText)) {
            lookupString = insertText;
        } else if (!Strings.isNullOrEmpty((String)label)) {
            lookupString = label;
        }
        if (Strings.isNullOrEmpty((String)lookupString)) {
            return null;
        }
        lookupString = lookupString.replace("\r\n", "\n");
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)lookupString);
        if (textEdit != null) {
            if (addTextEdits != null) {
                lookupElementBuilder = this.setInsertHandler(lookupElementBuilder, addTextEdits, command, label);
            }
        } else if (addTextEdits != null) {
            lookupElementBuilder = this.setInsertHandler(lookupElementBuilder, addTextEdits, command, label);
        } else if (command != null) {
            lookupElementBuilder = lookupElementBuilder.withInsertHandler((context, lookupElement) -> {
                context.commitDocument();
                ApplicationUtils.invokeLater(() -> this.executeCommands(Collections.singletonList(command)));
            });
        }
        if (kind == CompletionItemKind.Keyword) {
            lookupElementBuilder = lookupElementBuilder.withBoldness(true);
        }
        return lookupElementBuilder.withPresentableText(presentableText).withTypeText(tailText, true).withIcon(icon).withAutoCompletionPolicy(AutoCompletionPolicy.SETTINGS_DEPENDENT);
    }

    private LogicalPosition getPos(EditorMouseEvent e) {
        Point mousePos = e.getMouseEvent().getPoint();
        LogicalPosition editorPos = this.editor.xyToLogicalPosition(mousePos);
        Document doc = e.getEditor().getDocument();
        int maxLines = doc.getLineCount();
        if (editorPos.line >= maxLines) {
            return null;
        }
        int minY = doc.getLineStartOffset(editorPos.line) - (editorPos.line > 0 ? doc.getLineEndOffset(editorPos.line - 1) : 0);
        int maxY = doc.getLineEndOffset(editorPos.line) - (editorPos.line > 0 ? doc.getLineEndOffset(editorPos.line - 1) : 0);
        return editorPos.column > minY && editorPos.column < maxY ? editorPos : null;
    }

    protected LookupElementBuilder setInsertHandler(LookupElementBuilder builder, List<TextEdit> edits, Command command, String label) {
        return builder.withInsertHandler((context, lookupElement) -> {
            context.commitDocument();
            ApplicationUtils.invokeLater(() -> {
                this.applyEdit(edits, "Completion : " + label, false);
                if (command != null) {
                    this.executeCommands(Collections.singletonList(command));
                }
            });
        });
    }

    boolean applyEdit(List<TextEdit> edits, String name, boolean setCaret) {
        return this.applyEdit(Integer.MAX_VALUE, edits, name, false, setCaret);
    }

    boolean applyEdit(int version, List<TextEdit> edits, String name, boolean closeAfter, boolean setCaret) {
        Runnable runnable = this.getEditsRunnable(version, edits, name, setCaret);
        ApplicationUtils.writeAction(() -> {
            if (runnable != null) {
                CommandProcessor.getInstance().executeCommand(this.project, runnable, name, (Object)"LSPPlugin", this.editor.getDocument());
            }
            if (closeAfter) {
                FileEditorManager.getInstance((Project)this.project).closeFile(PsiDocumentManager.getInstance((Project)this.project).getPsiFile(this.editor.getDocument()).getVirtualFile());
            }
        });
        return runnable != null;
    }

    public Runnable getEditsRunnable(int version, List<TextEdit> edits, String name, boolean setCaret) {
        if (version < this.version) {
            this.LOG.warn(String.format("Edit version %d is older than current version %d", version, this.version));
            return null;
        }
        if (edits == null) {
            this.LOG.warn("Received edits list is null.");
            return null;
        }
        Document document = this.editor.getDocument();
        if (!document.isWritable()) {
            this.LOG.warn("Document is not writable");
            return null;
        }
        return () -> {
            ArrayList lspEdits = new ArrayList();
            edits.forEach(edit -> {
                String text = edit.getNewText();
                Range range = edit.getRange();
                if (range != null && !Strings.isNullOrEmpty((String)text)) {
                    int start = DocumentUtils.LSPPosToOffset(this.editor, range.getStart());
                    int end = DocumentUtils.LSPPosToOffset(this.editor, range.getEnd());
                    lspEdits.add(new LSPTextEdit(text, start, end));
                }
            });
            Collections.sort(lspEdits);
            lspEdits.forEach(edit -> {
                String text = edit.getText();
                int start = edit.getStartOffset();
                int end = edit.getEndOffset();
                if (Strings.isNullOrEmpty((String)text)) {
                    document.deleteString(start, end);
                } else {
                    text = text.replace("\r\n", "\n");
                    if (end >= 0) {
                        if (end - start <= 0) {
                            document.insertString(start, (CharSequence)text);
                        } else {
                            document.replaceString(start, end, (CharSequence)text);
                        }
                    } else if (start == 0) {
                        document.setText((CharSequence)text);
                    } else if (start > 0) {
                        document.insertString(start, (CharSequence)text);
                    }
                    if (setCaret) {
                        this.editor.getCaretModel().moveToOffset(start + text.length());
                    }
                }
                this.saveDocument();
            });
        };
    }

    public void executeCommands(List<Command> commands) {
        ApplicationUtils.pool(() -> {
            if (this.editor.isDisposed()) {
                return;
            }
            commands.stream().map(c -> {
                ExecuteCommandParams params = new ExecuteCommandParams();
                params.setArguments(c.getArguments());
                params.setCommand(c.getCommand());
                return this.requestManager.executeCommand(params);
            }).filter(Objects::nonNull).forEach(f -> {
                try {
                    f.get(Timeout.getTimeout(Timeouts.EXECUTE_COMMAND), TimeUnit.MILLISECONDS);
                    this.wrapper.notifySuccess(Timeouts.EXECUTE_COMMAND);
                }
                catch (TimeoutException te) {
                    this.LOG.warn((Throwable)te);
                    this.wrapper.notifyFailure(Timeouts.EXECUTE_COMMAND);
                }
                catch (InterruptedException | ExecutionException | JsonRpcException e) {
                    this.LOG.warn(e);
                    this.wrapper.crashed((Exception)e);
                }
            });
        });
    }

    private void saveDocument() {
        FileDocumentManager.getInstance().saveDocument(this.editor.getDocument());
    }

    public void registerListeners() {
        this.editor.getDocument().addDocumentListener(this.documentListener);
        this.editor.addEditorMouseListener(this.mouseListener);
        this.editor.addEditorMouseMotionListener(this.mouseMotionListener);
    }

    public void removeListeners() {
        this.editor.getDocument().removeDocumentListener(this.documentListener);
        this.editor.removeEditorMouseListener(this.mouseListener);
        this.editor.removeEditorMouseMotionListener(this.mouseMotionListener);
    }

    public void documentClosed() {
        ApplicationUtils.pool(() -> {
            if (this.isOpen) {
                this.requestManager.didClose(new DidCloseTextDocumentParams(this.identifier));
                this.isOpen = false;
                EditorEventManagerBase.editorToManager.remove(this.editor);
                EditorEventManagerBase.uriToManager.remove(FileUtils.editorToURIString(this.editor));
            } else {
                this.LOG.warn("Editor " + this.identifier.getUri() + " was already closed");
            }
        });
    }

    public void documentOpened() {
        ApplicationUtils.pool(() -> {
            if (this.editor.isDisposed()) {
                return;
            }
            if (this.isOpen) {
                this.LOG.warn("Editor " + this.editor + " was already open");
            } else {
                String extension = FileDocumentManager.getInstance().getFile(this.editor.getDocument()).getExtension();
                this.requestManager.didOpen(new DidOpenTextDocumentParams(new TextDocumentItem(this.identifier.getUri(), this.wrapper.serverDefinition.languageIdFor(extension), this.version++, this.editor.getDocument().getText())));
                this.isOpen = true;
            }
        });
    }

    public void documentChanged(DocumentEvent event) {
        if (this.editor.isDisposed()) {
            return;
        }
        if (event.getDocument() == this.editor.getDocument()) {
            this.changesParams.getTextDocument().setVersion(Integer.valueOf(this.version++));
            if (this.syncKind == TextDocumentSyncKind.Incremental) {
                int endColumn;
                int endLine;
                TextDocumentContentChangeEvent changeEvent = (TextDocumentContentChangeEvent)this.changesParams.getContentChanges().get(0);
                CharSequence newText = event.getNewFragment();
                int offset = event.getOffset();
                int newTextLength = event.getNewLength();
                Position lspPosition = DocumentUtils.offsetToLSPPos(this.editor, offset);
                int startLine = lspPosition.getLine();
                int startColumn = lspPosition.getCharacter();
                CharSequence oldText = event.getOldFragment();
                if (oldText.length() > 0) {
                    endLine = startLine + StringUtil.countNewLines((CharSequence)oldText);
                    String[] oldLines = oldText.toString().split("\n");
                    int oldTextLength = oldLines.length == 0 ? 0 : oldLines[oldLines.length - 1].length();
                    endColumn = oldLines.length == 1 ? startColumn + oldTextLength : oldTextLength;
                } else {
                    endLine = startLine;
                    endColumn = startColumn;
                }
                Range range = new Range(new Position(startLine, startColumn), new Position(endLine, endColumn));
                changeEvent.setRange(range);
                changeEvent.setRangeLength(Integer.valueOf(newTextLength));
                changeEvent.setText(newText.toString());
            } else if (this.syncKind == TextDocumentSyncKind.Full) {
                ((TextDocumentContentChangeEvent)this.changesParams.getContentChanges().get(0)).setText(this.editor.getDocument().getText());
            }
            this.requestManager.didChange(this.changesParams);
        } else {
            this.LOG.error("Wrong document for the EditorEventManager");
        }
    }

    public void documentSaved() {
        ApplicationUtils.pool(() -> {
            if (!this.editor.isDisposed()) {
                DidSaveTextDocumentParams params = new DidSaveTextDocumentParams(this.identifier, this.editor.getDocument().getText());
                this.requestManager.didSave(params);
            }
        });
    }

    public void willSave() {
        if (this.wrapper.isWillSaveWaitUntil() && !this.needSave) {
            this.willSaveWaitUntil();
        } else {
            ApplicationUtils.pool(() -> {
                if (!this.editor.isDisposed()) {
                    this.requestManager.willSave(new WillSaveTextDocumentParams(this.identifier, TextDocumentSaveReason.Manual));
                }
            });
        }
    }

    private void willSaveWaitUntil() {
        if (this.wrapper.isWillSaveWaitUntil()) {
            ApplicationUtils.pool(() -> {
                if (this.editor.isDisposed()) {
                    return;
                }
                WillSaveTextDocumentParams params = new WillSaveTextDocumentParams(this.identifier, TextDocumentSaveReason.Manual);
                CompletableFuture<List<TextEdit>> future = this.requestManager.willSaveWaitUntil(params);
                if (future != null) {
                    try {
                        List<TextEdit> edits = future.get(Timeout.getTimeout(Timeouts.WILLSAVE), TimeUnit.MILLISECONDS);
                        this.wrapper.notifySuccess(Timeouts.WILLSAVE);
                        if (edits == null) return;
                        ApplicationUtils.invokeLater(() -> this.applyEdit(edits, "WaitUntil edits", false));
                        return;
                    }
                    catch (TimeoutException e) {
                        this.LOG.warn((Throwable)e);
                        this.wrapper.notifyFailure(Timeouts.WILLSAVE);
                        return;
                    }
                    catch (InterruptedException | ExecutionException | JsonRpcException e) {
                        this.LOG.warn(e);
                        this.wrapper.crashed((Exception)e);
                        return;
                    }
                    finally {
                        this.needSave = true;
                        this.saveDocument();
                    }
                } else {
                    this.needSave = true;
                    this.saveDocument();
                }
            });
        } else {
            this.LOG.error("Server doesn't support WillSaveWaitUntil");
            this.needSave = true;
            this.saveDocument();
        }
    }

    private class LSPTextEdit
    implements Comparable<LSPTextEdit> {
        private String text;
        private int startOffset;
        private int endOffset;

        LSPTextEdit(String text, int start, int end) {
            this.text = text;
            this.startOffset = start;
            this.endOffset = end;
        }

        String getText() {
            return this.text;
        }

        int getStartOffset() {
            return this.startOffset;
        }

        int getEndOffset() {
            return this.endOffset;
        }

        @Override
        public int compareTo(@NotNull LSPTextEdit te) {
            if (te == null) {
                LSPTextEdit.$$$reportNull$$$0(0);
            }
            return te.getStartOffset() - this.getStartOffset();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "te", "org/wso2/lsp4intellij/editor/EditorEventManager$LSPTextEdit", "compareTo"));
        }
    }
}

