/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.lsp4intellij.client.languageserver.wrapper;

import java.util.function.Function;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.lsp4j.jsonrpc.messages.Message;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseMessage;
import org.eclipse.lsp4j.services.LanguageServer;
import org.jetbrains.annotations.NotNull;
import org.wso2.lsp4intellij.client.languageserver.serverdefinition.ServerListener;

class MessageHandler
implements Function<MessageConsumer, MessageConsumer> {
    private ServerListener listener;
    private LanguageServer languageServer;

    public MessageHandler(ServerListener listener) {
        this.listener = listener;
    }

    @Override
    public MessageConsumer apply(MessageConsumer messageConsumer) {
        return message -> {
            this.handleMessage(message);
            messageConsumer.consume(message);
        };
    }

    private void handleMessage(Message message) {
        ResponseMessage responseMessage;
        if (message instanceof ResponseMessage && (responseMessage = (ResponseMessage)message).getResult() instanceof InitializeResult) {
            this.listener.initialize(this.languageServer, (InitializeResult)responseMessage.getResult());
        }
    }

    public void setLanguageServer(@NotNull LanguageServer languageServer) {
        if (languageServer == null) {
            MessageHandler.$$$reportNull$$$0(0);
        }
        this.languageServer = languageServer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageServer", "org/wso2/lsp4intellij/client/languageserver/wrapper/MessageHandler", "setLanguageServer"));
    }
}

