/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.lsp4intellij.actions;

import com.intellij.codeInsight.actions.ReformatCodeAction;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import org.wso2.lsp4intellij.IntellijLanguageClient;
import org.wso2.lsp4intellij.requests.ReformatHandler;

public class LSPReformatAction
extends ReformatCodeAction
implements DumbAware {
    private Logger LOG = Logger.getInstance(LSPReformatAction.class);

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor == null || project == null) {
            return;
        }
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (LanguageFormatting.INSTANCE.allForLanguage(file.getLanguage()).isEmpty() && IntellijLanguageClient.isExtensionSupported(file.getVirtualFile())) {
            if (editor.getSelectionModel().hasSelection()) {
                ReformatHandler.reformatSelection(editor);
            } else {
                ReformatHandler.reformatFile(editor);
            }
        } else {
            super.actionPerformed(e);
        }
    }

    public void update(AnActionEvent event) {
        super.update(event);
    }
}

