/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.lsp4intellij.requests;

import com.intellij.openapi.diagnostic.Logger;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.options.MutableDataSet;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.MarkedString;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.validation.NonNull;

public class HoverHandler {
    private Logger LOG = Logger.getInstance(HoverHandler.class);

    public static String getHoverString(@NonNull Hover hover) {
        if (hover == null || hover.getContents() == null) {
            return "";
        }
        Either hoverContents = hover.getContents();
        if (hoverContents.isLeft()) {
            boolean useHtml = false;
            List contents = (List)hoverContents.getLeft();
            if (contents != null && !contents.isEmpty()) {
                ArrayList<Object> result = new ArrayList<Object>();
                for (Either c : contents) {
                    if (c.isLeft() && !((String)c.getLeft()).isEmpty()) {
                        result.add(c.getLeft());
                        continue;
                    }
                    if (!c.isRight()) continue;
                    useHtml = true;
                    MutableDataSet options = new MutableDataSet();
                    Parser parser = Parser.builder((DataHolder)options).build();
                    HtmlRenderer renderer = HtmlRenderer.builder((DataHolder)options).build();
                    MarkedString markedString = (MarkedString)c.getRight();
                    String string = markedString.getLanguage() != null && !markedString.getLanguage().isEmpty() ? "```" + markedString.getLanguage() + " " + markedString.getValue() + "```" : "";
                    if (string.isEmpty()) continue;
                    result.add(renderer.render((Node)parser.parse(string)));
                }
                return useHtml ? "<html>" + String.join((CharSequence)"\n\n", result) + "</html>" : String.join((CharSequence)"\n\n", result);
            }
            return "";
        }
        if (hoverContents.isRight()) {
            MutableDataSet options = new MutableDataSet();
            Parser parser = Parser.builder((DataHolder)options).build();
            HtmlRenderer renderer = HtmlRenderer.builder((DataHolder)options).build();
            String markedContent = ((MarkupContent)hoverContents.getRight()).getValue();
            return "<html>" + renderer.render((Node)parser.parse(markedContent)) + "</html>";
        }
        return "";
    }
}

