/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.lsp4intellij.editor;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import java.awt.Cursor;
import org.eclipse.lsp4j.Location;
import org.wso2.lsp4intellij.utils.DocumentUtils;

public class CtrlRangeMarker {
    Location location;
    private Editor editor;
    private RangeHighlighter range;

    CtrlRangeMarker(Location location, Editor editor, RangeHighlighter range) {
        this.location = location;
        this.editor = editor;
        this.range = range;
    }

    boolean highlightContainsOffset(int offset) {
        if (!this.isDefinition()) {
            return this.range.getStartOffset() <= offset && this.range.getEndOffset() >= offset;
        }
        return this.definitionContainsOffset(offset);
    }

    boolean definitionContainsOffset(int offset) {
        return DocumentUtils.LSPPosToOffset(this.editor, this.location.getRange().getStart()) <= offset && offset <= DocumentUtils.LSPPosToOffset(this.editor, this.location.getRange().getEnd());
    }

    void dispose() {
        if (!this.isDefinition()) {
            this.editor.getMarkupModel().removeHighlighter(this.range);
            this.editor.getContentComponent().setCursor(Cursor.getDefaultCursor());
        }
    }

    boolean isDefinition() {
        return this.range == null;
    }
}

