/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.lsp4intellij.contributors.rename;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.usageView.UsageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.wso2.lsp4intellij.contributors.psi.LSPPsiElement;
import org.wso2.lsp4intellij.editor.EditorEventManager;
import org.wso2.lsp4intellij.editor.EditorEventManagerBase;
import org.wso2.lsp4intellij.requests.WorkspaceEditHandler;
import org.wso2.lsp4intellij.utils.FileUtils;

public class LSPRenameProcessor
extends RenamePsiElementProcessor {
    private static Set<VirtualFile> openedEditors = new HashSet<VirtualFile>();
    private PsiElement curElem;
    private Set<PsiElement> elements = new HashSet<PsiElement>();

    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            LSPRenameProcessor.$$$reportNull$$$0(0);
        }
        return element instanceof LSPPsiElement;
    }

    public RenameDialog createRenameDialog(Project project, PsiElement element, PsiElement nameSuggestionContext, Editor editor) {
        return super.createRenameDialog(project, this.curElem, nameSuggestionContext, editor);
    }

    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element) {
        if (element == null) {
            LSPRenameProcessor.$$$reportNull$$$0(1);
        }
        Collection<PsiReference> collection = this.findReferences(element, false);
        if (collection == null) {
            LSPRenameProcessor.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element, boolean searchInCommentsAndStrings) {
        if (element == null) {
            LSPRenameProcessor.$$$reportNull$$$0(3);
        }
        if (element instanceof LSPPsiElement) {
            if (this.elements.contains(element)) {
                Collection collection = this.elements.stream().map(PsiElement::getReference).collect(Collectors.toList());
                if (collection == null) {
                    LSPRenameProcessor.$$$reportNull$$$0(4);
                }
                return collection;
            }
            EditorEventManager manager = EditorEventManagerBase.forEditor(FileUtils.editorFromPsiFile(element.getContainingFile()));
            if (manager != null) {
                Pair<List<PsiElement>, List<VirtualFile>> refs = manager.references(element.getTextOffset(), true, false);
                LSPRenameProcessor.addEditors((List)refs.getSecond());
                Collection collection = ((List)refs.getFirst()).stream().map(PsiElement::getReference).collect(Collectors.toList());
                if (collection == null) {
                    LSPRenameProcessor.$$$reportNull$$$0(5);
                }
                return collection;
            }
        }
        ArrayList<PsiReference> arrayList = new ArrayList<PsiReference>();
        if (arrayList == null) {
            LSPRenameProcessor.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element, @NotNull SearchScope searchScope, boolean searchInCommentsAndStrings) {
        if (element == null) {
            LSPRenameProcessor.$$$reportNull$$$0(7);
        }
        if (searchScope == null) {
            LSPRenameProcessor.$$$reportNull$$$0(8);
        }
        if (element instanceof LSPPsiElement) {
            if (this.elements.contains(element)) {
                Collection collection = this.elements.stream().map(PsiElement::getReference).collect(Collectors.toList());
                if (collection == null) {
                    LSPRenameProcessor.$$$reportNull$$$0(9);
                }
                return collection;
            }
            EditorEventManager manager = EditorEventManagerBase.forEditor(FileUtils.editorFromPsiFile(element.getContainingFile()));
            if (manager != null) {
                Pair<List<PsiElement>, List<VirtualFile>> refs = manager.references(element.getTextOffset(), true, false);
                LSPRenameProcessor.addEditors((List)refs.getSecond());
                Collection collection = ((List)refs.getFirst()).stream().map(PsiElement::getReference).collect(Collectors.toList());
                if (collection == null) {
                    LSPRenameProcessor.$$$reportNull$$$0(10);
                }
                return collection;
            }
        }
        ArrayList<PsiReference> arrayList = new ArrayList<PsiReference>();
        if (arrayList == null) {
            LSPRenameProcessor.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    public void renameElement(@NotNull PsiElement element, @NotNull String newName, @NotNull UsageInfo[] usages, RefactoringElementListener listener) {
        if (element == null) {
            LSPRenameProcessor.$$$reportNull$$$0(12);
        }
        if (newName == null) {
            LSPRenameProcessor.$$$reportNull$$$0(13);
        }
        if (usages == null) {
            LSPRenameProcessor.$$$reportNull$$$0(14);
        }
        WorkspaceEditHandler.applyEdit(element, newName, usages, listener, new ArrayList<VirtualFile>(openedEditors));
        openedEditors.clear();
        this.elements.clear();
        this.curElem = null;
    }

    public boolean isInplaceRenameSupported() {
        return true;
    }

    public static void clearEditors() {
        openedEditors.clear();
    }

    public static Set<VirtualFile> getEditors() {
        return openedEditors;
    }

    static void addEditors(List<VirtualFile> toAdd) {
        openedEditors.addAll(toAdd);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/wso2/lsp4intellij/contributors/rename/LSPRenameProcessor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/wso2/lsp4intellij/contributors/rename/LSPRenameProcessor";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canProcessElement";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findReferences";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "renameElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

