/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.lsp4intellij.client.languageserver.wrapper;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.remoteServer.util.CloudNotifier;
import com.intellij.util.PlatformIcons;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import javax.swing.Icon;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.lsp4j.CodeActionCapabilities;
import org.eclipse.lsp4j.CompletionCapabilities;
import org.eclipse.lsp4j.CompletionItemCapabilities;
import org.eclipse.lsp4j.DefinitionCapabilities;
import org.eclipse.lsp4j.DidChangeWatchedFilesCapabilities;
import org.eclipse.lsp4j.DocumentHighlightCapabilities;
import org.eclipse.lsp4j.ExecuteCommandCapabilities;
import org.eclipse.lsp4j.FormattingCapabilities;
import org.eclipse.lsp4j.HoverCapabilities;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.InitializedParams;
import org.eclipse.lsp4j.OnTypeFormattingCapabilities;
import org.eclipse.lsp4j.RangeFormattingCapabilities;
import org.eclipse.lsp4j.ReferencesCapabilities;
import org.eclipse.lsp4j.RenameCapabilities;
import org.eclipse.lsp4j.SemanticHighlightingCapabilities;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.SignatureHelpCapabilities;
import org.eclipse.lsp4j.SymbolCapabilities;
import org.eclipse.lsp4j.SynchronizationCapabilities;
import org.eclipse.lsp4j.TextDocumentClientCapabilities;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.TextDocumentSyncOptions;
import org.eclipse.lsp4j.WorkspaceClientCapabilities;
import org.eclipse.lsp4j.WorkspaceEditCapabilities;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.messages.Message;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseMessage;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageServer;
import org.jetbrains.annotations.Nullable;
import org.wso2.lsp4intellij.IntellijLanguageClient;
import org.wso2.lsp4intellij.client.DefaultLanguageClient;
import org.wso2.lsp4intellij.client.ServerWrapperBaseClientContext;
import org.wso2.lsp4intellij.client.languageserver.LSPServerStatusWidget;
import org.wso2.lsp4intellij.client.languageserver.ServerOptions;
import org.wso2.lsp4intellij.client.languageserver.ServerStatus;
import org.wso2.lsp4intellij.client.languageserver.requestmanager.DefaultRequestManager;
import org.wso2.lsp4intellij.client.languageserver.requestmanager.RequestManager;
import org.wso2.lsp4intellij.client.languageserver.serverdefinition.LanguageServerDefinition;
import org.wso2.lsp4intellij.client.languageserver.wrapper.MessageHandler;
import org.wso2.lsp4intellij.editor.EditorEventManager;
import org.wso2.lsp4intellij.editor.listeners.DocumentListenerImpl;
import org.wso2.lsp4intellij.editor.listeners.EditorMouseListenerImpl;
import org.wso2.lsp4intellij.editor.listeners.EditorMouseMotionListenerImpl;
import org.wso2.lsp4intellij.extensions.LSPExtensionManager;
import org.wso2.lsp4intellij.requests.Timeout;
import org.wso2.lsp4intellij.requests.Timeouts;
import org.wso2.lsp4intellij.utils.ApplicationUtils;
import org.wso2.lsp4intellij.utils.FileUtils;
import org.wso2.lsp4intellij.utils.LSPException;

public class LanguageServerWrapper {
    private Logger LOG = Logger.getInstance(LanguageServerWrapper.class);
    private static CloudNotifier notifier = new CloudNotifier("Language Server Protocol client");
    private static final Map<Pair<String, String>, LanguageServerWrapper> uriToLanguageServerWrapper = new ConcurrentHashMap<Pair<String, String>, LanguageServerWrapper>();
    private final LSPExtensionManager extManager;
    public LanguageServerDefinition serverDefinition;
    private Project project;
    private final HashSet<Editor> toConnect = new HashSet();
    private String rootPath;
    private final Map<String, EditorEventManager> connectedEditors = new ConcurrentHashMap<String, EditorEventManager>();
    private LSPServerStatusWidget statusWidget;
    private int crashCount = 0;
    private volatile boolean alreadyShownTimeout = false;
    private volatile boolean alreadyShownCrash = false;
    private volatile ServerStatus status = ServerStatus.STOPPED;
    private LanguageServer languageServer;
    private LanguageClient client;
    private RequestManager requestManager;
    private InitializeResult initializeResult;
    private Future<?> launcherFuture;
    private CompletableFuture<InitializeResult> initializeFuture;
    private boolean capabilitiesAlreadyRequested = false;
    private long initializeStartTime = 0L;

    public LanguageServerWrapper(LanguageServerDefinition serverDefinition, Project project) {
        this(serverDefinition, project, null);
    }

    public LanguageServerWrapper(LanguageServerDefinition serverDefinition, Project project, LSPExtensionManager extManager) {
        this.serverDefinition = serverDefinition;
        this.project = project;
        this.rootPath = project.getBasePath();
        this.statusWidget = LSPServerStatusWidget.createWidgetFor(this);
        this.extManager = extManager;
    }

    public Map<String, EditorEventManager> getConnectedEditors() {
        return this.connectedEditors;
    }

    public static LanguageServerWrapper forUri(String uri, Project project) {
        return uriToLanguageServerWrapper.get(new MutablePair((Object)uri, (Object)FileUtils.projectToUri(project)));
    }

    public static LanguageServerWrapper forEditor(Editor editor) {
        return uriToLanguageServerWrapper.get(new MutablePair((Object)FileUtils.editorToURIString(editor), (Object)FileUtils.editorToProjectFolderUri(editor)));
    }

    public LanguageServerDefinition getServerDefinition() {
        return this.serverDefinition;
    }

    public boolean isWillSaveWaitUntil() {
        Either capabilities;
        ServerCapabilities serverCapabilities = this.getServerCapabilities();
        Either either = capabilities = serverCapabilities != null ? serverCapabilities.getTextDocumentSync() : null;
        if (capabilities == null) {
            return false;
        }
        if (capabilities.isLeft()) {
            return false;
        }
        return ((TextDocumentSyncOptions)capabilities.getRight()).getWillSaveWaitUntil();
    }

    @Nullable
    public ServerCapabilities getServerCapabilities() {
        if (this.initializeResult != null) {
            return this.initializeResult.getCapabilities();
        }
        try {
            this.start();
            if (this.initializeFuture != null) {
                this.initializeFuture.get(this.capabilitiesAlreadyRequested ? 0 : Timeout.getTimeout(Timeouts.INIT), TimeUnit.MILLISECONDS);
                this.notifySuccess(Timeouts.INIT);
            }
        }
        catch (TimeoutException e) {
            this.notifyFailure(Timeouts.INIT);
            String msg = String.format("%s \n is not initialized after %d seconds", this.serverDefinition.toString(), Timeout.getTimeout(Timeouts.INIT) / 1000);
            this.LOG.warn(msg, (Throwable)e);
            ApplicationUtils.invokeLater(() -> {
                if (!this.alreadyShownTimeout) {
                    notifier.showMessage(msg, MessageType.WARNING);
                    this.alreadyShownTimeout = true;
                }
            });
            this.stop(false);
        }
        catch (Exception e) {
            this.LOG.warn((Throwable)e);
            this.stop(false);
        }
        this.capabilitiesAlreadyRequested = true;
        return this.initializeResult != null ? this.initializeResult.getCapabilities() : null;
    }

    public void notifyResult(Timeouts timeouts, boolean success) {
        this.statusWidget.notifyResult(timeouts, success);
    }

    public void notifySuccess(Timeouts timeouts) {
        this.notifyResult(timeouts, true);
    }

    public void notifyFailure(Timeouts timeouts) {
        this.notifyResult(timeouts, false);
    }

    public EditorEventManager getEditorManagerFor(String uri) {
        return this.connectedEditors.get(uri);
    }

    public RequestManager getRequestManager() {
        return this.requestManager;
    }

    public boolean isActive() {
        return this.launcherFuture != null && !this.launcherFuture.isDone() && !this.launcherFuture.isCancelled() && !this.alreadyShownTimeout && !this.alreadyShownCrash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(Editor editor) {
        if (editor == null) {
            this.LOG.warn("editor is null for " + this.serverDefinition);
            return;
        }
        if (!FileUtils.isEditorSupported(editor)) {
            this.LOG.debug("Editor hosts a unsupported file type by the LS library.");
            return;
        }
        String uri = FileUtils.editorToURIString(editor);
        uriToLanguageServerWrapper.put((Pair<String, String>)new MutablePair((Object)uri, (Object)FileUtils.editorToProjectFolderUri(editor)), this);
        if (this.connectedEditors.containsKey(uri)) {
            return;
        }
        this.start();
        if (this.initializeFuture != null) {
            ServerCapabilities capabilities = this.getServerCapabilities();
            if (capabilities == null) {
                this.LOG.warn("Capabilities are null for " + this.serverDefinition);
                return;
            }
            this.initializeFuture.thenRun(() -> {
                block13: {
                    if (this.connectedEditors.containsKey(uri)) {
                        return;
                    }
                    try {
                        Object manager;
                        Either syncOptions = capabilities.getTextDocumentSync();
                        TextDocumentSyncKind syncKind = null;
                        if (syncOptions == null) break block13;
                        if (syncOptions.isRight()) {
                            syncKind = ((TextDocumentSyncOptions)syncOptions.getRight()).getChange();
                        } else if (syncOptions.isLeft()) {
                            syncKind = (TextDocumentSyncKind)syncOptions.getLeft();
                        }
                        DocumentListenerImpl documentListener = new DocumentListenerImpl();
                        EditorMouseListenerImpl mouseListener = new EditorMouseListenerImpl();
                        EditorMouseMotionListenerImpl mouseMotionListener = new EditorMouseMotionListenerImpl();
                        ServerOptions serverOptions = new ServerOptions(syncKind, capabilities.getCompletionProvider(), capabilities.getSignatureHelpProvider(), capabilities.getCodeLensProvider(), capabilities.getDocumentOnTypeFormattingProvider(), capabilities.getDocumentLinkProvider(), capabilities.getExecuteCommandProvider(), capabilities.getSemanticHighlighting());
                        if (this.extManager != null) {
                            manager = this.extManager.getExtendedEditorEventManagerFor(editor, documentListener, mouseListener, mouseMotionListener, this.requestManager, serverOptions, this);
                            if (manager == null) {
                                manager = new EditorEventManager(editor, documentListener, mouseListener, mouseMotionListener, this.requestManager, serverOptions, this);
                            }
                        } else {
                            manager = new EditorEventManager(editor, documentListener, mouseListener, mouseMotionListener, this.requestManager, serverOptions, this);
                        }
                        documentListener.setManager((EditorEventManager)manager);
                        mouseListener.setManager((EditorEventManager)manager);
                        mouseMotionListener.setManager((EditorEventManager)manager);
                        ((EditorEventManager)manager).registerListeners();
                        this.connectedEditors.put(uri, (EditorEventManager)manager);
                        ((EditorEventManager)manager).documentOpened();
                        this.LOG.info("Created a manager for " + uri);
                        HashSet<Editor> hashSet = this.toConnect;
                        synchronized (hashSet) {
                            this.toConnect.remove(editor);
                        }
                        for (Editor ed : this.toConnect) {
                            this.connect(ed);
                        }
                        ApplicationUtils.computableReadAction(() -> {
                            DaemonCodeAnalyzer.getInstance((Project)this.project).restart(PsiDocumentManager.getInstance((Project)this.project).getPsiFile(editor.getDocument()));
                            return null;
                        });
                    }
                    catch (Exception e) {
                        this.LOG.error((Throwable)e);
                    }
                }
            });
        } else {
            HashSet<Editor> hashSet = this.toConnect;
            synchronized (hashSet) {
                this.toConnect.add(editor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(boolean exit) {
        block14: {
            try {
                if (this.initializeFuture != null) {
                    this.initializeFuture.cancel(true);
                    this.initializeFuture = null;
                }
                this.initializeResult = null;
                this.capabilitiesAlreadyRequested = false;
                if (this.languageServer != null) {
                    CompletableFuture shutdown = this.languageServer.shutdown();
                    shutdown.get(Timeout.getTimeout(Timeouts.SHUTDOWN), TimeUnit.MILLISECONDS);
                    this.notifySuccess(Timeouts.SHUTDOWN);
                    if (exit) {
                        this.languageServer.exit();
                    }
                }
                if (this.launcherFuture == null) break block14;
                this.launcherFuture.cancel(true);
            }
            catch (Exception e) {
                block15: {
                    try {
                        this.notifyFailure(Timeouts.SHUTDOWN);
                        if (this.launcherFuture == null) break block15;
                        this.launcherFuture.cancel(true);
                    }
                    catch (Throwable throwable) {
                        if (this.launcherFuture != null) {
                            this.launcherFuture.cancel(true);
                            this.launcherFuture = null;
                        }
                        if (this.serverDefinition != null) {
                            this.serverDefinition.stop(this.rootPath);
                        }
                        for (Map.Entry<String, EditorEventManager> ed : this.connectedEditors.entrySet()) {
                            this.disconnect(ed.getValue().editor);
                        }
                        this.languageServer = null;
                        this.setStatus(ServerStatus.STOPPED);
                        throw throwable;
                    }
                    this.launcherFuture = null;
                }
                if (this.serverDefinition != null) {
                    this.serverDefinition.stop(this.rootPath);
                }
                for (Map.Entry<String, EditorEventManager> entry : this.connectedEditors.entrySet()) {
                    this.disconnect(entry.getValue().editor);
                }
                this.languageServer = null;
                this.setStatus(ServerStatus.STOPPED);
            }
            this.launcherFuture = null;
        }
        if (this.serverDefinition != null) {
            this.serverDefinition.stop(this.rootPath);
        }
        for (Map.Entry entry : this.connectedEditors.entrySet()) {
            this.disconnect(((EditorEventManager)entry.getValue()).editor);
        }
        this.languageServer = null;
        this.setStatus(ServerStatus.STOPPED);
    }

    public boolean isConnectedTo(String location) {
        return this.connectedEditors.containsKey(location);
    }

    @Nullable
    public LanguageServer getServer() {
        this.start();
        if (this.initializeFuture != null && !this.initializeFuture.isDone()) {
            this.initializeFuture.join();
        }
        return this.languageServer;
    }

    private void start() {
        if (this.status == ServerStatus.STOPPED && !this.alreadyShownCrash && !this.alreadyShownTimeout) {
            this.setStatus(ServerStatus.STARTING);
            try {
                Pair<InputStream, OutputStream> streams = this.serverDefinition.start(this.rootPath);
                InputStream inputStream = (InputStream)streams.getKey();
                OutputStream outputStream = (OutputStream)streams.getValue();
                InitializeParams initParams = this.getInitParams();
                ExecutorService executorService = Executors.newCachedThreadPool();
                MessageHandler messageHandler = new MessageHandler(this.serverDefinition.getServerListener());
                if (this.extManager != null && this.extManager.getExtendedServerInterface() != null) {
                    Class<? extends LanguageServer> remoteServerInterFace = this.extManager.getExtendedServerInterface();
                    this.client = this.extManager.getExtendedClientFor(new ServerWrapperBaseClientContext(this));
                    Launcher launcher = Launcher.createLauncher((Object)this.client, remoteServerInterFace, (InputStream)inputStream, (OutputStream)outputStream, (ExecutorService)executorService, (Function)messageHandler);
                    this.languageServer = (LanguageServer)launcher.getRemoteProxy();
                    this.launcherFuture = launcher.startListening();
                } else {
                    this.client = new DefaultLanguageClient(new ServerWrapperBaseClientContext(this));
                    Launcher launcher = Launcher.createLauncher((Object)this.client, LanguageServer.class, (InputStream)inputStream, (OutputStream)outputStream, (ExecutorService)executorService, (Function)messageHandler);
                    this.languageServer = (LanguageServer)launcher.getRemoteProxy();
                    this.launcherFuture = launcher.startListening();
                }
                messageHandler.setLanguageServer(this.languageServer);
                this.initializeFuture = this.languageServer.initialize(initParams).thenApply(res -> {
                    this.initializeResult = res;
                    this.LOG.info("Got initializeResult for " + this.serverDefinition + " ; " + this.rootPath);
                    if (this.extManager != null) {
                        this.requestManager = this.extManager.getExtendedRequestManagerFor(this, this.languageServer, this.client, res.getCapabilities());
                        if (this.requestManager == null) {
                            this.requestManager = new DefaultRequestManager(this, this.languageServer, this.client, res.getCapabilities());
                        }
                    } else {
                        this.requestManager = new DefaultRequestManager(this, this.languageServer, this.client, res.getCapabilities());
                    }
                    this.setStatus(ServerStatus.STARTED);
                    this.requestManager.initialized(new InitializedParams());
                    this.setStatus(ServerStatus.INITIALIZED);
                    return res;
                });
                this.initializeStartTime = System.currentTimeMillis();
            }
            catch (IOException | LSPException e) {
                this.LOG.warn((Throwable)e);
                ApplicationUtils.invokeLater(() -> notifier.showMessage(String.format("Can't start server due to %s", e.getMessage()), MessageType.WARNING));
                this.removeServerWrapper();
            }
        }
    }

    private InitializeParams getInitParams() {
        InitializeParams initParams = new InitializeParams();
        initParams.setRootUri(FileUtils.pathToUri(this.rootPath));
        WorkspaceClientCapabilities workspaceClientCapabilities = new WorkspaceClientCapabilities();
        workspaceClientCapabilities.setApplyEdit(Boolean.valueOf(true));
        workspaceClientCapabilities.setDidChangeWatchedFiles(new DidChangeWatchedFilesCapabilities());
        workspaceClientCapabilities.setExecuteCommand(new ExecuteCommandCapabilities());
        workspaceClientCapabilities.setWorkspaceEdit(new WorkspaceEditCapabilities());
        workspaceClientCapabilities.setSymbol(new SymbolCapabilities());
        workspaceClientCapabilities.setWorkspaceFolders(Boolean.valueOf(false));
        workspaceClientCapabilities.setConfiguration(Boolean.valueOf(false));
        TextDocumentClientCapabilities textDocumentClientCapabilities = new TextDocumentClientCapabilities();
        textDocumentClientCapabilities.setCodeAction(new CodeActionCapabilities());
        textDocumentClientCapabilities.setCompletion(new CompletionCapabilities(new CompletionItemCapabilities(Boolean.valueOf(false))));
        textDocumentClientCapabilities.setDefinition(new DefinitionCapabilities());
        textDocumentClientCapabilities.setDocumentHighlight(new DocumentHighlightCapabilities());
        textDocumentClientCapabilities.setFormatting(new FormattingCapabilities());
        textDocumentClientCapabilities.setHover(new HoverCapabilities());
        textDocumentClientCapabilities.setOnTypeFormatting(new OnTypeFormattingCapabilities());
        textDocumentClientCapabilities.setRangeFormatting(new RangeFormattingCapabilities());
        textDocumentClientCapabilities.setReferences(new ReferencesCapabilities());
        textDocumentClientCapabilities.setRename(new RenameCapabilities());
        textDocumentClientCapabilities.setSemanticHighlightingCapabilities(new SemanticHighlightingCapabilities(Boolean.valueOf(false)));
        textDocumentClientCapabilities.setSignatureHelp(new SignatureHelpCapabilities());
        textDocumentClientCapabilities.setSynchronization(new SynchronizationCapabilities(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true)));
        initParams.setCapabilities(new ClientCapabilities(workspaceClientCapabilities, textDocumentClientCapabilities, null));
        initParams.setInitializationOptions(this.serverDefinition.getInitializationOptions(URI.create(initParams.getRootUri())));
        return initParams;
    }

    public void logMessage(Message message) {
        ResponseMessage responseMessage;
        if (message instanceof ResponseMessage && (responseMessage = (ResponseMessage)message).getError() != null && responseMessage.getId().equals(Integer.toString(ResponseErrorCode.RequestCancelled.getValue()))) {
            this.LOG.error((Throwable)new ResponseErrorException(responseMessage.getError()));
        }
    }

    public Project getProject() {
        return this.project;
    }

    public ServerStatus getStatus() {
        return this.status;
    }

    private void setStatus(ServerStatus status) {
        this.status = status;
        this.statusWidget.setStatus(status);
    }

    public void crashed(Exception e) {
        ++this.crashCount;
        if (this.crashCount <= 3) {
            this.reconnect();
        } else {
            ApplicationUtils.invokeLater(() -> {
                if (this.alreadyShownCrash) {
                    this.reconnect();
                } else {
                    int response = Messages.showYesNoDialog((String)String.format("LanguageServer for definition %s, project %s keeps crashing due to \n%s\n", this.serverDefinition.toString(), this.project.getName(), e.getMessage()), (String)"Language Server Client Warning", (String)"Keep Connected", (String)"Disconnect", (Icon)PlatformIcons.CHECK_ICON);
                    if (response == 1) {
                        int confirm = Messages.showYesNoDialog((String)"All the language server based plugin features will be disabled.\nDo you wish to continue?", (String)"", (Icon)PlatformIcons.WARNING_INTRODUCTION_ICON);
                        if (confirm == 0) {
                            this.stop(true);
                        } else {
                            this.reconnect();
                        }
                    } else {
                        this.reconnect();
                    }
                }
                this.alreadyShownCrash = true;
                this.crashCount = 0;
            });
        }
    }

    private void reconnect() {
        HashSet<String> connected = new HashSet<String>(this.connectedEditors.keySet());
        this.stop(true);
        for (String uri : connected) {
            this.connect(uri);
        }
    }

    public List<String> getConnectedFiles() {
        ArrayList<String> connected = new ArrayList<String>();
        this.connectedEditors.keySet().forEach(s -> {
            try {
                connected.add(new URI(FileUtils.sanitizeURI(s)).toString());
            }
            catch (URISyntaxException e) {
                this.LOG.warn((Throwable)e);
            }
        });
        return connected;
    }

    public void removeWidget() {
        this.statusWidget.dispose();
    }

    public void disconnect(Editor editor) {
        EditorEventManager manager = this.connectedEditors.remove(FileUtils.editorToURIString(editor));
        if (manager != null) {
            manager.removeListeners();
            manager.documentClosed();
            uriToLanguageServerWrapper.remove(new ImmutablePair((Object)FileUtils.editorToURIString(editor), (Object)FileUtils.editorToProjectFolderUri(editor)));
        }
        if (this.connectedEditors.isEmpty()) {
            this.stop(true);
        }
    }

    public void disconnect(String uri, String projectUri) {
        EditorEventManager manager = this.connectedEditors.remove(FileUtils.sanitizeURI(uri));
        if (manager != null) {
            manager.removeListeners();
            manager.documentClosed();
            uriToLanguageServerWrapper.remove(new ImmutablePair((Object)FileUtils.sanitizeURI(uri), (Object)FileUtils.sanitizeURI(projectUri)));
        }
        if (this.connectedEditors.isEmpty()) {
            this.stop(true);
        }
    }

    private void removeServerWrapper() {
        this.stop(true);
        this.removeWidget();
        IntellijLanguageClient.removeWrapper(this);
    }

    private void connect(String uri) {
        FileEditor[] fileEditors = FileEditorManager.getInstance((Project)this.project).getAllEditors(Objects.requireNonNull(FileUtils.URIToVFS(uri)));
        ArrayList<Editor> editors = new ArrayList<Editor>();
        for (FileEditor ed : fileEditors) {
            if (!(ed instanceof TextEditor)) continue;
            editors.add(((TextEditor)ed).getEditor());
        }
        if (!editors.isEmpty()) {
            this.connect((Editor)editors.get(0));
        }
    }

    public boolean isRestartable() {
        return this.status == ServerStatus.STOPPED && (this.alreadyShownTimeout || this.alreadyShownCrash);
    }

    public void restart() {
        if (this.isRestartable()) {
            this.alreadyShownCrash = false;
            this.alreadyShownTimeout = false;
            IntellijLanguageClient.restart(this.project);
        }
    }
}

