/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.lsp4intellij.client.languageserver.serverdefinition;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.wso2.lsp4intellij.client.languageserver.serverdefinition.CommandServerDefinition;
import org.wso2.lsp4intellij.utils.Utils;

public class RawCommandServerDefinition
extends CommandServerDefinition {
    private static final RawCommandServerDefinition INSTANCE = new RawCommandServerDefinition();

    private RawCommandServerDefinition() {
    }

    public static RawCommandServerDefinition getInstance() {
        return INSTANCE;
    }

    public RawCommandServerDefinition(String ext, Map<String, String> languageIds, String[] command) {
        this.ext = ext;
        this.languageIds = languageIds;
        this.command = command;
        this.typ = "rawCommand";
        this.presentableTyp = "Raw command";
    }

    public RawCommandServerDefinition(String ext, String[] command) {
        this(ext, Collections.emptyMap(), command);
    }

    @Override
    public CommandServerDefinition fromArray(String[] arr) {
        String[] arrTail;
        if (arr[0].equals(this.typ) && (arrTail = Arrays.copyOfRange(arr, 1, arr.length - 1)).length > 1) {
            new RawCommandServerDefinition(arrTail[0], Utils.parseArgs(Arrays.copyOfRange(arrTail, 1, arrTail.length - 1)));
        }
        return null;
    }

    @Override
    public String[] toArray() {
        String[] strings = new String[]{this.typ, this.ext};
        String[] merged = Arrays.copyOf(strings, strings.length + this.command.length);
        System.arraycopy(this.command, 0, merged, strings.length, this.command.length);
        return merged;
    }

    @Override
    public String toString() {
        return this.typ + " : " + String.join((CharSequence)" ", this.command);
    }

    public boolean equals(Object obj) {
        if (obj instanceof RawCommandServerDefinition) {
            RawCommandServerDefinition commandsDef = (RawCommandServerDefinition)obj;
            return this.ext.equals(commandsDef.ext) && Arrays.equals(this.command, commandsDef.command);
        }
        return false;
    }

    public int hashCode() {
        return this.ext.hashCode() + 3 * this.command.hashCode();
    }
}

