/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.lsp4intellij;

import com.intellij.AppTopics;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.wso2.lsp4intellij.client.languageserver.serverdefinition.LanguageServerDefinition;
import org.wso2.lsp4intellij.client.languageserver.wrapper.LanguageServerWrapper;
import org.wso2.lsp4intellij.editor.listeners.LSPEditorListener;
import org.wso2.lsp4intellij.editor.listeners.LSPFileDocumentManagerListener;
import org.wso2.lsp4intellij.editor.listeners.VFSListener;
import org.wso2.lsp4intellij.extensions.LSPExtensionManager;
import org.wso2.lsp4intellij.requests.Timeout;
import org.wso2.lsp4intellij.requests.Timeouts;
import org.wso2.lsp4intellij.utils.ApplicationUtils;
import org.wso2.lsp4intellij.utils.FileUtils;

public class IntellijLanguageClient
implements ApplicationComponent {
    private static Logger LOG = Logger.getInstance(IntellijLanguageClient.class);
    private static final Map<Pair<String, String>, LanguageServerWrapper> extToLanguageWrapper = new ConcurrentHashMap<Pair<String, String>, LanguageServerWrapper>();
    private static Map<String, Set<LanguageServerWrapper>> projectToLanguageWrappers = new ConcurrentHashMap<String, Set<LanguageServerWrapper>>();
    private static Map<Pair<String, String>, LanguageServerDefinition> extToServerDefinition = new ConcurrentHashMap<Pair<String, String>, LanguageServerDefinition>();
    private static Map<String, LSPExtensionManager> extToExtManager = new ConcurrentHashMap<String, LSPExtensionManager>();

    public void initComponent() {
        EditorFactory.getInstance().addEditorFactoryListener((EditorFactoryListener)new LSPEditorListener(), Disposer.newDisposable());
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new VFSListener());
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)new LSPFileDocumentManagerListener());
        LOG.info("Language Client init finished");
    }

    public static void addServerDefinition(LanguageServerDefinition definition) {
        IntellijLanguageClient.addServerDefinition(definition, null);
    }

    public static void addServerDefinition(LanguageServerDefinition definition, Project project) {
        if (definition != null) {
            if (project != null) {
                IntellijLanguageClient.processDefinition(definition, FileUtils.projectToUri(project));
                IntellijLanguageClient.restart(project);
            } else {
                IntellijLanguageClient.processDefinition(definition, "");
                IntellijLanguageClient.restart();
            }
            LOG.info("Added definition for " + definition);
        } else {
            LOG.warn("Trying to add a null definition");
        }
    }

    public static void addExtensionManager(String ext, LSPExtensionManager manager) {
        if (extToExtManager.get(ext) != null) {
            LOG.warn("An extension manager is already registered for \"" + ext + "\" extension");
        }
        extToExtManager.put(ext, manager);
    }

    public static Set<LanguageServerWrapper> getAllServerWrappers(String projectUri) {
        return projectToLanguageWrappers.getOrDefault(projectUri, Collections.emptySet());
    }

    public static boolean isExtensionSupported(VirtualFile virtualFile) {
        return extToServerDefinition.keySet().stream().anyMatch(keyMap -> ((String)keyMap.getLeft()).equals(virtualFile.getExtension()) || virtualFile.getName().matches((String)keyMap.getLeft()));
    }

    public static void editorOpened(Editor editor) {
        VirtualFile file = FileDocumentManager.getInstance().getFile(editor.getDocument());
        if (!FileUtils.isFileSupported(file)) {
            LOG.debug("Handling open on a editor which host a LightVirtual/Null file");
            return;
        }
        Project project = editor.getProject();
        if (project == null) {
            LOG.debug("Opened an unsupported editor, which does not have an attached project.");
            return;
        }
        String projectUri = FileUtils.projectToUri(project);
        if (projectUri != null) {
            ApplicationUtils.pool(() -> {
                Optional<Pair> keyForFile;
                String ext = file.getExtension();
                String fileName = file.getName();
                LOG.info("Opened " + fileName);
                LanguageServerDefinition serverDefinition = extToServerDefinition.get(new ImmutablePair((Object)ext, (Object)projectUri));
                if (serverDefinition == null && (keyForFile = extToServerDefinition.keySet().stream().filter(keyPair -> fileName.matches((String)keyPair.getLeft()) && ((String)keyPair.getRight()).equals(projectUri)).findFirst()).isPresent()) {
                    serverDefinition = extToServerDefinition.get(keyForFile.get());
                    ext = (String)keyForFile.get().getLeft();
                }
                if (serverDefinition == null) {
                    serverDefinition = extToServerDefinition.get(new ImmutablePair((Object)ext, (Object)""));
                }
                if (serverDefinition == null && (keyForFile = extToServerDefinition.keySet().stream().filter(keyPair -> fileName.matches((String)keyPair.getLeft()) && ((String)keyPair.getRight()).isEmpty()).findFirst()).isPresent()) {
                    serverDefinition = extToServerDefinition.get(keyForFile.get());
                    ext = (String)keyForFile.get().getLeft();
                }
                if (serverDefinition != null) {
                    LanguageServerWrapper wrapper = extToLanguageWrapper.get(new MutablePair((Object)ext, (Object)projectUri));
                    if (wrapper == null) {
                        String[] exts;
                        LOG.info("Instantiating wrapper for " + ext + " : " + projectUri);
                        wrapper = extToExtManager.get(ext) != null ? new LanguageServerWrapper(serverDefinition, project, extToExtManager.get(ext)) : new LanguageServerWrapper(serverDefinition, project);
                        for (String ex : exts = serverDefinition.ext.split(",")) {
                            extToLanguageWrapper.put((Pair<String, String>)new ImmutablePair((Object)ex, (Object)projectUri), wrapper);
                        }
                        Set wrappers = projectToLanguageWrappers.computeIfAbsent(projectUri, k -> new HashSet());
                        wrappers.add(wrapper);
                    } else {
                        LOG.info("Wrapper already existing for " + ext + " , " + projectUri);
                    }
                    LOG.info("Adding file " + fileName);
                    wrapper.connect(editor);
                } else {
                    LOG.warn("Could not find a server definition for " + ext);
                }
            });
        } else {
            LOG.warn("File for editor " + editor.getDocument().getText() + " is null");
        }
    }

    public static void editorClosed(Editor editor) {
        VirtualFile file = FileDocumentManager.getInstance().getFile(editor.getDocument());
        if (!FileUtils.isFileSupported(file)) {
            LOG.debug("Handling close on a editor which host a LightVirtual/Null file");
            return;
        }
        ApplicationUtils.pool(() -> {
            LanguageServerWrapper serverWrapper = LanguageServerWrapper.forEditor(editor);
            if (serverWrapper != null) {
                LOG.info("Disconnecting " + FileUtils.editorToURIString(editor));
                serverWrapper.disconnect(editor);
            }
        });
    }

    public static void restart() {
        Project[] openProjects;
        for (Project project : openProjects = ProjectManager.getInstance().getOpenProjects()) {
            IntellijLanguageClient.restart(project);
        }
    }

    public static void restart(Project project) {
        try {
            List<Editor> allOpenedEditors = FileUtils.getAllOpenedEditors(project);
            allOpenedEditors.forEach(IntellijLanguageClient::editorClosed);
            allOpenedEditors.forEach(IntellijLanguageClient::editorOpened);
        }
        catch (Exception e) {
            LOG.warn(String.format("Refreshing project: %s is failed due to: ", project.getName()), (Throwable)e);
        }
    }

    public static Map<Timeouts, Integer> getTimeouts() {
        return Timeout.getTimeouts();
    }

    public static int getTimeout(Timeouts timeoutType) {
        return IntellijLanguageClient.getTimeouts().get((Object)timeoutType);
    }

    public static void setTimeouts(Map<Timeouts, Integer> newTimeouts) {
        Timeout.setTimeouts(newTimeouts);
    }

    public static void setTimeout(Timeouts timeout, int value) {
        HashMap<Timeouts, Integer> newTimeout = new HashMap<Timeouts, Integer>();
        newTimeout.put(timeout, value);
        IntellijLanguageClient.setTimeouts(newTimeout);
    }

    private static void processDefinition(LanguageServerDefinition definition, String projectUri) {
        String[] extensions;
        for (String ext : extensions = definition.ext.split(",")) {
            ImmutablePair keyPair = new ImmutablePair((Object)ext, (Object)projectUri);
            if (extToServerDefinition.get(keyPair) == null) {
                extToServerDefinition.put((Pair<String, String>)keyPair, definition);
                LOG.info("Added server definition for " + ext);
                continue;
            }
            extToServerDefinition.replace((Pair<String, String>)keyPair, definition);
            LOG.info("Updated server definition for " + ext);
        }
    }

    public static void removeWrapper(LanguageServerWrapper wrapper) {
        if (wrapper.getProject() != null) {
            String[] extensions;
            for (String ext : extensions = wrapper.getServerDefinition().ext.split(",")) {
                extToLanguageWrapper.remove(new MutablePair((Object)ext, (Object)FileUtils.projectToUri(wrapper.getProject())));
            }
        } else {
            LOG.error("No attached projects found for wrapper");
        }
    }

    public static Map<String, Set<LanguageServerWrapper>> getProjectToLanguageWrappers() {
        return projectToLanguageWrappers;
    }

    public static void didChangeConfiguration(DidChangeConfigurationParams params, Project project) {
        Set<LanguageServerWrapper> serverWrappers = IntellijLanguageClient.getProjectToLanguageWrappers().get(FileUtils.projectToUri(project));
        serverWrappers.forEach(s -> s.getRequestManager().didChangeConfiguration(params));
    }
}

