/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.lsp4intellij.contributors.rename;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.usageView.UsageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.wso2.lsp4intellij.contributors.psi.LSPPsiElement;
import org.wso2.lsp4intellij.editor.EditorEventManager;
import org.wso2.lsp4intellij.editor.EditorEventManagerBase;
import org.wso2.lsp4intellij.requests.WorkspaceEditHandler;
import org.wso2.lsp4intellij.utils.FileUtils;

public class LSPRenameProcessor
extends RenamePsiElementProcessor {
    private static Set<VirtualFile> openedEditors = new HashSet<VirtualFile>();
    private PsiElement curElem;
    private Set<PsiElement> elements = new HashSet<PsiElement>();

    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            LSPRenameProcessor.$$$reportNull$$$0(0);
        }
        if (element instanceof LSPPsiElement) {
            return true;
        }
        if (element instanceof PsiFile) {
            FileEditor fEditor = FileEditorManager.getInstance((Project)element.getProject()).getSelectedEditor(((PsiFile)element).getVirtualFile());
            if (!(fEditor instanceof Editor)) {
                return false;
            }
            Editor editor = (Editor)fEditor;
            EditorEventManager manager = EditorEventManagerBase.forEditor(editor);
            if (manager != null && editor.getContentComponent().hasFocus()) {
                int offset = editor.getCaretModel().getCurrentCaret().getOffset();
                Pair<List<PsiElement>, List<VirtualFile>> refResponse = manager.references(offset, true, false);
                this.elements.addAll((Collection)refResponse.getFirst());
                openedEditors.addAll((Collection)refResponse.getSecond());
                this.curElem = this.elements.stream().filter(e -> e.getTextRange().getStartOffset() <= offset && offset <= e.getTextRange().getEndOffset()).findAny().orElse(null);
                if (this.curElem != null) {
                    this.elements = this.elements.stream().filter(elem -> elem.getText().equals(this.curElem.getText())).collect(Collectors.toSet());
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public RenameDialog createRenameDialog(Project project, PsiElement element, PsiElement nameSuggestionContext, Editor editor) {
        return super.createRenameDialog(project, this.curElem, nameSuggestionContext, editor);
    }

    @NotNull
    public Collection<PsiReference> findReferences(PsiElement element) {
        Collection<PsiReference> collection = this.findReferences(element, false);
        if (collection == null) {
            LSPRenameProcessor.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @NotNull
    public Collection<PsiReference> findReferences(PsiElement element, boolean searchInCommentsAndStrings) {
        if (element instanceof LSPPsiElement) {
            if (this.elements.contains(element)) {
                Collection collection = this.elements.stream().map(PsiElement::getReference).collect(Collectors.toList());
                if (collection == null) {
                    LSPRenameProcessor.$$$reportNull$$$0(2);
                }
                return collection;
            }
            EditorEventManager manager = EditorEventManagerBase.forEditor(FileUtils.editorFromPsiFile(element.getContainingFile()));
            if (manager != null) {
                Pair<List<PsiElement>, List<VirtualFile>> refs = manager.references(element.getTextOffset(), true, false);
                LSPRenameProcessor.addEditors((List)refs.getSecond());
                Collection collection = ((List)refs.getFirst()).stream().map(PsiElement::getReference).collect(Collectors.toList());
                if (collection == null) {
                    LSPRenameProcessor.$$$reportNull$$$0(3);
                }
                return collection;
            }
        }
        ArrayList<PsiReference> arrayList = new ArrayList<PsiReference>();
        if (arrayList == null) {
            LSPRenameProcessor.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    public boolean isInplaceRenameSupported() {
        return true;
    }

    public void renameElement(PsiElement element, String newName, UsageInfo[] usages, RefactoringElementListener listener) {
        WorkspaceEditHandler.applyEdit(element, newName, usages, listener, new ArrayList<VirtualFile>(openedEditors));
        openedEditors.clear();
        this.elements.clear();
        this.curElem = null;
    }

    public static void clearEditors() {
        openedEditors.clear();
    }

    public static Set<VirtualFile> getEditors() {
        return openedEditors;
    }

    public static void addEditors(List<VirtualFile> toAdd) {
        openedEditors.addAll(toAdd);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/wso2/lsp4intellij/contributors/rename/LSPRenameProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/wso2/lsp4intellij/contributors/rename/LSPRenameProcessor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canProcessElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

