/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.lsp4intellij.contributors.rename;

import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.impl.StartMarkAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.NonEmptyInputValidator;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import com.intellij.refactoring.rename.inplace.MemberInplaceRenameHandler;
import com.intellij.refactoring.rename.inplace.MemberInplaceRenamer;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.wso2.lsp4intellij.IntellijLanguageClient;
import org.wso2.lsp4intellij.contributors.psi.LSPPsiElement;
import org.wso2.lsp4intellij.contributors.rename.LSPInplaceRenamer;
import org.wso2.lsp4intellij.editor.EditorEventManager;
import org.wso2.lsp4intellij.editor.EditorEventManagerBase;

public class LSPRenameHandler
implements RenameHandler {
    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            LSPRenameHandler.$$$reportNull$$$0(0);
        }
        if (elements == null) {
            LSPRenameHandler.$$$reportNull$$$0(1);
        }
        if (elements.length == 1) {
            new MemberInplaceRenameHandler().doRename(elements[0], (Editor)dataContext.getData(CommonDataKeys.EDITOR), dataContext);
        } else {
            this.invoke(project, (Editor)dataContext.getData(CommonDataKeys.EDITOR), (PsiFile)dataContext.getData(CommonDataKeys.PSI_FILE), dataContext);
        }
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        LSPPsiElement psiElement;
        EditorEventManager manager;
        if (project == null) {
            LSPRenameHandler.$$$reportNull$$$0(2);
        }
        if ((manager = EditorEventManagerBase.forEditor(editor)) != null && editor.getContentComponent().hasFocus() && (psiElement = this.getElementAtOffset(manager, editor.getCaretModel().getCurrentCaret().getOffset())) != null) {
            this.doRename((PsiElement)psiElement, editor);
        }
    }

    private InplaceRefactoring doRename(final PsiElement elementToRename, final Editor editor) {
        if (elementToRename instanceof PsiNameIdentifierOwner) {
            RenamePsiElementProcessor processor = RenamePsiElementProcessor.forElement((PsiElement)elementToRename);
            if (processor.isInplaceRenameSupported()) {
                StartMarkAction startMarkAction = StartMarkAction.canStart((Project)elementToRename.getProject());
                if (startMarkAction == null || processor.substituteElementToRename(elementToRename, editor) == elementToRename) {
                    processor.substituteElementToRename(elementToRename, editor, (Pass)new Pass<PsiElement>(){

                        public void pass(PsiElement element) {
                            MemberInplaceRenamer renamer = LSPRenameHandler.this.createMemberRenamer(element, (PsiNameIdentifierOwner)elementToRename, editor);
                            boolean startedRename = renamer.performInplaceRename();
                            if (!startedRename) {
                                LSPRenameHandler.this.performDialogRename(editor);
                            }
                        }
                    });
                    return null;
                }
            } else {
                TemplateState templateState;
                InplaceRefactoring inplaceRefactoring = (InplaceRefactoring)editor.getUserData(InplaceRefactoring.INPLACE_RENAMER);
                if (inplaceRefactoring != null && inplaceRefactoring instanceof MemberInplaceRenamer && (templateState = TemplateManagerImpl.getTemplateState((Editor)InjectedLanguageUtil.getTopLevelEditor((Editor)editor))) != null) {
                    templateState.gotoEnd(true);
                }
            }
        }
        this.performDialogRename(editor);
        return null;
    }

    public boolean isRenaming(DataContext dataContext) {
        return this.isAvailableOnDataContext(dataContext);
    }

    public boolean isAvailableOnDataContext(DataContext dataContext) {
        PsiElement element = PsiElementRenameHandler.getElement((DataContext)dataContext);
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        return editor != null && file != null && this.isAvailable(element, editor, file);
    }

    private boolean isAvailable(PsiElement psiElement, Editor editor, PsiFile psiFile) {
        if (psiElement instanceof PsiFile || psiElement instanceof LSPPsiElement) {
            return true;
        }
        return psiElement != null && IntellijLanguageClient.isExtensionSupported(psiFile.getVirtualFile());
    }

    private MemberInplaceRenamer createMemberRenamer(PsiElement element, PsiNameIdentifierOwner elementToRename, Editor editor) {
        return new LSPInplaceRenamer((PsiNamedElement)element, (PsiElement)elementToRename, editor);
    }

    private void performDialogRename(Editor editor) {
        String renameTo;
        EditorEventManager manager = EditorEventManagerBase.forEditor(editor);
        if (manager != null && (renameTo = Messages.showInputDialog((Project)editor.getProject(), (String)"Enter new name: ", (String)"Rename", (Icon)Messages.getQuestionIcon(), (String)"", (InputValidator)new NonEmptyInputValidator())) != null && !renameTo.equals("")) {
            manager.rename(renameTo);
        }
    }

    private LSPPsiElement getElementAtOffset(EditorEventManager eventManager, int offset) {
        Pair<List<PsiElement>, List<VirtualFile>> refResponse = eventManager.references(offset, true, false);
        List refs = (List)refResponse.getFirst();
        if (refs == null || refs.isEmpty()) {
            return null;
        }
        PsiElement curElement = refs.stream().filter(e -> e.getTextRange().getStartOffset() <= offset && offset <= e.getTextRange().getEndOffset()).findAny().orElse(null);
        if (curElement != null) {
            return new LSPPsiElement(curElement.getText(), curElement.getProject(), curElement.getTextRange().getStartOffset(), curElement.getTextRange().getEndOffset(), curElement.getContainingFile());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "elements";
                break;
            }
        }
        objectArray[1] = "org/wso2/lsp4intellij/contributors/rename/LSPRenameHandler";
        objectArray[2] = "invoke";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

