/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.lsp4intellij.contributors.inspection;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.wso2.lsp4intellij.contributors.fixes.LSPCodeActionFix;
import org.wso2.lsp4intellij.contributors.fixes.LSPCommandFix;
import org.wso2.lsp4intellij.contributors.inspection.LSPInspectionPanel;
import org.wso2.lsp4intellij.contributors.psi.LSPPsiElement;
import org.wso2.lsp4intellij.editor.EditorEventManager;
import org.wso2.lsp4intellij.editor.EditorEventManagerBase;
import org.wso2.lsp4intellij.utils.DocumentUtils;
import org.wso2.lsp4intellij.utils.FileUtils;

public class LSPInspection
extends LocalInspectionTool
implements DumbAware {
    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        VirtualFile virtualFile;
        if (file == null) {
            LSPInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            LSPInspection.$$$reportNull$$$0(1);
        }
        if (FileUtils.isFileSupported(virtualFile = file.getVirtualFile())) {
            String uri = FileUtils.VFSToURI(virtualFile);
            EditorEventManager eventManager = EditorEventManagerBase.forUri(uri);
            if (eventManager != null) {
                return this.descriptorsForManager(uri, eventManager, file, manager, isOnTheFly);
            }
            if (isOnTheFly) {
                return super.checkFile(file, manager, isOnTheFly);
            }
            return super.checkFile(file, manager, isOnTheFly);
        }
        return super.checkFile(file, manager, isOnTheFly);
    }

    private ProblemDescriptor[] descriptorsForManager(String uri, EditorEventManager m, PsiFile file, InspectionManager manager, boolean isOnTheFly) {
        ArrayList<ProblemDescriptor> descriptors = new ArrayList<ProblemDescriptor>();
        if (!m.editor.isDisposed()) {
            List<Diagnostic> diagnostics = m.getDiagnostics();
            for (Diagnostic diagnostic : diagnostics) {
                int end;
                String message = diagnostic.getMessage();
                Range range = diagnostic.getRange();
                DiagnosticSeverity severity = diagnostic.getSeverity();
                int start = DocumentUtils.LSPPosToOffset(m.editor, range.getStart());
                if (start >= (end = DocumentUtils.LSPPosToOffset(m.editor, range.getEnd()))) continue;
                String name = m.editor.getDocument().getText(new TextRange(start, end));
                Object highlightType = severity == DiagnosticSeverity.Error ? ProblemHighlightType.GENERIC_ERROR : (severity == DiagnosticSeverity.Warning ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : (severity == DiagnosticSeverity.Information ? ProblemHighlightType.WEAK_WARNING : (severity == DiagnosticSeverity.Hint ? ProblemHighlightType.WEAK_WARNING : null)));
                LSPPsiElement element = new LSPPsiElement(name, m.editor.getProject(), start, end, file);
                List<Either<Command, CodeAction>> codeActionResults = m.codeAction(element);
                if (codeActionResults != null) {
                    ArrayList<LSPCommandFix> commands = new ArrayList<LSPCommandFix>();
                    ArrayList<LSPCodeActionFix> codeActions = new ArrayList<LSPCodeActionFix>();
                    for (Either<Command, CodeAction> item : codeActionResults) {
                        if (item == null) continue;
                        if (item.isLeft()) {
                            commands.add(new LSPCommandFix(uri, (Command)item.getLeft()));
                            continue;
                        }
                        if (!item.isRight()) continue;
                        codeActions.add(new LSPCodeActionFix(uri, (CodeAction)item.getRight()));
                    }
                    ArrayList<Object> fixes = new ArrayList<Object>();
                    fixes.addAll(commands);
                    fixes.addAll(codeActions);
                    try {
                        descriptors.add(manager.createProblemDescriptor((PsiElement)element, (TextRange)null, message, highlightType, isOnTheFly, fixes.toArray(new LocalQuickFix[fixes.size()])));
                    }
                    catch (Exception exception) {}
                    continue;
                }
                try {
                    descriptors.add(manager.createProblemDescriptor((PsiElement)element, (TextRange)null, message, highlightType, isOnTheFly, new LocalQuickFix[0]));
                }
                catch (Exception exception) {}
            }
        }
        ProblemDescriptor[] descArray = new ProblemDescriptor[descriptors.size()];
        return descriptors.toArray(descArray);
    }

    @NotNull
    public String getDisplayName() {
        String string = this.getShortName();
        if (string == null) {
            LSPInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        return new LSPInspectionPanel("LSP", (InspectionProfileEntry)this);
    }

    @NotNull
    public String getShortName() {
        if ("LSP" == null) {
            LSPInspection.$$$reportNull$$$0(3);
        }
        return "LSP";
    }

    @NotNull
    @Pattern(value="[a-zA-Z_0-9.-]+")
    public String getID() {
        if ("LSP" == null) {
            LSPInspection.$$$reportNull$$$0(4);
        }
        return "LSP";
    }

    @NotNull
    public String getGroupDisplayName() {
        if ("LSP" == null) {
            LSPInspection.$$$reportNull$$$0(5);
        }
        return "LSP";
    }

    public String getStaticDescription() {
        return "Reports errors by the LSP server";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/wso2/lsp4intellij/contributors/inspection/LSPInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/wso2/lsp4intellij/contributors/inspection/LSPInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

