/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.lsp4intellij.contributors.icon;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.IconLoader;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.SymbolKind;
import org.wso2.lsp4intellij.client.languageserver.ServerStatus;
import org.wso2.lsp4intellij.client.languageserver.serverdefinition.LanguageServerDefinition;
import org.wso2.lsp4intellij.contributors.icon.LSPIconProvider;

public class LSPDefaultIconProvider
extends LSPIconProvider {
    private static Icon STARTED = IconLoader.getIcon((String)"/images/started.png");
    private static Icon STARTING = IconLoader.getIcon((String)"/images/starting.png");
    private static Icon STOPPED = IconLoader.getIcon((String)"/images/stopped.png");

    public static Icon getCompletionIcon(CompletionItemKind kind) {
        switch (kind) {
            case Class: {
                return AllIcons.Nodes.Class;
            }
            case Color: {
                return null;
            }
            case Constructor: {
                return null;
            }
            case Enum: {
                return AllIcons.Nodes.Class;
            }
            case Field: {
                return AllIcons.Nodes.Field;
            }
            case File: {
                return AllIcons.FileTypes.Any_type;
            }
            case Function: {
                return AllIcons.Nodes.Function;
            }
            case Interface: {
                return AllIcons.Nodes.Interface;
            }
            case Keyword: {
                return AllIcons.Nodes.UpLevel;
            }
            case Method: {
                return AllIcons.Nodes.Method;
            }
            case Module: {
                return AllIcons.Nodes.Module;
            }
            case Property: {
                return AllIcons.Nodes.Property;
            }
            case Reference: {
                return AllIcons.Nodes.MethodReference;
            }
            case Snippet: {
                return AllIcons.Nodes.Static;
            }
            case Text: {
                return AllIcons.FileTypes.Text;
            }
            case Unit: {
                return AllIcons.Nodes.Artifact;
            }
            case Value: {
                return AllIcons.Nodes.DataSource;
            }
            case Variable: {
                return AllIcons.Nodes.Variable;
            }
        }
        return null;
    }

    public static Icon getSymbolIcon(SymbolKind kind) {
        switch (kind) {
            case Field: 
            case EnumMember: {
                return AllIcons.Nodes.Field;
            }
            case Method: {
                return AllIcons.Nodes.Method;
            }
            case Variable: {
                return AllIcons.Nodes.Variable;
            }
            case Class: {
                return AllIcons.Nodes.Class;
            }
            case Constructor: {
                return AllIcons.Nodes.ClassInitializer;
            }
            case Enum: {
                return AllIcons.Nodes.Enum;
            }
        }
        return AllIcons.Nodes.Tag;
    }

    public static Map<ServerStatus, Icon> getStatusIcons() {
        HashMap<ServerStatus, Icon> statusIconMap = new HashMap<ServerStatus, Icon>();
        statusIconMap.put(ServerStatus.STOPPED, STOPPED);
        statusIconMap.put(ServerStatus.STARTING, STARTING);
        statusIconMap.put(ServerStatus.STARTED, STARTING);
        statusIconMap.put(ServerStatus.INITIALIZED, STARTED);
        return statusIconMap;
    }

    @Override
    public boolean isSpecificFor(LanguageServerDefinition serverDefinition) {
        return false;
    }
}

