/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.lsp4intellij.contributors.fixes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Collections;
import org.eclipse.lsp4j.CodeAction;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.wso2.lsp4intellij.contributors.psi.LSPPsiElement;
import org.wso2.lsp4intellij.editor.EditorEventManager;
import org.wso2.lsp4intellij.editor.EditorEventManagerBase;
import org.wso2.lsp4intellij.requests.WorkspaceEditHandler;

public class LSPCodeActionFix
implements LocalQuickFix {
    private String uri;
    private CodeAction codeAction;

    public LSPCodeActionFix(String uri, CodeAction codeAction) {
        this.uri = uri;
        this.codeAction = codeAction;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement element;
        if (project == null) {
            LSPCodeActionFix.$$$reportNull$$$0(0);
        }
        if (descriptor == null) {
            LSPCodeActionFix.$$$reportNull$$$0(1);
        }
        if ((element = descriptor.getPsiElement()) instanceof LSPPsiElement) {
            EditorEventManager manager;
            if (this.codeAction.getEdit() != null) {
                WorkspaceEditHandler.applyEdit(this.codeAction.getEdit(), this.codeAction.getTitle());
            }
            if ((manager = EditorEventManagerBase.forUri(this.uri)) != null) {
                manager.executeCommands(Collections.singletonList(this.codeAction.getCommand()));
            }
        }
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        if ("LSP Fixes" == null) {
            LSPCodeActionFix.$$$reportNull$$$0(2);
        }
        return "LSP Fixes";
    }

    @Nls
    @NotNull
    public String getName() {
        String string = this.codeAction.getTitle();
        if (string == null) {
            LSPCodeActionFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/wso2/lsp4intellij/contributors/fixes/LSPCodeActionFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/wso2/lsp4intellij/contributors/fixes/LSPCodeActionFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

