/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.lsp4intellij.actions;

import com.intellij.codeInsight.actions.LayoutCodeDialog;
import com.intellij.codeInsight.actions.LayoutCodeOptions;
import com.intellij.codeInsight.actions.ShowReformatFileDialog;
import com.intellij.codeInsight.actions.TextRangeType;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import org.wso2.lsp4intellij.IntellijLanguageClient;
import org.wso2.lsp4intellij.editor.EditorEventManager;
import org.wso2.lsp4intellij.editor.EditorEventManagerBase;

public class LSPShowReformatDialogAction
extends ShowReformatFileDialog
implements DumbAware {
    private String HELP_ID = "editing.codeReformatting";
    private Logger LOG = Logger.getInstance(LSPShowReformatDialogAction.class);

    public void actionPerformed(AnActionEvent e) {
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (editor != null && project != null) {
            boolean alreadySupported;
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            VirtualFile virFile = FileDocumentManager.getInstance().getFile(editor.getDocument());
            boolean bl = alreadySupported = !LanguageFormatting.INSTANCE.allForLanguage(psiFile.getLanguage()).isEmpty();
            if (!alreadySupported && IntellijLanguageClient.isExtensionSupported(virFile)) {
                boolean hasSelection = editor.getSelectionModel().hasSelection();
                LayoutCodeDialog dialog = new LayoutCodeDialog(project, psiFile, hasSelection, this.HELP_ID);
                dialog.show();
                if (dialog.isOK()) {
                    LayoutCodeOptions options = dialog.getRunOptions();
                    EditorEventManager eventManager = EditorEventManagerBase.forEditor(editor);
                    if (eventManager != null) {
                        if (options.getTextRangeType() == TextRangeType.SELECTED_TEXT) {
                            eventManager.reformatSelection();
                        } else {
                            eventManager.reformat();
                        }
                    }
                } else {
                    super.actionPerformed(e);
                }
            } else {
                super.actionPerformed(e);
            }
        } else {
            super.actionPerformed(e);
        }
    }

    public void update(AnActionEvent event) {
        super.update(event);
    }
}

