/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.lsp4intellij.actions;

import com.intellij.codeInsight.documentation.actions.ShowQuickDocInfoAction;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageDocumentation;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import org.wso2.lsp4intellij.editor.EditorEventManager;
import org.wso2.lsp4intellij.editor.EditorEventManagerBase;

class LSPQuickDocAction
extends ShowQuickDocInfoAction
implements DumbAware {
    private Logger LOG = Logger.getInstance(LSPQuickDocAction.class);

    LSPQuickDocAction() {
    }

    public void actionPerformed(AnActionEvent e) {
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        VirtualFile file = FileDocumentManager.getInstance().getFile(editor.getDocument());
        Language language = PsiManager.getInstance((Project)editor.getProject()).findFile(file).getLanguage();
        if (LanguageDocumentation.INSTANCE.allForLanguage(language).isEmpty() || Integer.parseInt(ApplicationInfo.getInstance().getMajorVersion()) > 2017 && language == PlainTextLanguage.INSTANCE) {
            EditorEventManager manager = EditorEventManagerBase.forEditor(editor);
            if (manager != null) {
                manager.quickDoc(editor);
            } else {
                super.actionPerformed(e);
            }
        } else {
            super.actionPerformed(e);
        }
    }
}

