/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.api;

import com.github.badoualy.telegram.api.OnClientTimeoutListener;
import com.github.badoualy.telegram.api.TelegramClient;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u0000  2\u00020\u0001:\u0001 B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0013\u001a\u00020\u0006J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u0015J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u0017J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0006J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0013\u001a\u00020\u0006J,\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\f2\b\u0010\u001d\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u001e\u001a\u00020\u0006H\u0007J\u0006\u0010\u001f\u001a\u00020\u0019R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/github/badoualy/telegram/api/TelegramClientPool;", "", "name", "", "(Ljava/lang/String;)V", "DEFAULT_EXPIRATION_DELAY", "", "expireMap", "Ljava/util/HashMap;", "listenerMap", "Lcom/github/badoualy/telegram/api/OnClientTimeoutListener;", "map", "Lcom/github/badoualy/telegram/api/TelegramClient;", "marker", "Lorg/slf4j/Marker;", "kotlin.jvm.PlatformType", "timer", "Ljava/util/Timer;", "getAndRemove", "id", "getClients", "", "getKeys", "", "onTimeout", "", "peek", "put", "client", "listener", "expiresIn", "shutdown", "Companion", "api_main"})
public final class TelegramClientPool {
    private final Marker marker;
    private final long DEFAULT_EXPIRATION_DELAY = 300000L;
    private Timer timer;
    private final HashMap<Long, TelegramClient> map;
    private final HashMap<Long, OnClientTimeoutListener> listenerMap;
    private final HashMap<Long, Long> expireMap;
    private static final Logger logger;
    @JvmField
    @NotNull
    public static final TelegramClientPool DEFAULT_POOL;
    @JvmField
    @NotNull
    public static final TelegramClientPool DOWNLOADER_POOL;
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    public final void put(long id, @NotNull TelegramClient client, @Nullable OnClientTimeoutListener listener, long expiresIn) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        TelegramClientPool.Companion.getLogger().debug(this.marker, "Adding client with id " + id);
        Object object2 = this;
        synchronized (object2) {
            this.expireMap.put(id, System.currentTimeMillis() + expiresIn);
            if (listener != null) {
                this.listenerMap.put(id, listener);
            } else {
                this.listenerMap.remove(id);
            }
            if (this.map.containsKey(id) && Intrinsics.areEqual((Object)this.map.get(id), (Object)client) ^ true) {
                client.close(false);
            } else {
                this.map.put(id, client);
            }
            object = Unit.INSTANCE;
        }
        try {
            object2 = this.timer;
            TimerTask timerTask = new TimerTask(this, id){
                final /* synthetic */ TelegramClientPool this$0;
                final /* synthetic */ long $id$inlined;
                {
                    this.this$0 = telegramClientPool;
                    this.$id$inlined = l;
                }

                public void run() {
                    TimerTask $receiver = this;
                    this.this$0.onTimeout(this.$id$inlined);
                }
            };
            ((Timer)object2).schedule(timerTask, expiresIn);
        }
        catch (IllegalStateException e) {
            Timer timer = this.timer = new Timer(String.valueOf(this.getClass().getSimpleName()));
            object = new TimerTask(this, id){
                final /* synthetic */ TelegramClientPool this$0;
                final /* synthetic */ long $id$inlined;
                {
                    this.this$0 = telegramClientPool;
                    this.$id$inlined = l;
                }

                public void run() {
                    TimerTask $receiver = this;
                    this.this$0.onTimeout(this.$id$inlined);
                }
            };
            timer.schedule((TimerTask)object, expiresIn);
        }
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ void put$default(TelegramClientPool telegramClientPool, long l, TelegramClient telegramClient, OnClientTimeoutListener onClientTimeoutListener, long l2, int n, Object object) {
        if ((n & 8) != 0) {
            l2 = telegramClientPool.DEFAULT_EXPIRATION_DELAY;
        }
        telegramClientPool.put(l, telegramClient, onClientTimeoutListener, l2);
    }

    @JvmOverloads
    public final void put(long id, @NotNull TelegramClient client, @Nullable OnClientTimeoutListener listener) {
        TelegramClientPool.put$default(this, id, client, listener, 0L, 8, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final TelegramClient peek(long id) {
        TelegramClientPool telegramClientPool = this;
        synchronized (telegramClientPool) {
            TelegramClient telegramClient = this.map.get(id);
            return telegramClient;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final TelegramClient getAndRemove(long id) {
        TelegramClientPool telegramClientPool = this;
        synchronized (telegramClientPool) {
            this.expireMap.remove(id);
            TelegramClient telegramClient = this.map.remove(id);
            return telegramClient;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onTimeout(long id) {
        block8: {
            boolean bl;
            TelegramClientPool telegramClientPool = this;
            synchronized (telegramClientPool) {
                boolean bl2;
                if (Intrinsics.compare((long)((Number)this.expireMap.getOrDefault(id, 0L)).longValue(), (long)System.currentTimeMillis()) <= 0) {
                    TelegramClient client = this.getAndRemove(id);
                    if (client != null) {
                        TelegramClientPool.Companion.getLogger().info(this.marker, id + " client timeout");
                        client.close(false);
                        bl2 = true;
                    } else {
                        bl2 = false;
                    }
                } else {
                    bl2 = false;
                }
                bl = bl2;
            }
            boolean timeout = bl;
            if (!timeout) break block8;
            OnClientTimeoutListener onClientTimeoutListener = this.listenerMap.remove(id);
            if (onClientTimeoutListener != null) {
                onClientTimeoutListener.onClientTimeout(id);
            }
        }
    }

    public final void shutdown() {
        this.timer.cancel();
    }

    @NotNull
    public final Set<Long> getKeys() {
        return this.map.keySet();
    }

    @NotNull
    public final Collection<TelegramClient> getClients() {
        return this.map.values();
    }

    private TelegramClientPool(String name) {
        this.marker = MarkerFactory.getMarker((String)name);
        this.DEFAULT_EXPIRATION_DELAY = 300000L;
        this.timer = new Timer("Timer-" + TelegramClientPool.class.getSimpleName() + "-" + name);
        this.map = new HashMap();
        this.listenerMap = new HashMap();
        this.expireMap = new HashMap();
    }

    static {
        Companion = new Companion(null);
        logger = LoggerFactory.getLogger(TelegramClientPool.class);
        DEFAULT_POOL = new TelegramClientPool("DefaultPool");
        DOWNLOADER_POOL = new TelegramClientPool("DownloaderPool");
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/github/badoualy/telegram/api/TelegramClientPool$Companion;", "", "()V", "DEFAULT_POOL", "Lcom/github/badoualy/telegram/api/TelegramClientPool;", "DOWNLOADER_POOL", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLogger", "()Lorg/slf4j/Logger;", "api_main"})
    public static final class Companion {
        private final Logger getLogger() {
            return logger;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

