/*
 * Decompiled with CFR 0.152.
 */
package net.badata.protobuf.converter.writer;

import java.lang.reflect.InvocationTargetException;
import net.badata.protobuf.converter.exception.WriteException;
import net.badata.protobuf.converter.inspection.DefaultValue;
import net.badata.protobuf.converter.inspection.NullValueInspector;
import net.badata.protobuf.converter.resolver.FieldResolver;
import net.badata.protobuf.converter.type.TypeConverter;
import net.badata.protobuf.converter.utils.FieldUtils;
import net.badata.protobuf.converter.writer.AbstractWriter;

public class DomainWriter
extends AbstractWriter {
    private final Class<?> destinationClass;

    public DomainWriter(Object destination) {
        super(destination);
        this.destinationClass = destination.getClass();
    }

    @Override
    protected void write(Object destination, FieldResolver fieldResolver, Object value) throws WriteException {
        NullValueInspector nullInspector = fieldResolver.getNullValueInspector();
        DefaultValue defaultValueCreator = fieldResolver.getDefaultValue();
        TypeConverter<?, ?> typeConverter = fieldResolver.getTypeConverter();
        if (nullInspector.isNull(value)) {
            this.writeValue(destination, fieldResolver, defaultValueCreator.generateValue(fieldResolver.getDomainType()));
        } else {
            this.writeValue(destination, fieldResolver, typeConverter.toDomainValue(value));
        }
    }

    private void writeValue(Object destination, FieldResolver fieldResolver, Object value) throws WriteException {
        String setterName = FieldUtils.createDomainSetterName(fieldResolver);
        try {
            this.destinationClass.getMethod(setterName, fieldResolver.getDomainType()).invoke(destination, value);
        }
        catch (IllegalAccessException e) {
            throw new WriteException(String.format("Access denied. '%s.%s()'", this.destinationClass.getName(), setterName));
        }
        catch (InvocationTargetException e) {
            throw new WriteException(String.format("Can't set field value through '%s.%s()'", this.destinationClass.getName(), setterName));
        }
        catch (NoSuchMethodException e) {
            throw new WriteException(String.format("Setter not found: '%s.%s()'", this.destinationClass.getName(), setterName));
        }
    }
}

