/*
 * Decompiled with CFR 0.152.
 */
package net.badata.protobuf.converter.mapping;

import com.google.protobuf.Message;
import java.lang.reflect.InvocationTargetException;
import net.badata.protobuf.converter.exception.MappingException;
import net.badata.protobuf.converter.mapping.Mapper;
import net.badata.protobuf.converter.mapping.MappingResult;
import net.badata.protobuf.converter.resolver.FieldResolver;
import net.badata.protobuf.converter.utils.FieldUtils;

public class DefaultMapperImpl
implements Mapper {
    @Override
    public <T extends Message> MappingResult mapToDomainField(FieldResolver fieldResolver, T protobuf, Object domain) throws MappingException {
        Object protobufFieldValue = this.getFieldValue(FieldUtils.createProtobufGetterName(fieldResolver), protobuf);
        if (FieldUtils.isComplexType(fieldResolver.getField())) {
            boolean hasFieldValue = true;
            try {
                String hasserName = FieldUtils.createProtobufHasserName(fieldResolver);
                if (hasserName != null) {
                    hasFieldValue = this.hasFieldValue(hasserName, protobuf);
                }
            }
            catch (MappingException mappingException) {
                // empty catch block
            }
            if (hasFieldValue) {
                return new MappingResult(MappingResult.Result.NESTED_MAPPING, protobufFieldValue, domain);
            }
            return new MappingResult(MappingResult.Result.MAPPED, null, domain);
        }
        if (FieldUtils.isCollectionType(fieldResolver.getField())) {
            return new MappingResult(MappingResult.Result.COLLECTION_MAPPING, protobufFieldValue, domain);
        }
        return new MappingResult(MappingResult.Result.MAPPED, protobufFieldValue, domain);
    }

    private boolean hasFieldValue(String hasserName, Object source) throws MappingException {
        Class<?> sourceClass = source.getClass();
        try {
            return (Boolean)sourceClass.getMethod(hasserName, new Class[0]).invoke(source, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new MappingException(String.format("Access denied. '%s.%s()'", sourceClass.getName(), hasserName));
        }
        catch (InvocationTargetException e) {
            throw new MappingException(String.format("Can't decide if field has value through '%s.%s()'", sourceClass.getName(), hasserName));
        }
        catch (NoSuchMethodException e) {
            throw new MappingException(String.format("Hasser not found. '%s.%s()'", sourceClass.getName(), hasserName));
        }
    }

    private Object getFieldValue(String getterName, Object source) throws MappingException {
        Class<?> sourceClass = source.getClass();
        try {
            return sourceClass.getMethod(getterName, new Class[0]).invoke(source, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new MappingException(String.format("Access denied. '%s.%s()'", sourceClass.getName(), getterName));
        }
        catch (InvocationTargetException e) {
            throw new MappingException(String.format("Can't set field value through '%s.%s()'", sourceClass.getName(), getterName));
        }
        catch (NoSuchMethodException e) {
            throw new MappingException(String.format("Getter not found. '%s.%s()'", sourceClass.getName(), getterName));
        }
    }

    @Override
    public <T extends Message.Builder> MappingResult mapToProtobufField(FieldResolver fieldResolver, Object domain, T protobufBuilder) throws MappingException {
        Object domainFieldValue = this.getFieldValue(FieldUtils.createDomainGetterName(fieldResolver), domain);
        if (FieldUtils.isComplexType(fieldResolver.getField())) {
            return new MappingResult(MappingResult.Result.NESTED_MAPPING, domainFieldValue, protobufBuilder);
        }
        if (FieldUtils.isCollectionType(fieldResolver.getField())) {
            return new MappingResult(MappingResult.Result.COLLECTION_MAPPING, domainFieldValue, protobufBuilder);
        }
        return new MappingResult(MappingResult.Result.MAPPED, domainFieldValue, protobufBuilder);
    }
}

