/*
 * Decompiled with CFR 0.152.
 */
package com.github.axet.threads;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class LimitThreadPool
extends ThreadPoolExecutor {
    Object lock = new Object();
    int count = 0;
    List<Thread> threads = new LinkedList<Thread>();

    public LimitThreadPool(int maxThreadCount) {
        super(0, maxThreadCount, 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new BlockUntilFree());
        this.setThreadFactory(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, LimitThreadPool.class.getSimpleName() + " - " + LimitThreadPool.this.threads.size());
                LimitThreadPool.this.threads.add(t);
                return t;
            }
        });
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        Object object = this.lock;
        synchronized (object) {
            --this.count;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean active() {
        Object object = this.lock;
        synchronized (object) {
            return this.count > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilNextTaskEnds() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            if (this.active()) {
                this.lock.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilTermination() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            while (this.active()) {
                this.waitUntilNextTaskEnds();
            }
        }
    }

    @Override
    public void execute(Runnable command) {
        SafetyCheck s = (SafetyCheck)command;
        super.execute(s.getCause());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blockExecute(Runnable command) throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            ++this.count;
        }
        this.execute(new SafetyCheck(command));
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    public void interrupt() {
        this.shutdownNow();
    }

    public void join() throws InterruptedException {
        for (Thread t : this.threads) {
            t.join();
        }
    }

    protected static class SafetyCheck
    implements Runnable {
        Runnable r;

        public SafetyCheck(Runnable r) {
            this.r = r;
        }

        @Override
        public void run() {
            throw new RuntimeException("should never call run() on this class");
        }

        public Runnable getCause() {
            return this.r;
        }
    }

    protected static class BlockUntilFree
    implements RejectedExecutionHandler {
        protected BlockUntilFree() {
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            try {
                executor.getQueue().put(r);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

