/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.kaptcha.impl;

import com.google.code.kaptcha.GimpyEngine;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class FishEyeGimpy
implements GimpyEngine {
    @Override
    public BufferedImage getDistortedImage(BufferedImage baseImage) {
        Graphics2D graph = (Graphics2D)baseImage.getGraphics();
        int imageHeight = baseImage.getHeight();
        int imageWidth = baseImage.getWidth();
        int horizontalLines = imageHeight / 7;
        int verticalLines = imageWidth / 7;
        int horizontalGaps = imageHeight / (horizontalLines + 1);
        int verticalGaps = imageWidth / (verticalLines + 1);
        int i = horizontalGaps;
        while (i < imageHeight) {
            graph.setColor(Color.blue);
            graph.drawLine(0, i, imageWidth, i);
            i += horizontalGaps;
        }
        i = verticalGaps;
        while (i < imageWidth) {
            graph.setColor(Color.red);
            graph.drawLine(i, 0, i, imageHeight);
            i += verticalGaps;
        }
        int[] pix = new int[imageHeight * imageWidth];
        int j = 0;
        int j1 = 0;
        while (j1 < imageWidth) {
            int k1 = 0;
            while (k1 < imageHeight) {
                pix[j] = baseImage.getRGB(j1, k1);
                ++j;
                ++k1;
            }
            ++j1;
        }
        double distance = this.ranInt(imageWidth / 4, imageWidth / 3);
        int widthMiddle = baseImage.getWidth() / 2;
        int heightMiddle = baseImage.getHeight() / 2;
        int x = 0;
        while (x < baseImage.getWidth()) {
            int y = 0;
            while (y < baseImage.getHeight()) {
                int relX = x - widthMiddle;
                int relY = y - heightMiddle;
                double d1 = Math.sqrt(relX * relX + relY * relY);
                if (d1 < distance) {
                    int j2 = widthMiddle + (int)(this.fishEyeFormula(d1 / distance) * distance / d1 * (double)(x - widthMiddle));
                    int k2 = heightMiddle + (int)(this.fishEyeFormula(d1 / distance) * distance / d1 * (double)(y - heightMiddle));
                    baseImage.setRGB(x, y, pix[j2 * imageHeight + k2]);
                }
                ++y;
            }
            ++x;
        }
        return baseImage;
    }

    private int ranInt(int i, int j) {
        double d = Math.random();
        return (int)((double)i + (double)(j - i + 1) * d);
    }

    private double fishEyeFormula(double s) {
        if (s < 0.0) {
            return 0.0;
        }
        if (s > 1.0) {
            return s;
        }
        return -0.75 * s * s * s + 1.5 * s * s + 0.25 * s;
    }
}

