/*
 * Decompiled with CFR 0.152.
 */
package com.avito.android.krop;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import android.view.View;
import com.avito.android.krop.ViewportUpdateListener;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b&\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u001eB\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\rH\u0014J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u000fH\u0016J\u000e\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u000bJ\u000e\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\rJ\u001c\u0010\u001d\u001a\u00020\u0011*\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH$R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/avito/android/krop/OverlayView;", "Landroid/view/View;", "Lcom/avito/android/krop/ViewportUpdateListener;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "clearPaint", "Landroid/graphics/Paint;", "measureListener", "Lcom/avito/android/krop/OverlayView$MeasureListener;", "overlayColor", "", "viewport", "Landroid/graphics/RectF;", "onDraw", "", "canvas", "Landroid/graphics/Canvas;", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onUpdateViewport", "newViewport", "setMeasureListener", "listener", "setOverlayColor", "color", "drawViewportView", "MeasureListener", "krop_release"})
public abstract class OverlayView
extends View
implements ViewportUpdateListener {
    private int overlayColor;
    private final Paint clearPaint;
    private RectF viewport;
    private MeasureListener measureListener;

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        boolean bl = this.measureListener != null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Overlay not inited correctly: check, if it is referenced by any MeasureListener implementation";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        MeasureListener measureListener = this.measureListener;
        if (measureListener == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"measureListener");
        }
        measureListener.onOverlayMeasured(width, height);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    @Override
    public void onUpdateViewport(@NotNull RectF newViewport) {
        Intrinsics.checkParameterIsNotNull((Object)newViewport, (String)"newViewport");
        this.viewport = newViewport;
    }

    public final void setOverlayColor(int color) {
        this.overlayColor = color;
        this.invalidate();
    }

    public final void setMeasureListener(@NotNull MeasureListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.measureListener = listener;
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        canvas.drawColor(this.overlayColor);
        RectF rectF = this.viewport;
        if (rectF == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewport");
        }
        this.drawViewportView(canvas, rectF, this.clearPaint);
    }

    protected abstract void drawViewportView(@NotNull Canvas var1, @NotNull RectF var2, @NotNull Paint var3);

    public OverlayView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Paint paint;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs);
        Paint paint2 = new Paint(1);
        OverlayView overlayView = this;
        boolean bl = false;
        boolean bl2 = false;
        Paint $this$apply = paint2;
        boolean bl3 = false;
        $this$apply.setColor(-16777216);
        $this$apply.setStyle(Paint.Style.FILL);
        $this$apply.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        overlayView.clearPaint = paint = paint2;
        this.setLayerType(1, null);
    }

    public /* synthetic */ OverlayView(Context context, AttributeSet attributeSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            attributeSet = null;
        }
        this(context, attributeSet);
    }

    public static final /* synthetic */ MeasureListener access$getMeasureListener$p(OverlayView $this) {
        MeasureListener measureListener = $this.measureListener;
        if (measureListener == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"measureListener");
        }
        return measureListener;
    }

    public static final /* synthetic */ void access$setMeasureListener$p(OverlayView $this, MeasureListener measureListener) {
        $this.measureListener = measureListener;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&\u00a8\u0006\u0007"}, d2={"Lcom/avito/android/krop/OverlayView$MeasureListener;", "", "onOverlayMeasured", "", "width", "", "height", "krop_release"})
    public static interface MeasureListener {
        public void onOverlayMeasured(int var1, int var2);
    }
}

