/*
 * Decompiled with CFR 0.152.
 */
package com.avito.android.krop;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.view.View;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0018\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005H\u0014J\u000e\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0005J\u000e\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u0005R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lcom/avito/android/krop/OverlayView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "shape", "", "(Landroid/content/Context;I)V", "(Landroid/content/Context;)V", "clearPaint", "Landroid/graphics/Paint;", "overlayColor", "overlayShape", "viewport", "Landroid/graphics/RectF;", "getViewport", "()Landroid/graphics/RectF;", "setViewport", "(Landroid/graphics/RectF;)V", "onDraw", "", "canvas", "Landroid/graphics/Canvas;", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "setOverlayColor", "color", "setOverlayShape", "krop_release"})
public final class OverlayView
extends View {
    private int overlayColor;
    private int overlayShape;
    private final Paint clearPaint;
    @NotNull
    private RectF viewport;

    @NotNull
    public final RectF getViewport() {
        return this.viewport;
    }

    public final void setViewport(@NotNull RectF rectF) {
        Intrinsics.checkParameterIsNotNull((Object)rectF, (String)"<set-?>");
        this.viewport = rectF;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (this.viewport.isEmpty()) {
            RectF rectF;
            RectF $receiver = rectF = this.viewport;
            $receiver.left = 0.0f;
            $receiver.top = 0.0f;
            $receiver.right = width;
            $receiver.bottom = height;
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    public final void setOverlayColor(int color) {
        this.overlayColor = color;
        this.invalidate();
    }

    public final void setOverlayShape(int shape) {
        this.overlayShape = shape;
        this.invalidate();
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        canvas.drawColor(this.overlayColor);
        switch (this.overlayShape) {
            case 0: {
                canvas.drawOval(this.viewport, this.clearPaint);
                break;
            }
            default: {
                canvas.drawRect(this.viewport, this.clearPaint);
            }
        }
    }

    public OverlayView(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.clearPaint = new Paint(1);
        this.viewport = new RectF();
        this.setLayerType(1, null);
        this.clearPaint.setColor(-16777216);
        this.clearPaint.setStyle(Paint.Style.FILL);
        this.clearPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
    }

    public OverlayView(@NotNull Context context, int shape) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this(context);
        this.overlayShape = shape;
    }
}

