/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp4j.whatsapp;

import it.auties.whatsapp4j.binary.BinaryArray;
import java.util.function.Function;
import lombok.NonNull;

public class WhatsappConfiguration {
    @NonNull
    private final String whatsappUrl;
    @NonNull
    private final String requestTag;
    @NonNull
    private final String description;
    @NonNull
    private final String shortDescription;
    @NonNull
    private final Function<String, Boolean> reconnectWhenDisconnected;
    private final boolean async;

    @NonNull
    public static WhatsappConfiguration defaultOptions() {
        return WhatsappConfiguration.builder().build();
    }

    private static String $default$whatsappUrl() {
        return "wss://web.whatsapp.com/ws";
    }

    private static String $default$requestTag() {
        return BinaryArray.random(12).toHex();
    }

    private static String $default$description() {
        return "Whatsapp4j";
    }

    private static String $default$shortDescription() {
        return "W4J";
    }

    private static Function<String, Boolean> $default$reconnectWhenDisconnected() {
        return reason -> true;
    }

    private static boolean $default$async() {
        return true;
    }

    WhatsappConfiguration(@NonNull String whatsappUrl, @NonNull String requestTag, @NonNull String description, @NonNull String shortDescription, @NonNull Function<String, Boolean> reconnectWhenDisconnected, boolean async) {
        if (whatsappUrl == null) {
            throw new NullPointerException("whatsappUrl is marked non-null but is null");
        }
        if (requestTag == null) {
            throw new NullPointerException("requestTag is marked non-null but is null");
        }
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        if (shortDescription == null) {
            throw new NullPointerException("shortDescription is marked non-null but is null");
        }
        if (reconnectWhenDisconnected == null) {
            throw new NullPointerException("reconnectWhenDisconnected is marked non-null but is null");
        }
        this.whatsappUrl = whatsappUrl;
        this.requestTag = requestTag;
        this.description = description;
        this.shortDescription = shortDescription;
        this.reconnectWhenDisconnected = reconnectWhenDisconnected;
        this.async = async;
    }

    public static WhatsappConfigurationBuilder builder() {
        return new WhatsappConfigurationBuilder();
    }

    @NonNull
    public String whatsappUrl() {
        return this.whatsappUrl;
    }

    @NonNull
    public String requestTag() {
        return this.requestTag;
    }

    @NonNull
    public String description() {
        return this.description;
    }

    @NonNull
    public String shortDescription() {
        return this.shortDescription;
    }

    @NonNull
    public Function<String, Boolean> reconnectWhenDisconnected() {
        return this.reconnectWhenDisconnected;
    }

    public boolean async() {
        return this.async;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WhatsappConfiguration)) {
            return false;
        }
        WhatsappConfiguration other = (WhatsappConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.async() != other.async()) {
            return false;
        }
        String this$whatsappUrl = this.whatsappUrl();
        String other$whatsappUrl = other.whatsappUrl();
        if (this$whatsappUrl == null ? other$whatsappUrl != null : !this$whatsappUrl.equals(other$whatsappUrl)) {
            return false;
        }
        String this$requestTag = this.requestTag();
        String other$requestTag = other.requestTag();
        if (this$requestTag == null ? other$requestTag != null : !this$requestTag.equals(other$requestTag)) {
            return false;
        }
        String this$description = this.description();
        String other$description = other.description();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$shortDescription = this.shortDescription();
        String other$shortDescription = other.shortDescription();
        if (this$shortDescription == null ? other$shortDescription != null : !this$shortDescription.equals(other$shortDescription)) {
            return false;
        }
        Function<String, Boolean> this$reconnectWhenDisconnected = this.reconnectWhenDisconnected();
        Function<String, Boolean> other$reconnectWhenDisconnected = other.reconnectWhenDisconnected();
        return !(this$reconnectWhenDisconnected == null ? other$reconnectWhenDisconnected != null : !this$reconnectWhenDisconnected.equals(other$reconnectWhenDisconnected));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WhatsappConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.async() ? 79 : 97);
        String $whatsappUrl = this.whatsappUrl();
        result = result * 59 + ($whatsappUrl == null ? 43 : $whatsappUrl.hashCode());
        String $requestTag = this.requestTag();
        result = result * 59 + ($requestTag == null ? 43 : $requestTag.hashCode());
        String $description = this.description();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $shortDescription = this.shortDescription();
        result = result * 59 + ($shortDescription == null ? 43 : $shortDescription.hashCode());
        Function<String, Boolean> $reconnectWhenDisconnected = this.reconnectWhenDisconnected();
        result = result * 59 + ($reconnectWhenDisconnected == null ? 43 : $reconnectWhenDisconnected.hashCode());
        return result;
    }

    public String toString() {
        return "WhatsappConfiguration(whatsappUrl=" + this.whatsappUrl() + ", requestTag=" + this.requestTag() + ", description=" + this.description() + ", shortDescription=" + this.shortDescription() + ", reconnectWhenDisconnected=" + this.reconnectWhenDisconnected() + ", async=" + this.async() + ")";
    }

    public static class WhatsappConfigurationBuilder {
        private boolean whatsappUrl$set;
        private String whatsappUrl$value;
        private boolean requestTag$set;
        private String requestTag$value;
        private boolean description$set;
        private String description$value;
        private boolean shortDescription$set;
        private String shortDescription$value;
        private boolean reconnectWhenDisconnected$set;
        private Function<String, Boolean> reconnectWhenDisconnected$value;
        private boolean async$set;
        private boolean async$value;

        WhatsappConfigurationBuilder() {
        }

        public WhatsappConfigurationBuilder whatsappUrl(@NonNull String whatsappUrl) {
            if (whatsappUrl == null) {
                throw new NullPointerException("whatsappUrl is marked non-null but is null");
            }
            this.whatsappUrl$value = whatsappUrl;
            this.whatsappUrl$set = true;
            return this;
        }

        public WhatsappConfigurationBuilder requestTag(@NonNull String requestTag) {
            if (requestTag == null) {
                throw new NullPointerException("requestTag is marked non-null but is null");
            }
            this.requestTag$value = requestTag;
            this.requestTag$set = true;
            return this;
        }

        public WhatsappConfigurationBuilder description(@NonNull String description) {
            if (description == null) {
                throw new NullPointerException("description is marked non-null but is null");
            }
            this.description$value = description;
            this.description$set = true;
            return this;
        }

        public WhatsappConfigurationBuilder shortDescription(@NonNull String shortDescription) {
            if (shortDescription == null) {
                throw new NullPointerException("shortDescription is marked non-null but is null");
            }
            this.shortDescription$value = shortDescription;
            this.shortDescription$set = true;
            return this;
        }

        public WhatsappConfigurationBuilder reconnectWhenDisconnected(@NonNull Function<String, Boolean> reconnectWhenDisconnected) {
            if (reconnectWhenDisconnected == null) {
                throw new NullPointerException("reconnectWhenDisconnected is marked non-null but is null");
            }
            this.reconnectWhenDisconnected$value = reconnectWhenDisconnected;
            this.reconnectWhenDisconnected$set = true;
            return this;
        }

        public WhatsappConfigurationBuilder async(boolean async) {
            this.async$value = async;
            this.async$set = true;
            return this;
        }

        public WhatsappConfiguration build() {
            String whatsappUrl$value = this.whatsappUrl$value;
            if (!this.whatsappUrl$set) {
                whatsappUrl$value = WhatsappConfiguration.$default$whatsappUrl();
            }
            String requestTag$value = this.requestTag$value;
            if (!this.requestTag$set) {
                requestTag$value = WhatsappConfiguration.$default$requestTag();
            }
            String description$value = this.description$value;
            if (!this.description$set) {
                description$value = WhatsappConfiguration.$default$description();
            }
            String shortDescription$value = this.shortDescription$value;
            if (!this.shortDescription$set) {
                shortDescription$value = WhatsappConfiguration.$default$shortDescription();
            }
            Function<String, Boolean> reconnectWhenDisconnected$value = this.reconnectWhenDisconnected$value;
            if (!this.reconnectWhenDisconnected$set) {
                reconnectWhenDisconnected$value = WhatsappConfiguration.$default$reconnectWhenDisconnected();
            }
            boolean async$value = this.async$value;
            if (!this.async$set) {
                async$value = WhatsappConfiguration.$default$async();
            }
            return new WhatsappConfiguration(whatsappUrl$value, requestTag$value, description$value, shortDescription$value, reconnectWhenDisconnected$value, async$value);
        }

        public String toString() {
            return "WhatsappConfiguration.WhatsappConfigurationBuilder(whatsappUrl$value=" + this.whatsappUrl$value + ", requestTag$value=" + this.requestTag$value + ", description$value=" + this.description$value + ", shortDescription$value=" + this.shortDescription$value + ", reconnectWhenDisconnected$value=" + this.reconnectWhenDisconnected$value + ", async$value=" + this.async$value + ")";
        }
    }
}

