/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp4j.utils.internal;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import lombok.NonNull;

public class WhatsappQRCode {
    private String ref;
    private static final int SIZE = 50;
    private static final MultiFormatWriter WRITER = new MultiFormatWriter();

    @NonNull
    public BitMatrix generate(String ref, byte @NonNull [] publicKey, @NonNull String clientId) {
        if (publicKey == null) {
            throw new NullPointerException("publicKey is marked non-null but is null");
        }
        if (clientId == null) {
            throw new NullPointerException("clientId is marked non-null but is null");
        }
        try {
            this.ref = Objects.requireNonNullElse(ref, this.ref);
            String qr = "%s,%s,%s".formatted(this.ref, Base64.getEncoder().encodeToString(publicKey), clientId);
            return WRITER.encode(qr, BarcodeFormat.QR_CODE, 50, 50, Map.of(EncodeHintType.MARGIN, 0));
        }
        catch (WriterException ex) {
            throw new RuntimeException("WhatsappAPI: Cannot generate a QR code", ex);
        }
    }
}

