/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp4j.utils.internal;

import it.auties.whatsapp4j.binary.BinaryArray;
import it.auties.whatsapp4j.manager.WhatsappDataManager;
import it.auties.whatsapp4j.media.MediaConnection;
import it.auties.whatsapp4j.media.MediaUpload;
import it.auties.whatsapp4j.protobuf.message.model.MediaMessage;
import it.auties.whatsapp4j.protobuf.message.model.MediaMessageType;
import it.auties.whatsapp4j.response.model.json.JsonResponse;
import it.auties.whatsapp4j.utils.WhatsappUtils;
import it.auties.whatsapp4j.utils.internal.Validate;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.Optional;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import lombok.NonNull;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.params.X25519PublicKeyParameters;
import org.bouncycastle.crypto.util.PublicKeyFactory;

public final class CypherUtils {
    private static final HttpClient CLIENT = HttpClient.newHttpClient();
    private static final String XDH = "XDH";
    private static final String CURVE = "X25519";
    private static final String HMAC_SHA256 = "HmacSHA256";
    private static final String AES = "AES";
    private static final String AES_ALGORITHM = "AES/CBC/PKCS5PADDING";
    private static final String SHA256 = "SHA-256";
    private static final String HKDF = "HKDF-Salt";
    private static final int BLOCK_SIZE = 16;

    @NonNull
    public static KeyPair calculateRandomKeyPair() {
        return KeyPairGenerator.getInstance(CURVE).generateKeyPair();
    }

    @NonNull
    public static BinaryArray calculateSharedSecret(byte @NonNull [] rawPublicKey, @NonNull PrivateKey privateKey) {
        if (rawPublicKey == null) {
            throw new NullPointerException("rawPublicKey is marked non-null but is null");
        }
        if (privateKey == null) {
            throw new NullPointerException("privateKey is marked non-null but is null");
        }
        KeyFactory keyFactory = KeyFactory.getInstance(CURVE);
        SubjectPublicKeyInfo publicKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_X25519), rawPublicKey);
        X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(publicKeyInfo.getEncoded());
        PublicKey publicKey = keyFactory.generatePublic(publicKeySpec);
        KeyAgreement keyAgreement = KeyAgreement.getInstance(XDH);
        keyAgreement.init(privateKey);
        keyAgreement.doPhase(publicKey, true);
        return BinaryArray.forArray(keyAgreement.generateSecret());
    }

    public static byte @NonNull [] extractRawPublicKey(@NonNull PublicKey publicKey) {
        if (publicKey == null) {
            throw new NullPointerException("publicKey is marked non-null but is null");
        }
        X25519PublicKeyParameters x25519PublicKeyParameters = (X25519PublicKeyParameters)PublicKeyFactory.createKey((byte[])publicKey.getEncoded());
        return x25519PublicKeyParameters.getEncoded();
    }

    @NonNull
    public static BinaryArray hmacSha256(@NonNull BinaryArray plain, @NonNull BinaryArray key) {
        if (plain == null) {
            throw new NullPointerException("plain is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        Mac localMac = Mac.getInstance(HMAC_SHA256);
        localMac.init(new SecretKeySpec(key.data(), HMAC_SHA256));
        return BinaryArray.forArray(localMac.doFinal(plain.data()));
    }

    @NonNull
    public static BinaryArray hkdfExpand(@NonNull BinaryArray input, int size) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        return CypherUtils.hkdfExpand(input, null, size);
    }

    @NonNull
    public static BinaryArray hkdfExpand(@NonNull BinaryArray input, byte[] data, int size) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        Mac hmac = Mac.getInstance(HMAC_SHA256);
        int hmacLength = hmac.getMacLength();
        SecretKeySpec salt = new SecretKeySpec(new byte[hmacLength], HKDF);
        hmac.init(salt);
        SecretKeySpec extracted = new SecretKeySpec(hmac.doFinal(input.data()), HMAC_SHA256);
        hmac.init(extracted);
        int rounds = (size + hmacLength - 1) / hmacLength;
        byte[] hkdfOutput = new byte[rounds * hmacLength];
        byte[] parsedData = Optional.ofNullable(data).orElse(new byte[0]);
        int offset = 0;
        int tLength = 0;
        for (int i = 0; i < rounds; ++i) {
            hmac.update(hkdfOutput, Math.max(0, offset - hmacLength), tLength);
            hmac.update(parsedData);
            hmac.update((byte)(i + 1));
            hmac.doFinal(hkdfOutput, offset);
            tLength = hmacLength;
            offset += hmacLength;
        }
        return BinaryArray.forArray(hkdfOutput).cut(size);
    }

    @NonNull
    public static BinaryArray aesDecrypt(@NonNull BinaryArray encrypted, @NonNull BinaryArray secretKey) {
        if (encrypted == null) {
            throw new NullPointerException("encrypted is marked non-null but is null");
        }
        if (secretKey == null) {
            throw new NullPointerException("secretKey is marked non-null but is null");
        }
        return CypherUtils.aesDecrypt(encrypted.cut(16), encrypted, secretKey);
    }

    @NonNull
    public static BinaryArray aesDecrypt(@NonNull BinaryArray iv, @NonNull BinaryArray encrypted, @NonNull BinaryArray secretKey) {
        if (iv == null) {
            throw new NullPointerException("iv is marked non-null but is null");
        }
        if (encrypted == null) {
            throw new NullPointerException("encrypted is marked non-null but is null");
        }
        if (secretKey == null) {
            throw new NullPointerException("secretKey is marked non-null but is null");
        }
        Cipher cipher = Cipher.getInstance(AES_ALGORITHM);
        SecretKeySpec keySpec = new SecretKeySpec(secretKey.data(), AES);
        cipher.init(2, (Key)keySpec, new IvParameterSpec(iv.data()));
        return BinaryArray.forArray(cipher.doFinal(encrypted.slice(16).data()));
    }

    @NonNull
    public static BinaryArray aesEncrypt(byte @NonNull [] decrypted, @NonNull BinaryArray encKey) {
        if (decrypted == null) {
            throw new NullPointerException("decrypted is marked non-null but is null");
        }
        if (encKey == null) {
            throw new NullPointerException("encKey is marked non-null but is null");
        }
        return CypherUtils.aesEncrypt(BinaryArray.random(16), decrypted, encKey, true);
    }

    @NonNull
    public static BinaryArray aesEncrypt(@NonNull BinaryArray iv, byte @NonNull [] decrypted, @NonNull BinaryArray encKey, boolean withIv) {
        if (iv == null) {
            throw new NullPointerException("iv is marked non-null but is null");
        }
        if (decrypted == null) {
            throw new NullPointerException("decrypted is marked non-null but is null");
        }
        if (encKey == null) {
            throw new NullPointerException("encKey is marked non-null but is null");
        }
        Cipher cipher = Cipher.getInstance(AES_ALGORITHM);
        SecretKeySpec keySpec = new SecretKeySpec(encKey.data(), AES);
        cipher.init(1, (Key)keySpec, new IvParameterSpec(iv.data()));
        BinaryArray result = BinaryArray.forArray(cipher.doFinal(decrypted));
        return withIv ? iv.merged(result) : result;
    }

    public static byte @NonNull [] sha256(byte @NonNull [] data) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        MessageDigest digest = MessageDigest.getInstance(SHA256);
        return digest.digest(data);
    }

    public static byte @NonNull [] mediaDecrypt(@NonNull MediaMessage mediaMessage) {
        if (mediaMessage == null) {
            throw new NullPointerException("mediaMessage is marked non-null but is null");
        }
        return WhatsappUtils.readEncryptedMedia(mediaMessage.url()).map(data -> CypherUtils.mediaDecrypt(mediaMessage, data)).orElse(new byte[0]);
    }

    private static byte @NonNull [] mediaDecrypt(@NonNull MediaMessage mediaMessage, @NonNull BinaryArray data) {
        if (mediaMessage == null) {
            throw new NullPointerException("mediaMessage is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        BinaryArray expandedMediaKey = CypherUtils.hkdfExpand(BinaryArray.forArray(mediaMessage.mediaKey()), mediaMessage.type().key(), 112);
        BinaryArray iv = expandedMediaKey.slice(0, 16);
        BinaryArray cypherKey = expandedMediaKey.slice(16, 48);
        BinaryArray macKey = expandedMediaKey.slice(48, 80);
        BinaryArray file = data.cut(-10);
        BinaryArray mac = data.slice(-10);
        BinaryArray hmacValidation = CypherUtils.hmacSha256(iv.merged(file), macKey).cut(10);
        Validate.isTrue(hmacValidation.equals(mac), "Cannot login: Hmac validation failed!", SecurityException.class, new Object[0]);
        return CypherUtils.aesDecrypt(iv, file, cypherKey).data();
    }

    @NonNull
    public static MediaUpload mediaEncrypt(byte @NonNull [] file, @NonNull MediaMessageType type) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        MediaConnection connection = WhatsappDataManager.singletonInstance().mediaConnection();
        BinaryArray mediaKey = BinaryArray.random(32);
        BinaryArray expandedMediaKey = CypherUtils.hkdfExpand(mediaKey, type.key(), 112);
        BinaryArray iv = expandedMediaKey.slice(0, 16);
        BinaryArray cypherKey = expandedMediaKey.slice(16, 48);
        BinaryArray macKey = expandedMediaKey.slice(48, 80);
        BinaryArray enc = CypherUtils.aesEncrypt(iv, file, cypherKey, false);
        BinaryArray mac = CypherUtils.hmacSha256(iv.merged(enc), macKey).cut(10);
        byte[] encFile = enc.merged(mac).data();
        byte[] fileSha256 = CypherUtils.sha256(file);
        byte[] fileEncSha256 = CypherUtils.sha256(encFile);
        byte[] sidecar = CypherUtils.mediaSidecar(file, macKey);
        String token = Base64.getUrlEncoder().withoutPadding().encodeToString(fileEncSha256);
        URI uri = URI.create("%s/%s?auth=%s&token=%s".formatted(type.url(), token, connection.auth(), token));
        HttpRequest request = HttpRequest.newBuilder().uri(uri).POST(HttpRequest.BodyPublishers.ofByteArray(encFile)).build();
        HttpResponse<String> response = CLIENT.send(request, HttpResponse.BodyHandlers.ofString());
        JsonResponse body = JsonResponse.fromJson(response.body());
        String encodedUrl = body.getString("url").orElseThrow(() -> new RuntimeException("WhatsappAPI: Cannot upload media, missing url response %s".formatted(body)));
        String directPath = body.getString("direct_path").orElseThrow(() -> new RuntimeException("WhatsappAPI: Cannot upload media, missing direct path response %s".formatted(body)));
        return new MediaUpload(encodedUrl, directPath, mediaKey, encFile, fileSha256, fileEncSha256, sidecar, type);
    }

    public static byte @NonNull [] mediaSidecar(byte @NonNull [] file, @NonNull BinaryArray macKey) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (macKey == null) {
            throw new NullPointerException("macKey is marked non-null but is null");
        }
        ByteArrayInputStream input = new ByteArrayInputStream(file);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] chunk = new byte[80];
        while (input.read(chunk) != -1) {
            BinaryArray sign = CypherUtils.hmacSha256(BinaryArray.forArray(chunk), macKey);
            output.write(sign.cut(10).data());
        }
        return output.toByteArray();
    }

    private CypherUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

