/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp4j.response.model.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import it.auties.whatsapp4j.response.model.common.Response;
import it.auties.whatsapp4j.response.model.common.ResponseModel;
import java.util.Map;
import java.util.Optional;
import lombok.NonNull;

public final class JsonResponse
extends Response<Map<String, ?>> {
    public JsonResponse(@NonNull String tag, String description, @NonNull Map<String, ?> content) {
        super(tag, description, content);
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
    }

    @NonNull
    public static JsonResponse fromJson(@NonNull String json) {
        if (json == null) {
            throw new NullPointerException("json is marked non-null but is null");
        }
        try {
            int index = json.indexOf("{");
            return new JsonResponse("json", "json", index == -1 ? Map.of() : (Map)JACKSON.readValue(json.substring(index), new TypeReference<Map<String, ?>>(){}));
        }
        catch (JsonProcessingException ex) {
            throw new IllegalArgumentException("WhatsappAPI: Cannot deserialize %s into a JsonResponse".formatted(json), ex);
        }
    }

    @NonNull
    public static JsonResponse fromMap(@NonNull Map<String, ?> json) {
        if (json == null) {
            throw new NullPointerException("json is marked non-null but is null");
        }
        return new JsonResponse("json", "json", json);
    }

    public boolean hasKey(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return ((Map)this.content).containsKey(key);
    }

    @NonNull
    public Optional<String> getString(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.getObject(key, String.class);
    }

    @NonNull
    public Optional<Integer> getInteger(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.getString(key).map(Integer::parseInt);
    }

    @NonNull
    public int getInt(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.getString(key).map(Integer::parseInt).orElse(0);
    }

    @NonNull
    public Optional<Long> getLong(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.getString(key).map(Long::parseLong);
    }

    @NonNull
    public boolean getBoolean(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.getString(key).map(Boolean::parseBoolean).orElse(false);
    }

    @NonNull
    public <T> Optional<T> getObject(@NonNull String key, @NonNull Class<T> clazz) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return Optional.ofNullable(((Map)this.content).get(key)).map(clazz::cast);
    }

    @Override
    @NonNull
    public <T extends ResponseModel> T toModel(@NonNull Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        try {
            return (T)((ResponseModel)JACKSON.convertValue(this.content, clazz));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot convert JsonResponse with content %s to %s".formatted(this.content(), clazz.getName()), e);
        }
    }
}

