/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp4j.request.model;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import it.auties.whatsapp4j.request.model.Request;
import it.auties.whatsapp4j.response.model.json.JsonResponseModel;
import it.auties.whatsapp4j.whatsapp.WhatsappConfiguration;
import jakarta.websocket.EncodeException;
import jakarta.websocket.Session;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import lombok.NonNull;

public abstract class JsonRequest<M extends JsonResponseModel>
extends Request<List<Object>, M> {
    private static final ObjectWriter JACKSON = new ObjectMapper().writerWithDefaultPrettyPrinter();

    protected JsonRequest(@NonNull String tag, @NonNull WhatsappConfiguration configuration) {
        super(tag, configuration);
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
    }

    protected JsonRequest(@NonNull WhatsappConfiguration configuration) {
        super(configuration);
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
    }

    @Override
    @NonNull
    public CompletableFuture<M> send(@NonNull Session session) {
        if (session == null) {
            throw new NullPointerException("session is marked non-null but is null");
        }
        try {
            List body = (List)this.buildBody();
            String json = JACKSON.writeValueAsString((Object)body);
            String request = "%s,%s".formatted(this.tag, json);
            if (this.configuration.async()) {
                session.getAsyncRemote().sendObject((Object)request, __ -> this.addRequest());
                return this.future();
            }
            session.getBasicRemote().sendObject((Object)request);
            this.addRequest();
            return this.future();
        }
        catch (IOException exception) {
            throw new RuntimeException("An exception occurred while sending a JSON message", exception);
        }
        catch (EncodeException exception) {
            throw new RuntimeException("An exception occurred while encoding a JSON message", exception);
        }
    }
}

