/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp4j.protobuf.message.standard;

import com.fasterxml.jackson.annotation.JsonProperty;
import it.auties.whatsapp4j.media.MediaUpload;
import it.auties.whatsapp4j.protobuf.info.ContextInfo;
import it.auties.whatsapp4j.protobuf.message.model.ContextualMessage;
import it.auties.whatsapp4j.protobuf.message.model.MediaMessage;
import it.auties.whatsapp4j.protobuf.message.model.MediaMessageType;
import it.auties.whatsapp4j.utils.internal.CypherUtils;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Optional;
import lombok.NonNull;

public final class AudioMessage
extends MediaMessage {
    @JsonProperty(value="18")
    private byte[] streamingSidecar;
    @JsonProperty(value="10")
    private long mediaKeyTimestamp;
    @JsonProperty(value="9")
    private String directPath;
    @JsonProperty(value="8")
    private byte[] fileEncSha256;
    @JsonProperty(value="7")
    private byte[] mediaKey;
    @JsonProperty(value="6")
    private boolean voiceMessage;
    @JsonProperty(value="5")
    private int seconds;
    @JsonProperty(value="4")
    private long fileLength;
    @JsonProperty(value="3")
    private byte[] fileSha256;
    @JsonProperty(value="2")
    private String mimetype;
    @JsonProperty(value="1")
    private String url;

    private static AudioMessage builder(byte @NonNull [] media, ContextInfo contextInfo, String mimeType, boolean voiceMessage) {
        if (media == null) {
            throw new NullPointerException("media is marked non-null but is null");
        }
        MediaUpload upload = CypherUtils.mediaEncrypt(media, MediaMessageType.AUDIO);
        return ((AudioMessageBuilder)((AudioMessageBuilder)((AudioMessageBuilder)((AudioMessageBuilder)((ContextualMessage.ContextualMessageBuilder)((AudioMessageBuilder)((AudioMessageBuilder)((AudioMessageBuilder)((AudioMessageBuilder)((AudioMessageBuilder)((AudioMessageBuilder)AudioMessage.builder().fileSha256(upload.fileSha256())).fileEncSha256(upload.fileEncSha256())).mediaKey(upload.mediaKey().data())).mediaKeyTimestamp(ZonedDateTime.now().toEpochSecond())).url(upload.url())).directPath(upload.directPath())).fileLength(media.length)).contextInfo(contextInfo)).mimetype(Optional.ofNullable(mimeType).orElse(MediaMessageType.AUDIO.defaultMimeType()))).streamingSidecar(upload.sidecar())).voiceMessage(voiceMessage)).create();
    }

    private static AudioMessageBuilder<?, ?> builder() {
        return new AudioMessageBuilderImpl();
    }

    @Override
    @NonNull
    public MediaMessageType type() {
        return MediaMessageType.AUDIO;
    }

    protected AudioMessage(AudioMessageBuilder<?, ?> b) {
        super((MediaMessage.MediaMessageBuilder<?, ?>)b);
        this.streamingSidecar = b.streamingSidecar;
        this.mediaKeyTimestamp = b.mediaKeyTimestamp;
        this.directPath = b.directPath;
        this.fileEncSha256 = b.fileEncSha256;
        this.mediaKey = b.mediaKey;
        this.voiceMessage = b.voiceMessage;
        this.seconds = b.seconds;
        this.fileLength = b.fileLength;
        this.fileSha256 = b.fileSha256;
        this.mimetype = b.mimetype;
        this.url = b.url;
    }

    public static NewAudioMessageBuilder newAudioMessage() {
        return new NewAudioMessageBuilder();
    }

    public AudioMessage(byte[] streamingSidecar, long mediaKeyTimestamp, String directPath, byte[] fileEncSha256, byte[] mediaKey, boolean voiceMessage, int seconds, long fileLength, byte[] fileSha256, String mimetype, String url) {
        this.streamingSidecar = streamingSidecar;
        this.mediaKeyTimestamp = mediaKeyTimestamp;
        this.directPath = directPath;
        this.fileEncSha256 = fileEncSha256;
        this.mediaKey = mediaKey;
        this.voiceMessage = voiceMessage;
        this.seconds = seconds;
        this.fileLength = fileLength;
        this.fileSha256 = fileSha256;
        this.mimetype = mimetype;
        this.url = url;
    }

    public AudioMessage() {
    }

    public byte[] streamingSidecar() {
        return this.streamingSidecar;
    }

    @Override
    public long mediaKeyTimestamp() {
        return this.mediaKeyTimestamp;
    }

    @Override
    public String directPath() {
        return this.directPath;
    }

    @Override
    public byte[] fileEncSha256() {
        return this.fileEncSha256;
    }

    @Override
    public byte[] mediaKey() {
        return this.mediaKey;
    }

    public boolean voiceMessage() {
        return this.voiceMessage;
    }

    public int seconds() {
        return this.seconds;
    }

    @Override
    public long fileLength() {
        return this.fileLength;
    }

    @Override
    public byte[] fileSha256() {
        return this.fileSha256;
    }

    public String mimetype() {
        return this.mimetype;
    }

    @Override
    public String url() {
        return this.url;
    }

    @JsonProperty(value="18")
    public AudioMessage streamingSidecar(byte[] streamingSidecar) {
        this.streamingSidecar = streamingSidecar;
        return this;
    }

    @JsonProperty(value="10")
    public AudioMessage mediaKeyTimestamp(long mediaKeyTimestamp) {
        this.mediaKeyTimestamp = mediaKeyTimestamp;
        return this;
    }

    @JsonProperty(value="9")
    public AudioMessage directPath(String directPath) {
        this.directPath = directPath;
        return this;
    }

    @JsonProperty(value="8")
    public AudioMessage fileEncSha256(byte[] fileEncSha256) {
        this.fileEncSha256 = fileEncSha256;
        return this;
    }

    @JsonProperty(value="7")
    public AudioMessage mediaKey(byte[] mediaKey) {
        this.mediaKey = mediaKey;
        return this;
    }

    @JsonProperty(value="6")
    public AudioMessage voiceMessage(boolean voiceMessage) {
        this.voiceMessage = voiceMessage;
        return this;
    }

    @JsonProperty(value="5")
    public AudioMessage seconds(int seconds) {
        this.seconds = seconds;
        return this;
    }

    @JsonProperty(value="4")
    public AudioMessage fileLength(long fileLength) {
        this.fileLength = fileLength;
        return this;
    }

    @JsonProperty(value="3")
    public AudioMessage fileSha256(byte[] fileSha256) {
        this.fileSha256 = fileSha256;
        return this;
    }

    @JsonProperty(value="2")
    public AudioMessage mimetype(String mimetype) {
        this.mimetype = mimetype;
        return this;
    }

    @JsonProperty(value="1")
    public AudioMessage url(String url) {
        this.url = url;
        return this;
    }

    @Override
    public String toString() {
        return "AudioMessage(streamingSidecar=" + Arrays.toString(this.streamingSidecar()) + ", mediaKeyTimestamp=" + this.mediaKeyTimestamp() + ", directPath=" + this.directPath() + ", fileEncSha256=" + Arrays.toString(this.fileEncSha256()) + ", mediaKey=" + Arrays.toString(this.mediaKey()) + ", voiceMessage=" + this.voiceMessage() + ", seconds=" + this.seconds() + ", fileLength=" + this.fileLength() + ", fileSha256=" + Arrays.toString(this.fileSha256()) + ", mimetype=" + this.mimetype() + ", url=" + this.url() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AudioMessage)) {
            return false;
        }
        AudioMessage other = (AudioMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.mediaKeyTimestamp() != other.mediaKeyTimestamp()) {
            return false;
        }
        if (this.voiceMessage() != other.voiceMessage()) {
            return false;
        }
        if (this.seconds() != other.seconds()) {
            return false;
        }
        if (this.fileLength() != other.fileLength()) {
            return false;
        }
        if (!Arrays.equals(this.streamingSidecar(), other.streamingSidecar())) {
            return false;
        }
        String this$directPath = this.directPath();
        String other$directPath = other.directPath();
        if (this$directPath == null ? other$directPath != null : !this$directPath.equals(other$directPath)) {
            return false;
        }
        if (!Arrays.equals(this.fileEncSha256(), other.fileEncSha256())) {
            return false;
        }
        if (!Arrays.equals(this.mediaKey(), other.mediaKey())) {
            return false;
        }
        if (!Arrays.equals(this.fileSha256(), other.fileSha256())) {
            return false;
        }
        String this$mimetype = this.mimetype();
        String other$mimetype = other.mimetype();
        if (this$mimetype == null ? other$mimetype != null : !this$mimetype.equals(other$mimetype)) {
            return false;
        }
        String this$url = this.url();
        String other$url = other.url();
        return !(this$url == null ? other$url != null : !this$url.equals(other$url));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AudioMessage;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $mediaKeyTimestamp = this.mediaKeyTimestamp();
        result = result * 59 + (int)($mediaKeyTimestamp >>> 32 ^ $mediaKeyTimestamp);
        result = result * 59 + (this.voiceMessage() ? 79 : 97);
        result = result * 59 + this.seconds();
        long $fileLength = this.fileLength();
        result = result * 59 + (int)($fileLength >>> 32 ^ $fileLength);
        result = result * 59 + Arrays.hashCode(this.streamingSidecar());
        String $directPath = this.directPath();
        result = result * 59 + ($directPath == null ? 43 : $directPath.hashCode());
        result = result * 59 + Arrays.hashCode(this.fileEncSha256());
        result = result * 59 + Arrays.hashCode(this.mediaKey());
        result = result * 59 + Arrays.hashCode(this.fileSha256());
        String $mimetype = this.mimetype();
        result = result * 59 + ($mimetype == null ? 43 : $mimetype.hashCode());
        String $url = this.url();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        return result;
    }

    public static abstract class AudioMessageBuilder<C extends AudioMessage, B extends AudioMessageBuilder<C, B>>
    extends MediaMessage.MediaMessageBuilder<C, B> {
        private byte[] streamingSidecar;
        private long mediaKeyTimestamp;
        private String directPath;
        private byte[] fileEncSha256;
        private byte[] mediaKey;
        private boolean voiceMessage;
        private int seconds;
        private long fileLength;
        private byte[] fileSha256;
        private String mimetype;
        private String url;

        @Override
        protected abstract B self();

        @Override
        public abstract C create();

        @JsonProperty(value="18")
        public B streamingSidecar(byte[] streamingSidecar) {
            this.streamingSidecar = streamingSidecar;
            return (B)this.self();
        }

        @JsonProperty(value="10")
        public B mediaKeyTimestamp(long mediaKeyTimestamp) {
            this.mediaKeyTimestamp = mediaKeyTimestamp;
            return (B)this.self();
        }

        @JsonProperty(value="9")
        public B directPath(String directPath) {
            this.directPath = directPath;
            return (B)this.self();
        }

        @JsonProperty(value="8")
        public B fileEncSha256(byte[] fileEncSha256) {
            this.fileEncSha256 = fileEncSha256;
            return (B)this.self();
        }

        @JsonProperty(value="7")
        public B mediaKey(byte[] mediaKey) {
            this.mediaKey = mediaKey;
            return (B)this.self();
        }

        @JsonProperty(value="6")
        public B voiceMessage(boolean voiceMessage) {
            this.voiceMessage = voiceMessage;
            return (B)this.self();
        }

        @JsonProperty(value="5")
        public B seconds(int seconds) {
            this.seconds = seconds;
            return (B)this.self();
        }

        @JsonProperty(value="4")
        public B fileLength(long fileLength) {
            this.fileLength = fileLength;
            return (B)this.self();
        }

        @JsonProperty(value="3")
        public B fileSha256(byte[] fileSha256) {
            this.fileSha256 = fileSha256;
            return (B)this.self();
        }

        @JsonProperty(value="2")
        public B mimetype(String mimetype) {
            this.mimetype = mimetype;
            return (B)this.self();
        }

        @JsonProperty(value="1")
        public B url(String url) {
            this.url = url;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "AudioMessage.AudioMessageBuilder(super=" + super.toString() + ", streamingSidecar=" + Arrays.toString(this.streamingSidecar) + ", mediaKeyTimestamp=" + this.mediaKeyTimestamp + ", directPath=" + this.directPath + ", fileEncSha256=" + Arrays.toString(this.fileEncSha256) + ", mediaKey=" + Arrays.toString(this.mediaKey) + ", voiceMessage=" + this.voiceMessage + ", seconds=" + this.seconds + ", fileLength=" + this.fileLength + ", fileSha256=" + Arrays.toString(this.fileSha256) + ", mimetype=" + this.mimetype + ", url=" + this.url + ")";
        }
    }

    private static final class AudioMessageBuilderImpl
    extends AudioMessageBuilder<AudioMessage, AudioMessageBuilderImpl> {
        private AudioMessageBuilderImpl() {
        }

        @Override
        protected AudioMessageBuilderImpl self() {
            return this;
        }

        @Override
        public AudioMessage create() {
            return new AudioMessage(this);
        }
    }

    public static class NewAudioMessageBuilder {
        private byte @NonNull [] media;
        private ContextInfo contextInfo;
        private String mimeType;
        private boolean voiceMessage;

        NewAudioMessageBuilder() {
        }

        public NewAudioMessageBuilder media(byte @NonNull [] media) {
            if (media == null) {
                throw new NullPointerException("media is marked non-null but is null");
            }
            this.media = media;
            return this;
        }

        public NewAudioMessageBuilder contextInfo(ContextInfo contextInfo) {
            this.contextInfo = contextInfo;
            return this;
        }

        public NewAudioMessageBuilder mimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public NewAudioMessageBuilder voiceMessage(boolean voiceMessage) {
            this.voiceMessage = voiceMessage;
            return this;
        }

        public AudioMessage create() {
            return AudioMessage.builder(this.media, this.contextInfo, this.mimeType, this.voiceMessage);
        }

        public String toString() {
            return "AudioMessage.NewAudioMessageBuilder(media=" + this.media + ", contextInfo=" + this.contextInfo + ", mimeType=" + this.mimeType + ", voiceMessage=" + this.voiceMessage + ")";
        }
    }
}

