/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp4j.binary;

import it.auties.whatsapp4j.utils.internal.Pair;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import java.util.Optional;
import java.util.stream.IntStream;
import lombok.NonNull;
import org.bouncycastle.util.encoders.Hex;

public record BinaryArray(byte[] data) {
    @NonNull
    public static BinaryArray empty() {
        return BinaryArray.forArray(new byte[0]);
    }

    @NonNull
    public static BinaryArray forArray(byte[] in) {
        return new BinaryArray(in);
    }

    @NonNull
    public static BinaryArray singleton(byte in) {
        return new BinaryArray(new byte[]{in});
    }

    @NonNull
    public static BinaryArray forString(@NonNull String in) {
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        return BinaryArray.forArray(in.getBytes());
    }

    @NonNull
    public static BinaryArray forBase64(@NonNull String input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        return BinaryArray.forArray(Base64.getDecoder().decode(input));
    }

    @NonNull
    public static BinaryArray random(int length) {
        byte[] result = new byte[length];
        new SecureRandom().nextBytes(result);
        return BinaryArray.forArray(result);
    }

    @NonNull
    public BinaryArray cut(int end) {
        return this.slice(0, end);
    }

    @NonNull
    public BinaryArray slice(int start) {
        return this.slice(start, this.data.length);
    }

    @NonNull
    public Pair<BinaryArray, BinaryArray> split(int split) {
        return new Pair<BinaryArray, BinaryArray>(this.cut(split), this.slice(split + 1));
    }

    @NonNull
    public BinaryArray slice(int start, int end) {
        return BinaryArray.forArray(Arrays.copyOfRange(this.data, start >= 0 ? start : this.size() + start, end >= 0 ? end : this.size() + end));
    }

    @NonNull
    public BinaryArray merged(@NonNull BinaryArray array) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        byte[] result = Arrays.copyOf(this.data, this.size() + array.size());
        System.arraycopy(array.data, 0, result, this.size(), array.size());
        return BinaryArray.forArray(result);
    }

    @NonNull
    public Optional<Integer> indexOf(char character) {
        return IntStream.range(0, this.size()).filter(index -> this.data[index] == character).boxed().findFirst();
    }

    public byte at(int index) {
        return this.data[index];
    }

    public int size() {
        return this.data.length;
    }

    @NonNull
    public ByteBuffer toBuffer() {
        return ByteBuffer.wrap(this.data);
    }

    @NonNull
    public String toHex() {
        return Hex.toHexString((byte[])this.data);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (!(o instanceof BinaryArray)) return false;
        BinaryArray that = (BinaryArray)o;
        if (!Arrays.equals(this.data, that.data)) return false;
        return true;
    }

    @Override
    @NonNull
    public String toString() {
        return new String(this.data(), StandardCharsets.UTF_8);
    }
}

