package it.auties.whatsapp4j.protobuf.message.model;

import it.auties.whatsapp4j.protobuf.message.device.DeviceSentMessage;
import it.auties.whatsapp4j.protobuf.message.device.DeviceSyncMessage;

/**
 * A model interface that represents a WhatsappMessage sent by the device linked to this whatsapp web session.
 *
 * This interface is sealed to prepare for <a href="https://openjdk.java.net/jeps/406">pattern matching for instanceof in switch statements</a>, set to be released in Java 17.
 */
public sealed interface DeviceMessage extends Message permits DeviceSyncMessage, DeviceSentMessage {
}
