/*
 * Decompiled with CFR 0.152.
 */
package com.github.artfable.gradle;

import com.github.artfable.gradle.GradleLibsassPlugin;
import com.github.artfable.gradle.GradleLibsassPluginExtension;
import com.github.artfable.gradle.GradleLibsassPluginGroup;
import com.github.artfable.gradle.NonDuplicateImporter;
import io.bit3.jsass.CompilationException;
import io.bit3.jsass.Compiler;
import io.bit3.jsass.Options;
import io.bit3.jsass.Output;
import io.bit3.jsass.OutputStyle;
import java.io.File;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.StopExecutionException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016J8\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J(\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001c"}, d2={"Lcom/github/artfable/gradle/GradleLibsassPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "CHARSET", "", "getCHARSET", "()Ljava/lang/String;", "apply", "", "project", "compileFile", "file", "Ljava/io/File;", "outputFile", "options", "Lio/bit3/jsass/Options;", "compiler", "Lio/bit3/jsass/Compiler;", "ignoreFailures", "", "logger", "Lorg/gradle/api/logging/Logger;", "compileGroup", "sourceDir", "outputDir", "config", "Lcom/github/artfable/gradle/GradleLibsassPluginExtension;", "gradle-sass-plugin-compileKotlin"})
public final class GradleLibsassPlugin
implements Plugin<Project> {
    @NotNull
    private final String CHARSET = "UTF-8";

    @NotNull
    public final String getCHARSET() {
        return this.CHARSET;
    }

    public void apply(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        GradleLibsassPluginExtension config = (GradleLibsassPluginExtension)project.getExtensions().create("sass", GradleLibsassPluginExtension.class, new Object[0]);
        Task task = project.task("compileSass");
        task.doFirst((Action)new Action<Task>(this, config, project){
            final /* synthetic */ GradleLibsassPlugin this$0;
            final /* synthetic */ GradleLibsassPluginExtension $config;
            final /* synthetic */ Project $project;

            public final void execute(Task task) {
                for (GradleLibsassPluginGroup group : this.$config.getGroups()) {
                    File sourceDir = new File(group.getSourceDir());
                    File outputDir = new File(group.getOutputDir());
                    if (!sourceDir.isDirectory()) {
                        throw (Throwable)new StopExecutionException("SourceDir should be a directory");
                    }
                    if (outputDir.isFile()) {
                        throw (Throwable)new StopExecutionException("OutputDir shouldn't be a file!");
                    }
                    if (!outputDir.isDirectory() && !outputDir.mkdirs()) {
                        throw (Throwable)new StopExecutionException("Couldn't create outputDir");
                    }
                    GradleLibsassPluginExtension gradleLibsassPluginExtension = this.$config;
                    Intrinsics.checkExpressionValueIsNotNull((Object)gradleLibsassPluginExtension, (String)"config");
                    Logger logger = this.$project.getLogger();
                    Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"project.logger");
                    GradleLibsassPlugin.access$compileGroup(this.this$0, sourceDir, outputDir, gradleLibsassPluginExtension, logger);
                }
            }
            {
                this.this$0 = gradleLibsassPlugin;
                this.$config = gradleLibsassPluginExtension;
                this.$project = project;
            }
        });
        task.dependsOn(new Object[]{"processResources"});
    }

    private final void compileGroup(File sourceDir, File outputDir, GradleLibsassPluginExtension config, Logger logger) {
        Compiler compiler = new Compiler();
        File[] fileArray = sourceDir.listFiles(compileGroup.1.INSTANCE);
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            Options options = new Options();
            options.getIncludePaths().add(sourceDir);
            options.setOutputStyle(OutputStyle.COMPACT);
            if (config.getOptimisation()) {
                options.getImporters().add(new NonDuplicateImporter(logger));
            }
            File outFile = new File(outputDir.getAbsolutePath() + File.separator + StringsKt.replace$default((String)file.getName(), (String)".scss", (String)".css", (boolean)false, (int)4, null));
            outFile.delete();
            if (!outFile.createNewFile()) {
                if (config.getIgnoreFailures()) {
                    logger.error("Skip " + file.getName() + " because couldn't create output file");
                    continue;
                }
                throw (Throwable)new StopExecutionException("Couldn't create output file (" + file.getName() + ")");
            }
            File file2 = file;
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
            this.compileFile(file2, outFile, options, compiler, config.getIgnoreFailures(), logger);
        }
    }

    private final void compileFile(File file, File outputFile, Options options, Compiler compiler, boolean ignoreFailures, Logger logger) {
        try {
            Output output = compiler.compileFile(file.toURI(), outputFile.toURI(), options);
            Intrinsics.checkExpressionValueIsNotNull((Object)output, (String)"compiler.compileFile(fil\u2026putFile.toURI(), options)");
            Output output2 = output;
            String string = output2.getCss();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"output.css");
            Charset charset = Charset.forName(this.CHARSET);
            Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charset.forName(CHARSET)");
            FilesKt.writeText((File)outputFile, (String)string, (Charset)charset);
            logger.debug(outputFile.getName() + " compiled");
        }
        catch (CompilationException e) {
            if (ignoreFailures) {
                logger.error("Couldn't compile file '" + file.getName() + "'", (Throwable)e);
            }
            throw (Throwable)new GradleException("Couldn't compile file '" + file.getName() + "'", (Throwable)e);
        }
    }

    public static final /* synthetic */ void access$compileGroup(GradleLibsassPlugin $this, @NotNull File sourceDir, @NotNull File outputDir, @NotNull GradleLibsassPluginExtension config, @NotNull Logger logger) {
        $this.compileGroup(sourceDir, outputDir, config, logger);
    }
}

