/*
 * Decompiled with CFR 0.152.
 */
package com.artemkopan.widget.fonts;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.widget.TextView;
import com.artemkopan.widget.R;
import com.artemkopan.widget.fonts.FontCache;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class FontUtils {
    public static final String ANDROID_SCHEMA = "http://schemas.android.com/apk/res/android";
    public static final int LIGHT = 10;
    public static final int EXTRA_LIGHT = 11;
    public static final int EXTRA_BOLD = 12;
    public static final int MEDIUM = 13;
    private static final String TAG = "FontUtils";
    private static final SparseArray<String> FONTS = new SparseArray();

    public static void addFont(int style, String fontPath) {
        FONTS.append(style, (Object)fontPath);
    }

    public static void applyCustomFont(TextView textView, Context context, AttributeSet attrs) {
        TypedArray attributeArray = context.obtainStyledAttributes(attrs, R.styleable.FontTextView);
        String fontPath = attributeArray.getString(R.styleable.FontTextView_font);
        int textStyle = attributeArray.getInt(R.styleable.FontTextView_textStyle, 0);
        if (textStyle == 0) {
            textStyle = attrs.getAttributeIntValue(ANDROID_SCHEMA, "textStyle", 0);
        }
        if (TextUtils.isEmpty((CharSequence)fontPath)) {
            Typeface customFont = FontUtils.selectTypeface(context, textStyle);
            textView.setTypeface(customFont);
        } else {
            textView.setTypeface(FontCache.getTypeface(fontPath, context));
        }
        attributeArray.recycle();
    }

    public static Typeface selectTypeface(Context context, int textStyle) {
        if (FONTS.size() == 0) {
            throw new ArrayIndexOutOfBoundsException("For use custom fonts, firstly you must call addFont()");
        }
        String fontNewPath = (String)FONTS.get(textStyle);
        if (TextUtils.isEmpty((CharSequence)fontNewPath)) {
            Log.w((String)TAG, (String)"Current style not found. Pleas add it");
            fontNewPath = (String)FONTS.get(0);
            if (TextUtils.isEmpty((CharSequence)fontNewPath)) {
                fontNewPath = (String)FONTS.get(FONTS.keyAt(0));
            }
        }
        return FontCache.getTypeface(fontNewPath, context);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TextStyle {
    }
}

