/*
 * Decompiled with CFR 0.152.
 */
package com.artemkopan.widget.common;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.v4.view.animation.LinearOutSlowInInterpolator;
import android.support.v7.appcompat.R;
import android.support.v7.widget.AppCompatButton;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.TextView;
import com.artemkopan.widget.R;
import com.artemkopan.widget.drawable.CircularProgressDrawable;
import com.artemkopan.widget.vector.VectorCompatViewHelper;

public class ProgressButtonView
extends AppCompatButton {
    private static final String TAG = "ProgressButtonView";
    private CircularProgressDrawable progressDrawable;
    private ValueAnimator backgroundAnimator;
    private int animDuration;
    private int progressSize;
    private int progressPadding;
    private boolean showProgress;
    private boolean drawProgress;

    public ProgressButtonView(Context context) {
        this(context, null);
    }

    public ProgressButtonView(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.buttonStyle);
    }

    public ProgressButtonView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(AttributeSet attrs) {
        int color = -16777216;
        int borderWidth = this.getResources().getDimensionPixelSize(R.dimen.base_progress_border_width);
        VectorCompatViewHelper.loadFromAttributes((TextView)this, attrs);
        this.animDuration = this.getContext().getResources().getInteger(0x10E0000);
        if (attrs != null) {
            TypedArray array = this.getContext().obtainStyledAttributes(attrs, R.styleable.ProgressButtonView);
            try {
                color = array.getColor(R.styleable.ProgressButtonView_pbv_progressColor, color);
                borderWidth = array.getDimensionPixelSize(R.styleable.ProgressButtonView_pbv_progressBorderWidth, this.getResources().getDimensionPixelSize(R.dimen.base_progress_border_width));
                this.progressSize = array.getDimensionPixelSize(R.styleable.ProgressButtonView_pbv_progressSize, this.progressSize);
                this.progressPadding = array.getDimensionPixelSize(R.styleable.ProgressButtonView_pbv_progressPadding, this.progressPadding);
            }
            finally {
                array.recycle();
            }
        }
        this.progressDrawable = new CircularProgressDrawable(color, borderWidth);
        this.progressDrawable.setCallback((Drawable.Callback)this);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        if (changed) {
            int w = this.getWidth();
            int h = this.getHeight();
            if (this.progressSize == 0) {
                this.progressSize = w > h ? h : w;
            }
            int sizeHalfProgress = (this.progressSize - this.progressPadding) / 2;
            this.progressDrawable.setBounds(w / 2 - sizeHalfProgress, h / 2 - sizeHalfProgress, w / 2 + sizeHalfProgress, h / 2 + sizeHalfProgress);
        }
    }

    public void showProgress(boolean show) {
        this.showProgress(show, true);
    }

    public void showProgress(boolean show, boolean animate) {
        Log.d((String)TAG, (String)("showProgress: is show " + show));
        if (show == this.showProgress) {
            return;
        }
        this.showProgress = show;
        this.setEnabled(!show);
        if (animate && this.getBackground() != null) {
            this.showProgressAnim();
            return;
        }
        this.showProgressWithoutAnim();
    }

    public boolean isShowProgress() {
        return this.showProgress;
    }

    private void showProgressAnim() {
        if (this.backgroundAnimator == null) {
            this.backgroundAnimator = ObjectAnimator.ofInt((int[])new int[]{255, 0});
            this.backgroundAnimator.setDuration((long)this.animDuration);
            this.backgroundAnimator.setInterpolator((TimeInterpolator)new LinearOutSlowInInterpolator());
            this.backgroundAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    int value = (Integer)animation.getAnimatedValue();
                    ProgressButtonView.this.getBackground().setAlpha(value);
                    if (ProgressButtonView.this.showProgress && value == 0 || !ProgressButtonView.this.showProgress && value == 255) {
                        ProgressButtonView.this.showProgressWithoutAnim();
                    }
                }
            });
            this.backgroundAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationCancel(Animator animation) {
                    ProgressButtonView.this.showProgressWithoutAnim();
                }
            });
        }
        if (this.showProgress) {
            this.backgroundAnimator.start();
        } else {
            this.backgroundAnimator.reverse();
        }
    }

    private void showProgressWithoutAnim() {
        if (this.showProgress) {
            this.drawProgress = true;
            this.progressDrawable.start();
        } else {
            this.drawProgress = false;
            this.progressDrawable.stop();
        }
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        if (this.showProgress && this.drawProgress) {
            this.progressDrawable.draw(canvas);
        } else {
            super.onDraw(canvas);
        }
    }

    protected boolean verifyDrawable(@NonNull Drawable who) {
        return who == this.progressDrawable || super.verifyDrawable(who);
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.showProgress = this.showProgress;
        ss.drawProgress = this.drawProgress;
        return ss;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof SavedState) {
            SavedState ss = (SavedState)state;
            super.onRestoreInstanceState(ss.getSuperState());
            this.drawProgress = ss.drawProgress;
            this.showProgress(ss.showProgress);
        } else {
            super.onRestoreInstanceState(state);
        }
    }

    static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };
        boolean showProgress;
        boolean drawProgress;

        SavedState(Parcel source) {
            super(source);
            this.showProgress = source.readByte() != 0;
            this.drawProgress = source.readByte() != 0;
        }

        private SavedState(Parcelable superState) {
            super(superState);
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeByte(this.showProgress ? (byte)1 : 0);
            dest.writeByte(this.drawProgress ? (byte)1 : 0);
        }
    }
}

