/*
 * Decompiled with CFR 0.152.
 */
package com.artemkopan.widget.places;

import android.content.Context;
import android.content.res.TypedArray;
import android.location.Address;
import android.support.annotation.LayoutRes;
import android.support.v7.widget.AppCompatAutoCompleteTextView;
import android.util.AttributeSet;
import android.widget.ArrayAdapter;
import android.widget.TextView;
import com.artemkopan.widget.R;
import com.artemkopan.widget.places.PlacesAutoCompleteDelegate;
import com.artemkopan.widget.vector.VectorCompatViewHelper;

public class PlacesAutoCompleteView
extends AppCompatAutoCompleteTextView {
    private PlacesAutoCompleteDelegate delegate;

    public PlacesAutoCompleteView(Context context) {
        super(context);
        this.init(null);
    }

    public PlacesAutoCompleteView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public PlacesAutoCompleteView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(AttributeSet attrs) {
        this.delegate = new PlacesAutoCompleteDelegate(this.getContext());
        boolean initAdapter = true;
        if (attrs != null) {
            TypedArray ta = this.getContext().obtainStyledAttributes(attrs, R.styleable.PlacesAutoCompleteView);
            try {
                this.delegate.setDebounce(ta.getInteger(R.styleable.PlacesAutoCompleteView_pac_debounce, 800));
                this.delegate.setMinStartSearch(ta.getInteger(R.styleable.PlacesAutoCompleteView_pac_min_start_search, 2));
                this.delegate.setMaxResult(ta.getInteger(R.styleable.PlacesAutoCompleteView_pac_max_result, 10));
                this.delegate.setLayoutRes(ta.getResourceId(R.styleable.PlacesAutoCompleteView_pac_item_layout, 17367050));
                initAdapter = ta.getBoolean(R.styleable.PlacesAutoCompleteView_pac_init_adapter, true);
            }
            finally {
                ta.recycle();
            }
        }
        VectorCompatViewHelper.loadFromAttributes((TextView)this, attrs);
        if (initAdapter) {
            super.setAdapter(this.delegate.initAdapter(this.getContext()));
        }
    }

    public void setDebounce(int debounce) {
        this.delegate.setDebounce(debounce);
    }

    public void setMinStartSearch(int minStartSearch) {
        this.delegate.setMinStartSearch(minStartSearch);
    }

    public void setMaxResult(int maxResult) {
        this.delegate.setMaxResult(maxResult);
    }

    public void setText(CharSequence text, boolean blocked) {
        if (blocked) {
            this.replaceText(text);
        } else {
            this.setText(text);
        }
    }

    public void setLoadingListener(OnLocationListener loadingListener) {
        this.delegate.setLoadingListener(loadingListener);
    }

    public void setLayoutRes(@LayoutRes int layoutRes) {
        this.delegate.setLayoutRes(layoutRes);
    }

    protected void replaceText(CharSequence text) {
        this.delegate.setBlocked(true);
        super.replaceText(text);
        this.delegate.setOldText(text.toString());
        this.delegate.setBlocked(false);
    }

    protected void onTextChanged(CharSequence text, int start, int lengthBefore, int lengthAfter) {
        super.onTextChanged(text, start, lengthBefore, lengthAfter);
        if (this.delegate != null) {
            this.delegate.onTextChanged(text);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.delegate.onAttachedToWindow();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.delegate.onDetachedFromWindow();
    }

    public void setAdapter(ArrayAdapter<Address> adapter) {
        super.setAdapter(adapter);
        this.delegate.setAdapter(adapter);
    }

    public static interface OnLocationListener {
        public void startLoad();

        public void stopLoad();

        public void error(Throwable var1);
    }
}

