/*
 * Decompiled with CFR 0.152.
 */
package com.artemkopan.widget.common;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Rect;
import android.os.Build;
import android.os.Vibrator;
import android.support.annotation.Nullable;
import android.support.design.widget.TextInputEditText;
import android.support.design.widget.TextInputLayout;
import android.text.Editable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.inputmethod.InputMethodManager;
import com.artemkopan.widget.R;

public class ErrorEditText
extends TextInputEditText {
    private Animation mErrorAnimator;
    private boolean mError;
    private boolean mOptional;

    public ErrorEditText(Context context) {
        super(context);
        this.init();
    }

    public ErrorEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public ErrorEditText(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        this.mErrorAnimator = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.error_animation);
        this.mError = false;
    }

    public void onTextChanged(CharSequence text, int start, int lengthBefore, int lengthAfter) {
        super.onTextChanged(text, start, lengthBefore, lengthAfter);
        this.setError(null);
    }

    protected void onFocusChanged(boolean focused, int direction, Rect previouslyFocusedRect) {
        super.onFocusChanged(focused, direction, previouslyFocusedRect);
        if (!(focused || this.isValid() || TextUtils.isEmpty((CharSequence)this.getText()))) {
            this.setError(this.getErrorMessage());
        }
    }

    public String getString() {
        return this.getString(true);
    }

    public String getString(boolean trim) {
        Editable editable = this.getText();
        return editable != null ? (trim ? editable.toString().trim() : editable.toString()) : "";
    }

    public void setFieldHint(int hint) {
        this.setFieldHint(this.getContext().getString(hint));
    }

    public void setFieldHint(String hint) {
        if (this.getTextInputLayoutParent() != null) {
            this.getTextInputLayoutParent().setHint((CharSequence)hint);
        } else {
            this.setHint(hint);
        }
    }

    public View focusNextView() {
        View next;
        if (this.getImeActionId() == 2) {
            return null;
        }
        try {
            next = this.focusSearch(2);
        }
        catch (IllegalArgumentException e) {
            next = this.focusSearch(130);
        }
        if (next != null && next.requestFocus()) {
            return next;
        }
        return null;
    }

    public boolean isOptional() {
        return this.mOptional;
    }

    public void setOptional(boolean optional) {
        this.mOptional = optional;
    }

    public boolean isError() {
        return this.mError;
    }

    public void setError(@Nullable CharSequence errorMessage) {
        this.setError(errorMessage, true);
    }

    public void setError(@Nullable CharSequence errorMessage, boolean animate) {
        this.mError = !TextUtils.isEmpty((CharSequence)errorMessage);
        TextInputLayout textInputLayout = this.getTextInputLayoutParent();
        if (textInputLayout != null) {
            textInputLayout.setErrorEnabled(!TextUtils.isEmpty((CharSequence)errorMessage));
            textInputLayout.setError(errorMessage);
        } else {
            super.setError(errorMessage);
        }
        if (this.mError && animate) {
            this.showErrorAction();
        }
    }

    public void showErrorAction() {
        if (this.mErrorAnimator != null) {
            this.startAnimation(this.mErrorAnimator);
            this.vibrate();
        }
    }

    public boolean isValid() {
        return true;
    }

    public String getErrorMessage() {
        return null;
    }

    public void validate() {
        if (this.isValid() || this.isOptional()) {
            this.setError(null);
        } else {
            this.setError(this.getErrorMessage());
        }
    }

    public void closeSoftKeyboard() {
        ((InputMethodManager)this.getContext().getSystemService("input_method")).hideSoftInputFromWindow(this.getWindowToken(), 0);
    }

    @Nullable
    public TextInputLayout getTextInputLayoutParent() {
        if (this.getParent() != null && this.getParent().getParent() instanceof TextInputLayout) {
            return (TextInputLayout)this.getParent().getParent();
        }
        return null;
    }

    @TargetApi(value=17)
    protected boolean isRightToLeftLanguage() {
        return Build.VERSION.SDK_INT >= 17 && this.getResources().getConfiguration().getLayoutDirection() == 1;
    }

    public boolean onKeyPreIme(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            this.clearFocus();
        }
        return super.onKeyPreIme(keyCode, event);
    }

    protected void vibrate() {
        ((Vibrator)this.getContext().getSystemService("vibrator")).vibrate(150L);
    }
}

