/*
 * Decompiled with CFR 0.152.
 */
package com.artemkopan.recycler.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.v7.widget.RecyclerView;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import com.artemkopan.recycler.R;
import com.artemkopan.recycler.listeners.OnRecyclerPaginationListener;
import com.artemkopan.utils.ViewUtils;
import com.artemkopan.widget.drawable.CircularProgressDrawable;
import io.reactivex.Observable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.util.concurrent.TimeUnit;

public class ExRecyclerView
extends RecyclerView {
    private static final int NO_VALUE = -1;
    private static final int BACKGROUND_DURATION = 2000;
    private static final String TAG = "ExRecyclerView";
    private StaticLayout staticLayout;
    private TextPaint textPaint;
    private CircularProgressDrawable progressDrawable;
    private Drawable backgroundDrawable;
    private OnRecyclerPaginationListener paginationListener;
    private Disposable errorTimer;
    private String textDefault;
    private int progressSize = -1;
    private int textPadding = -1;
    private int backgroundDuration = 2000;
    private boolean drawText;
    private boolean drawProgress;

    public ExRecyclerView(Context context) {
        this(context, null, 0);
    }

    public ExRecyclerView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExRecyclerView(Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        int borderWidth = -1;
        int progressColor = -1;
        int textSize = -1;
        int textColor = -16777216;
        if (attrs != null) {
            TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.ExRecyclerView);
            try {
                this.progressSize = array.getDimensionPixelSize(R.styleable.ExRecyclerView_erv_progressSize, context.getResources().getDimensionPixelSize(R.dimen.base_progress_size));
                borderWidth = array.getDimensionPixelSize(R.styleable.ExRecyclerView_erv_progressBorderWidth, context.getResources().getDimensionPixelSize(R.dimen.base_progress_border_width));
                progressColor = array.getColor(R.styleable.ExRecyclerView_erv_progressColor, -1);
                textSize = array.getDimensionPixelSize(R.styleable.ExRecyclerView_erv_textSize, textSize);
                textColor = array.getColor(R.styleable.ExRecyclerView_erv_textColor, textColor);
                this.textDefault = array.getString(R.styleable.ExRecyclerView_erv_textDefault);
                this.textPadding = array.getDimensionPixelSize(R.styleable.ExRecyclerView_erv_textPadding, this.textPadding);
                this.backgroundDrawable = array.getDrawable(R.styleable.ExRecyclerView_erv_backgroundDrawable);
                this.backgroundDuration = array.getInt(R.styleable.ExRecyclerView_erv_background_duration, 2000);
            }
            finally {
                array.recycle();
            }
        } else {
            this.progressSize = context.getResources().getDimensionPixelSize(R.dimen.base_progress_size);
            borderWidth = context.getResources().getDimensionPixelSize(R.dimen.base_progress_border_width);
        }
        if (progressColor == -1) {
            progressColor = this.getColorPrimary();
        }
        if (textSize == -1) {
            textSize = this.getContext().getResources().getDimensionPixelSize(R.dimen.base_recycler_text_size);
        }
        if (this.textPadding == -1) {
            this.textPadding = context.getResources().getDimensionPixelSize(R.dimen.base_recycler_text_padding);
        }
        if (this.backgroundDrawable == null) {
            this.backgroundDrawable = new ColorDrawable(this.getThemeBackgroundColor());
        }
        if (TextUtils.isEmpty((CharSequence)this.textDefault)) {
            this.textDefault = context.getString(R.string.base_info_items_not_found);
        }
        this.textPaint = new TextPaint(1);
        this.textPaint.setColor(textColor);
        this.textPaint.setTextSize((float)textSize);
        this.progressDrawable = new CircularProgressDrawable(progressColor, (float)borderWidth);
        this.progressDrawable.setCallback((Drawable.Callback)this);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.backgroundDrawable.setBounds(0, 0, w, h);
        this.progressDrawable.setBounds(w / 2 - this.progressSize / 2, h / 2 - this.progressSize / 2, w / 2 + this.progressSize / 2, h / 2 + this.progressSize / 2);
    }

    public OnRecyclerPaginationListener createPaginationListener(OnRecyclerPaginationListener.OnRecyclerPaginationResult listener) {
        this.setPaginationListener(new OnRecyclerPaginationListener(this.getLayoutManager(), 0, listener));
        return this.paginationListener;
    }

    public void setPaginationListener(OnRecyclerPaginationListener scrollListener) {
        if (this.paginationListener != null) {
            this.removeOnScrollListener(this.paginationListener);
        }
        this.paginationListener = scrollListener;
        this.addOnScrollListener(scrollListener);
    }

    public void setPaginationState(boolean isEnable) {
        if (isEnable) {
            this.enablePagination();
        } else {
            this.disablePagination();
        }
    }

    public void enablePagination() {
        if (this.paginationListener != null) {
            this.paginationListener.enablePagination();
        }
    }

    public void disablePagination() {
        if (this.paginationListener != null) {
            this.paginationListener.disablePagination();
        }
    }

    public void setProgressColor(@ColorInt int color) {
        this.progressDrawable.setColor(color);
    }

    public void setTextPadding(int textPadding) {
        this.textPadding = textPadding;
    }

    public void showText(@StringRes int textRes, Object ... arguments) {
        this.showText(this.getContext().getString(textRes, arguments));
    }

    public void showText(@StringRes int textRes) {
        this.showText(this.getContext().getString(textRes));
    }

    public void showText(final String text) {
        if (!ViewUtils.checkSize((View)this)) {
            ViewUtils.preDrawListener((View)this, (Runnable)new Runnable(){

                @Override
                public void run() {
                    if (!ViewUtils.checkSize((View)ExRecyclerView.this)) {
                        Log.e((String)ExRecyclerView.TAG, (String)"showText: show text forbidden, because width or height == 0");
                        return;
                    }
                    ExRecyclerView.this.createTextLayout(text);
                    ExRecyclerView.this.showText(text);
                }
            });
            return;
        }
        this.createTextLayout(text);
        Log.w((String)TAG, (String)"showText: Recycler not init yet");
        this.drawText = true;
        this.drawProgress = false;
        this.postInvalidate();
        if (this.getAdapter() != null && this.getAdapter().getItemCount() != 0) {
            if (this.errorTimer != null) {
                this.errorTimer.dispose();
            }
            this.errorTimer = Observable.timer((long)this.backgroundDuration, (TimeUnit)TimeUnit.MILLISECONDS).subscribe((Consumer)new Consumer<Long>(){

                public void accept(Long aLong) throws Exception {
                    ExRecyclerView.this.hideText();
                }
            });
        }
    }

    public void hideText() {
        this.drawText = false;
        this.postInvalidate();
    }

    public void showProgress() {
        this.drawProgress = true;
        this.drawText = false;
        this.progressDrawable.start();
        this.postInvalidate();
    }

    public void hideProgress() {
        this.drawProgress = false;
        this.progressDrawable.stop();
        this.postInvalidate();
    }

    public void hideAll() {
        this.drawProgress = false;
        this.drawText = false;
        this.postInvalidate();
    }

    private void createTextLayout(CharSequence text) {
        this.staticLayout = new StaticLayout(text, this.textPaint, this.getWidth() - this.textPadding * 2, Layout.Alignment.ALIGN_CENTER, 1.0f, 0.0f, true);
    }

    public void draw(Canvas c) {
        int restore;
        super.draw(c);
        if ((this.drawProgress || this.drawText) && this.getAdapter() != null && this.getAdapter().getItemCount() > 0) {
            restore = c.save();
            this.backgroundDrawable.draw(c);
            c.restoreToCount(restore);
        }
        if (this.drawProgress) {
            this.progressDrawable.draw(c);
        }
        if (this.drawText && this.staticLayout != null) {
            restore = c.save();
            c.translate((float)(c.getWidth() / 2 - this.staticLayout.getWidth() / 2), (float)(c.getHeight() / 2 - this.staticLayout.getHeight() / 2));
            this.staticLayout.draw(c);
            c.restoreToCount(restore);
        }
    }

    protected boolean verifyDrawable(@NonNull Drawable who) {
        return who == this.progressDrawable || super.verifyDrawable(who);
    }

    public boolean canScrollVertically(int direction) {
        if (direction < 1) {
            boolean original = super.canScrollVertically(direction);
            return !original && this.getChildAt(0) != null && this.getChildAt(0).getTop() < 0 || original;
        }
        return super.canScrollVertically(direction);
    }

    private int getThemeBackgroundColor() {
        TypedValue a = new TypedValue();
        this.getContext().getTheme().resolveAttribute(16842836, a, true);
        if (a.type >= 28 && a.type <= 31) {
            return a.data;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getColorPrimary() {
        int progressColor;
        TypedValue typedValue = new TypedValue();
        TypedArray a = this.getContext().obtainStyledAttributes(typedValue.data, new int[]{R.attr.colorPrimary});
        try {
            progressColor = a.getColor(0, -16777216);
        }
        finally {
            a.recycle();
        }
        return progressColor;
    }
}

