/*
 * Decompiled with CFR 0.152.
 */
package com.artemkopan.recycler.decoration;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.support.v7.widget.RecyclerView;
import android.view.View;

public class SpaceItemDecoration
extends RecyclerView.ItemDecoration {
    private int space;
    private boolean isHorizontal = true;
    private boolean addFirst = true;
    private boolean addLast = true;

    public SpaceItemDecoration(int space) {
        this.space = space;
    }

    public SpaceItemDecoration(int space, boolean addFirst, boolean addLast) {
        this.space = space;
        this.addFirst = addFirst;
        this.addLast = addLast;
    }

    public SpaceItemDecoration setHorizontal(boolean horizontal) {
        this.isHorizontal = horizontal;
        return this;
    }

    public SpaceItemDecoration setAddFirst(boolean addFirst) {
        this.addFirst = addFirst;
        return this;
    }

    public SpaceItemDecoration setAddLast(boolean addLast) {
        this.addLast = addLast;
        return this;
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        if (this.addFirst && parent.getChildLayoutPosition(view) == 0) {
            if (this.isHorizontal) {
                outRect.left = this.space;
            } else {
                outRect.top = this.space;
            }
        }
        if (!this.addLast || parent.getChildLayoutPosition(view) == parent.getAdapter().getItemCount() - 1) {
            if (this.isHorizontal) {
                outRect.right = this.space;
            } else {
                outRect.bottom = this.space;
            }
        }
    }

    public void onDraw(Canvas c, RecyclerView parent, RecyclerView.State state) {
        super.onDraw(c, parent, state);
    }
}

