/*
 * Decompiled with CFR 0.152.
 */
package com.artemkopan.recycler.adapter;

import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.ViewGroup;
import com.artemkopan.recycler.adapter.RecyclerAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class RecyclerBaseAdapter<M, VH extends RecyclerView.ViewHolder>
extends RecyclerAdapter<M, VH> {
    private static final String TAG = "RecyclerBaseAdapter";
    protected List<M> mList;

    public RecyclerBaseAdapter() {
    }

    public RecyclerBaseAdapter(List<M> list) {
        this.mList = list;
    }

    public abstract VH onCreateViewHolder(ViewGroup var1, int var2);

    @Nullable
    public M removeItem(Object model) {
        int index = this.mList.indexOf(model);
        if (index != -1) {
            return this.removeItem(index);
        }
        return null;
    }

    public M removeItem(int position) {
        M model = this.mList.remove(position);
        this.notifyItemRemoved(position);
        return model;
    }

    public void addItem(M model) {
        this.mList.add(model);
        this.notifyItemInserted(this.mList.size() - 1);
    }

    public void addItem(int position, M model) {
        this.mList.add(position, model);
        this.notifyItemInserted(position);
    }

    public void addItemRanged(Collection<M> collection) {
        if (collection == null) {
            Log.e((String)TAG, (String)"Collection is empty");
            return;
        }
        int size = this.mList.size();
        this.mList.addAll(collection);
        this.notifyItemRangeInserted(size, this.mList.size() - size);
    }

    public void moveItem(int fromPosition, int toPosition) {
        M model = this.mList.remove(fromPosition);
        this.mList.add(toPosition, model);
        this.notifyItemMoved(fromPosition, toPosition);
    }

    public void clear() {
        if (this.mList != null) {
            this.mList.clear();
            this.notifyDataSetChanged();
        }
    }

    public List<M> getList() {
        return this.mList;
    }

    public void setList(List<M> list) {
        this.setList(list, true);
    }

    public void setList(List<M> list, boolean notify) {
        if (this.mList != null && this.mList.isEmpty()) {
            this.mList.clear();
        }
        this.mList = list;
        if (notify) {
            this.notifyDataSetChanged();
        }
    }

    public void setList(Collection<M> list, boolean notify) {
        if (this.mList == null) {
            this.mList = new ArrayList<M>();
            this.mList.addAll(list);
        } else {
            this.mList.clear();
            this.mList.addAll(list);
        }
        this.notifyDataSetChanged();
    }

    public void createList(boolean dropList) {
        if (this.mList != null && !dropList) {
            return;
        }
        this.setList(new ArrayList());
    }

    public int getItemIndex(Object object) {
        return this.mList != null ? this.mList.indexOf(object) : -1;
    }

    @Override
    public int getListSize() {
        return this.mList != null ? this.mList.size() : 0;
    }

    @Override
    @Nullable
    protected M getListItemByPos(int position) {
        if (position >= this.getList().size() || position < 0) {
            Log.w((String)TAG, (String)"Index is out of bounds");
            return null;
        }
        return this.mList.get(position);
    }
}

