/*
 * Decompiled with CFR 0.152.
 */
package com.arlib.floatingsearchview.suggestions;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.arlib.floatingsearchview.R;
import com.arlib.floatingsearchview.suggestions.model.SearchSuggestion;
import com.arlib.floatingsearchview.util.Util;
import java.util.ArrayList;
import java.util.List;

public class SearchSuggestionsAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private static final String TAG = "SearchSuggestionsAdapter";
    private List<? extends SearchSuggestion> mSearchSuggestions = new ArrayList<SearchSuggestion>();
    private Listener mListener;
    private Context mContext;
    private Drawable mRightIconDrawable;
    private boolean mShowRightMoveUpBtn = false;
    private int mBodyTextSizePx;
    private int mTextColor = -1;
    private int mRightIconColor = -1;
    private OnBindSuggestionCallback mOnBindSuggestionCallback;

    public SearchSuggestionsAdapter(Context context, int suggestionTextSize, Listener listener) {
        this.mContext = context;
        this.mListener = listener;
        this.mBodyTextSizePx = suggestionTextSize;
        this.mRightIconDrawable = Util.getWrappedDrawable(this.mContext, R.drawable.ic_arrow_back_black_24dp);
        DrawableCompat.setTint((Drawable)this.mRightIconDrawable, (int)Util.getColor(this.mContext, R.color.gray_active_icon));
    }

    public void swapData(List<? extends SearchSuggestion> searchSuggestions) {
        this.mSearchSuggestions = searchSuggestions;
        this.notifyDataSetChanged();
    }

    public List<? extends SearchSuggestion> getDataSet() {
        return this.mSearchSuggestions;
    }

    public void setOnBindSuggestionCallback(OnBindSuggestionCallback callback) {
        this.mOnBindSuggestionCallback = callback;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup viewGroup, int i) {
        View view = LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.search_suggestion_item, viewGroup, false);
        SearchSuggestionViewHolder viewHolder = new SearchSuggestionViewHolder(view, new SearchSuggestionViewHolder.Listener(){

            @Override
            public void onItemClicked(int adapterPosition) {
                if (SearchSuggestionsAdapter.this.mListener != null) {
                    SearchSuggestionsAdapter.this.mListener.onItemSelected((SearchSuggestion)SearchSuggestionsAdapter.this.mSearchSuggestions.get(adapterPosition));
                }
            }

            @Override
            public void onMoveItemToSearchClicked(int adapterPosition) {
                if (SearchSuggestionsAdapter.this.mListener != null) {
                    SearchSuggestionsAdapter.this.mListener.onMoveItemToSearchClicked((SearchSuggestion)SearchSuggestionsAdapter.this.mSearchSuggestions.get(adapterPosition));
                }
            }
        });
        viewHolder.rightIcon.setImageDrawable(this.mRightIconDrawable);
        viewHolder.body.setTextSize(0, (float)this.mBodyTextSizePx);
        return viewHolder;
    }

    public void onBindViewHolder(RecyclerView.ViewHolder vh, int position) {
        SearchSuggestionViewHolder viewHolder = (SearchSuggestionViewHolder)vh;
        if (!this.mShowRightMoveUpBtn) {
            viewHolder.rightIcon.setEnabled(false);
            viewHolder.rightIcon.setVisibility(4);
        } else {
            viewHolder.rightIcon.setEnabled(true);
            viewHolder.rightIcon.setVisibility(0);
        }
        SearchSuggestion suggestionItem = this.mSearchSuggestions.get(position);
        viewHolder.body.setText((CharSequence)suggestionItem.getBody());
        if (this.mTextColor != -1) {
            viewHolder.body.setTextColor(this.mTextColor);
        }
        if (this.mRightIconColor != -1) {
            Util.setIconColor(viewHolder.rightIcon, this.mRightIconColor);
        }
        if (this.mOnBindSuggestionCallback != null) {
            this.mOnBindSuggestionCallback.onBindSuggestion(viewHolder.itemView, viewHolder.leftIcon, viewHolder.body, suggestionItem, position);
        }
    }

    public int getItemCount() {
        return this.mSearchSuggestions != null ? this.mSearchSuggestions.size() : 0;
    }

    public void setTextColor(int color2) {
        boolean notify = false;
        if (this.mTextColor != color2) {
            notify = true;
        }
        this.mTextColor = color2;
        if (notify) {
            this.notifyDataSetChanged();
        }
    }

    public void setRightIconColor(int color2) {
        boolean notify = false;
        if (this.mRightIconColor != color2) {
            notify = true;
        }
        this.mRightIconColor = color2;
        if (notify) {
            this.notifyDataSetChanged();
        }
    }

    public void setShowMoveUpIcon(boolean show) {
        boolean notify = false;
        if (this.mShowRightMoveUpBtn != show) {
            notify = true;
        }
        this.mShowRightMoveUpBtn = show;
        if (notify) {
            this.notifyDataSetChanged();
        }
    }

    public static class SearchSuggestionViewHolder
    extends RecyclerView.ViewHolder {
        public TextView body;
        public ImageView leftIcon;
        public ImageView rightIcon;
        private Listener mListener;

        public SearchSuggestionViewHolder(View v, Listener listener) {
            super(v);
            this.mListener = listener;
            this.body = (TextView)v.findViewById(R.id.body);
            this.leftIcon = (ImageView)v.findViewById(R.id.left_icon);
            this.rightIcon = (ImageView)v.findViewById(R.id.right_icon);
            this.rightIcon.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    int adapterPosition = SearchSuggestionViewHolder.this.getAdapterPosition();
                    if (SearchSuggestionViewHolder.this.mListener != null && adapterPosition != -1) {
                        SearchSuggestionViewHolder.this.mListener.onMoveItemToSearchClicked(SearchSuggestionViewHolder.this.getAdapterPosition());
                    }
                }
            });
            this.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    int adapterPosition = SearchSuggestionViewHolder.this.getAdapterPosition();
                    if (SearchSuggestionViewHolder.this.mListener != null && adapterPosition != -1) {
                        SearchSuggestionViewHolder.this.mListener.onItemClicked(adapterPosition);
                    }
                }
            });
        }

        public static interface Listener {
            public void onItemClicked(int var1);

            public void onMoveItemToSearchClicked(int var1);
        }
    }

    public static interface Listener {
        public void onItemSelected(SearchSuggestion var1);

        public void onMoveItemToSearchClicked(SearchSuggestion var1);
    }

    public static interface OnBindSuggestionCallback {
        public void onBindSuggestion(View var1, ImageView var2, TextView var3, SearchSuggestion var4, int var5);
    }
}

