/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.pagefactory.bys.builder;

import io.appium.java_client.pagefactory.bys.builder.AnnotatedElementContainer;
import io.appium.java_client.pagefactory.bys.builder.ByAll;
import io.appium.java_client.pagefactory.bys.builder.ByChained;
import io.appium.java_client.pagefactory.bys.builder.HowToUseSelectors;
import io.appium.java_client.pagefactory.bys.builder.Strategies;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.support.pagefactory.AbstractAnnotations;

public abstract class AppiumByBuilder
extends AbstractAnnotations {
    protected static final Class<?>[] DEFAULT_ANNOTATION_METHOD_ARGUMENTS = new Class[0];
    private static final List<String> METHODS_TO_BE_EXCLUDED_WHEN_ANNOTATION_IS_READ = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            List objectClassMethodNames = AppiumByBuilder.getMethodNames(Object.class.getDeclaredMethods());
            this.addAll(objectClassMethodNames);
            List annotationClassMethodNames = AppiumByBuilder.getMethodNames(Annotation.class.getDeclaredMethods());
            annotationClassMethodNames.removeAll(objectClassMethodNames);
            this.addAll(annotationClassMethodNames);
        }
    };
    protected final AnnotatedElementContainer annotatedElementContainer = new AnnotatedElementContainer();
    protected final String platform;
    protected final String automation;

    protected AppiumByBuilder(String platform, String automation) {
        this.platform = String.valueOf(platform);
        this.automation = String.valueOf(automation);
    }

    private static List<String> getMethodNames(Method[] methods) {
        ArrayList<String> names = new ArrayList<String>();
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            names.add(m.getName());
            ++n2;
        }
        return names;
    }

    private static Method[] prepareAnnotationMethods(Class<? extends Annotation> annotation) {
        List<String> targeAnnotationMethodNamesList = AppiumByBuilder.getMethodNames(annotation.getDeclaredMethods());
        targeAnnotationMethodNamesList.removeAll(METHODS_TO_BE_EXCLUDED_WHEN_ANNOTATION_IS_READ);
        Method[] result = new Method[targeAnnotationMethodNamesList.size()];
        for (String methodName : targeAnnotationMethodNamesList) {
            try {
                result[targeAnnotationMethodNamesList.indexOf((Object)methodName)] = annotation.getMethod(methodName, DEFAULT_ANNOTATION_METHOD_ARGUMENTS);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    private static String getFilledValue(Annotation mobileBy) {
        Method[] values;
        Method[] methodArray = values = AppiumByBuilder.prepareAnnotationMethods(mobileBy.getClass());
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Method value = methodArray[n2];
            if (String.class.equals(value.getReturnType())) {
                try {
                    String strategyParameter = value.invoke((Object)mobileBy, new Object[0]).toString();
                    if (!strategyParameter.isEmpty()) {
                        return value.getName();
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            ++n2;
        }
        throw new IllegalArgumentException("@" + mobileBy.getClass().getSimpleName() + ": one of " + Strategies.strategiesNames().toString() + " should be filled");
    }

    private static By getMobileBy(Annotation annotation, String valueName) {
        Strategies[] strategies;
        Strategies[] strategiesArray = strategies = Strategies.values();
        int n = strategies.length;
        int n2 = 0;
        while (n2 < n) {
            Strategies strategy = strategiesArray[n2];
            if (strategy.returnValueName().equals(valueName)) {
                return strategy.getBy(annotation);
            }
            ++n2;
        }
        throw new IllegalArgumentException("@" + annotation.getClass().getSimpleName() + ": There is an unknown strategy " + valueName);
    }

    private static <T extends By> T getComplexMobileBy(Annotation[] annotations, Class<T> requiredByClass) {
        By[] byArray = new By[annotations.length];
        int i = 0;
        while (i < annotations.length) {
            byArray[i] = AppiumByBuilder.getMobileBy(annotations[i], AppiumByBuilder.getFilledValue(annotations[i]));
            ++i;
        }
        try {
            Constructor<T> c = requiredByClass.getConstructor(By[].class);
            Object[] values = new Object[]{byArray};
            return (T)((By)c.newInstance(values));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected static By createBy(Annotation[] annotations, HowToUseSelectors howToUseLocators) {
        if (annotations == null || annotations.length == 0) {
            return null;
        }
        switch (howToUseLocators) {
            case USE_ONE: {
                return AppiumByBuilder.getMobileBy(annotations[0], AppiumByBuilder.getFilledValue(annotations[0]));
            }
            case BUILD_CHAINED: {
                return AppiumByBuilder.getComplexMobileBy(annotations, ByChained.class);
            }
            case USE_ANY: {
                return AppiumByBuilder.getComplexMobileBy(annotations, ByAll.class);
            }
        }
        return null;
    }

    public void setAnnotated(AnnotatedElement annotated) {
        this.annotatedElementContainer.setAnnotated(annotated);
    }

    protected boolean isAndroid() {
        return "Android".equalsIgnoreCase(this.platform);
    }

    protected boolean isIOS() {
        return "iOS".equalsIgnoreCase(this.platform);
    }

    protected boolean isTvOS() {
        return "tvOS".equalsIgnoreCase(this.platform);
    }

    protected boolean isIOSXcuit() {
        return this.isIOS() && "XCuiTest".equalsIgnoreCase(this.automation);
    }

    protected boolean isWindows() {
        return "Windows".equalsIgnoreCase(this.platform);
    }

    public abstract By buildBy();

    public abstract boolean isLookupCached();

    protected abstract By buildDefaultBy();

    protected abstract By buildMobileNativeBy();

    protected abstract void assertValidAnnotations();
}

