/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.android.options.server;

import io.appium.java_client.internal.CapabilityHelpers;
import io.appium.java_client.remote.options.BaseMapOptionData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class EspressoBuildConfig
extends BaseMapOptionData<EspressoBuildConfig> {
    public static final String TOOLS_VERSION = "toolsVersions";
    public static final String ADDITIONAL_APP_DEPENDENCIES = "additionalAppDependencies";
    public static final String ADDITIONAL_ANDROID_TEST_DEPENDENCIES = "additionalAndroidTestDependencies";

    public EspressoBuildConfig() {
    }

    public EspressoBuildConfig(String json) {
        super(json);
    }

    private EspressoBuildConfig assignToolsVersionsField(String name, Object value) {
        Optional toolsVersionsOptional = this.getOptionValue(TOOLS_VERSION);
        Map toolsVersions = toolsVersionsOptional.orElseGet(HashMap::new);
        toolsVersions.put(name, value);
        if (!toolsVersionsOptional.isPresent()) {
            this.assignOptionValue(TOOLS_VERSION, toolsVersions);
        }
        return this;
    }

    private <R> Optional<R> getToolsVersionsFieldValue(String name) {
        Optional toolsVersionsOptional = this.getOptionValue(TOOLS_VERSION);
        return toolsVersionsOptional.map(v -> v.getOrDefault(name, null));
    }

    public EspressoBuildConfig withGradleVersion(String version) {
        return this.assignToolsVersionsField("gradle", version);
    }

    public Optional<String> getGradleVersion() {
        return this.getToolsVersionsFieldValue("gradle");
    }

    public EspressoBuildConfig withAndroidGradlePluginVersion(String version) {
        return this.assignToolsVersionsField("androidGradlePlugin", version);
    }

    public Optional<String> getAndroidGradlePluginVersion() {
        return this.getToolsVersionsFieldValue("androidGradlePlugin");
    }

    public EspressoBuildConfig withBuildToolsVersion(String version) {
        return this.assignToolsVersionsField("buildTools", version);
    }

    public Optional<String> getBuildToolsVersion() {
        return this.getToolsVersionsFieldValue("buildTools");
    }

    public EspressoBuildConfig withCompileSdkVersion(String version) {
        return this.assignToolsVersionsField("compileSdk", version);
    }

    public Optional<String> getCompileSdkVersion() {
        return this.getToolsVersionsFieldValue("compileSdk");
    }

    public EspressoBuildConfig withMinSdk(int apiLevel) {
        return this.assignToolsVersionsField("minSdk", apiLevel);
    }

    public Optional<Integer> getMinSdkVersion() {
        Optional result = this.getToolsVersionsFieldValue("minSdk");
        return result.map(CapabilityHelpers::toInteger);
    }

    public EspressoBuildConfig withTargetSdk(int apiLevel) {
        return this.assignToolsVersionsField("targetSdk", apiLevel);
    }

    public Optional<Integer> getTargetSdkVersion() {
        Optional result = this.getToolsVersionsFieldValue("targetSdk");
        return result.map(CapabilityHelpers::toInteger);
    }

    public EspressoBuildConfig withKotlinVersion(String version) {
        return this.assignToolsVersionsField("kotlin", version);
    }

    public Optional<String> getKotlinVersion() {
        return this.getToolsVersionsFieldValue("kotlin");
    }

    public EspressoBuildConfig withAdditionalAppDependencies(List<String> dependencies) {
        return (EspressoBuildConfig)this.assignOptionValue(ADDITIONAL_APP_DEPENDENCIES, dependencies);
    }

    public Optional<List<String>> getAdditionalAppDependencies() {
        return this.getOptionValue(ADDITIONAL_APP_DEPENDENCIES);
    }

    public EspressoBuildConfig withAdditionalAndroidTestDependencies(List<String> dependencies) {
        return (EspressoBuildConfig)this.assignOptionValue(ADDITIONAL_ANDROID_TEST_DEPENDENCIES, dependencies);
    }

    public Optional<List<String>> getAdditionalAndroidTestDependencies() {
        return this.getOptionValue(ADDITIONAL_ANDROID_TEST_DEPENDENCIES);
    }
}

