/*
 * Decompiled with CFR 0.152.
 */
package com.aita.aitawidgetlibrary.view;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.support.annotation.NonNull;
import android.support.v7.widget.CardView;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.aita.aitawidgetlibrary.R;
import com.aita.aitawidgetlibrary.analytics.WidgetTracker;
import com.aita.aitawidgetlibrary.model.WidgetFlight;
import de.hdodenhof.circleimageview.CircleImageView;

public abstract class WidgetView
extends RelativeLayout {
    protected Context mContext;
    protected CardView mWidgetCardView;
    protected TextView mWidgetTitle;
    protected TextView mWidgetSubtitle;
    protected ViewStub mWidgetViewStub;
    protected CircleImageView mWidgetIcon;
    protected WidgetFlight mFlight;
    protected WidgetTracker mTracker;

    public WidgetView(Context context) {
        super(context);
        WidgetView.inflate((Context)context, (int)R.layout.view_feed_card, (ViewGroup)this);
        this.init();
    }

    public WidgetView(Context context, AttributeSet attrs) {
        super(context, attrs);
        WidgetView.inflate((Context)context, (int)R.layout.view_feed_card, (ViewGroup)this);
        this.init();
    }

    public WidgetView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        WidgetView.inflate((Context)context, (int)R.layout.view_feed_card, (ViewGroup)this);
        this.init();
    }

    public void setFlight(@NonNull WidgetFlight flight) {
        this.mFlight = flight;
        this.setUpWidget();
    }

    public void setTracker(@NonNull WidgetTracker tracker) {
        this.mTracker = tracker;
    }

    public void update(@NonNull WidgetFlight flight) {
        this.mFlight = flight;
        this.update();
    }

    private void init() {
        AssetManager assets;
        this.mWidgetCardView = (CardView)this.findViewById(R.id.widget_card_view);
        this.mWidgetTitle = (TextView)this.findViewById(R.id.widget_title);
        this.mWidgetSubtitle = (TextView)this.findViewById(R.id.widget_subtitle);
        this.mWidgetViewStub = (ViewStub)this.findViewById(R.id.widget_viewstub);
        this.mWidgetIcon = (CircleImageView)this.findViewById(R.id.widget_icon);
        this.mContext = this.getContext();
        if (this.mContext != null && (assets = this.mContext.getAssets()) != null) {
            Typeface robotoLightTypeface = Typeface.createFromAsset((AssetManager)assets, (String)"fonts/Roboto-Light.ttf");
            this.mWidgetTitle.setTypeface(robotoLightTypeface);
            this.mWidgetSubtitle.setTypeface(robotoLightTypeface);
        }
        this.mWidgetTitle.setText((CharSequence)this.getWidgetTitleText());
        this.mWidgetSubtitle.setText((CharSequence)this.getWidgetSubtitleText());
        this.mWidgetIcon.setImageResource(this.getWidgetIconId());
        this.mWidgetViewStub.setLayoutResource(this.getWidgetViewId());
        this.mWidgetViewStub.inflate();
    }

    protected void sendEvent(String action) {
        this.sendEvent(action, null);
    }

    protected void sendEvent(String action, String label) {
        if (this.mTracker != null) {
            this.mTracker.sendEvent(action, label);
        }
    }

    public abstract void update();

    protected abstract void setUpWidget();

    @NonNull
    protected abstract String getWidgetTitleText();

    @NonNull
    protected abstract String getWidgetSubtitleText();

    protected abstract int getWidgetIconId();

    protected abstract int getWidgetViewId();
}

